/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscClaimSendYcCancelReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscClaimSendYcCancelRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.bo.FscClaimSendYcCancelBO;
import com.tydic.fsc.common.busi.api.FscClaimSendYcCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimSendYcCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimSendYcCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscClaimSendYcCancelBusiServiceImpl
implements FscClaimSendYcCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimSendYcCancelBusiServiceImpl.class);
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @Override
    public FscClaimSendYcCancelBusiRspBO dealCancelClaim(FscClaimSendYcCancelBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCancelList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[cancelList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<FscClaimDetailPO> updateList = new ArrayList<FscClaimDetailPO>();
        StringBuilder sb = new StringBuilder();
        for (FscClaimSendYcCancelBO fscClaimSendYcCancelBO : reqBO.getCancelList()) {
            FscClaimDetailPO detailPO = new FscClaimDetailPO();
            try {
                if (StringUtils.isEmpty((Object)fscClaimSendYcCancelBO.getCLAIM_TESCO_ID())) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[CLAIM_TESCO_ID]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                FscClaimSendYcCancelReqBO cancelReqBO = new FscClaimSendYcCancelReqBO();
                cancelReqBO.setCLAIM_TESCO_ID(fscClaimSendYcCancelBO.getCLAIM_TESCO_ID());
                cancelReqBO.setCANCEL_CLAIM_DATE(fscClaimSendYcCancelBO.getCANCEL_CLAIM_DATE());
                FscClaimSendYcCancelRspBO cancelRspBO = this.fscClaimSendYcCancelService.cancelClaim(cancelReqBO);
                detailPO.setClaimDetailId(Long.valueOf(fscClaimSendYcCancelBO.getCLAIM_TESCO_ID()));
                FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
                logAbilityReqBO.setCreateTime(new Date());
                logAbilityReqBO.setObjectId(Long.valueOf(fscClaimSendYcCancelBO.getCLAIM_TESCO_ID()));
                logAbilityReqBO.setType(FscConstants.FscPushType.CLAIM);
                logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)cancelReqBO));
                if (!cancelRspBO.getRespCode().equals("0000")) {
                    log.error("\u63a8\u9001\u4e1a\u8d22\u53d6\u6d88\u8ba4\u9886\u5931\u8d25\uff01" + cancelRspBO.getRespDesc());
                    detailPO.setPushStatus(Integer.valueOf(0));
                    detailPO.setFailReason(cancelRspBO.getRespDesc());
                    updateList.add(detailPO);
                    sb.append(fscClaimSendYcCancelBO.getCLAIM_TESCO_ID() + "\u63a8\u9001\u5931\u8d25\uff01" + cancelRspBO.getRespDesc());
                    logAbilityReqBO.setStatus(Integer.valueOf(0));
                } else {
                    detailPO.setPushStatus(Integer.valueOf(1));
                    updateList.add(detailPO);
                    logAbilityReqBO.setStatus(Integer.valueOf(1));
                }
                this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u4e1a\u8d22\u53d6\u6d88\u8ba4\u9886\u5931\u8d25\uff01" + e);
                detailPO.setPushStatus(Integer.valueOf(1));
                detailPO.setFailReason(e.getMessage());
                updateList.add(detailPO);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.fscClaimDetailMapper.updatePushStatusBatch(updateList);
        }
        FscClaimSendYcCancelBusiRspBO rspBO = new FscClaimSendYcCancelBusiRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }
}

