/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderRefundCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderRefundCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderRefundCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderRefundCancelBusiServiceImpl
implements FscComOrderRefundCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderRefundCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private PebExtUpdateAbnormalRefundFlagAbilityService pebExtUpdateAbnormalRefundFlagAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    public static final String BUSI_NAME = "\u9000\u7968\u5355\u53d6\u6d88";
    public static final Integer REFUND_FLAG_NO = 0;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscBillOrderRefundChangeAtomService fscBillOrderRefundChangeAtomService;

    @Override
    public FscComOrderRefundCancelBusiRspBO dealOrderRefundCancel(FscComOrderRefundCancelBusiReqBO reqBO) {
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundIdList(reqBO.getRefundIds());
        List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
        }
        List cantDeleteList = fscOrderRefundPOList.stream().filter(t -> !FscConstants.RefundInvoiceStatus.TO_REFUND.equals(t.getRefundStatus()) && !FscConstants.RefundInvoiceStatus.APPROVAL_REJECT.equals(t.getRefundStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(cantDeleteList)) {
            String errInfo = cantDeleteList.stream().map(FscOrderRefundPO::getRefundNo).collect(Collectors.joining(","));
            throw new FscBusinessException("190000", "\u5355\u636e\uff1a" + errInfo + "\u6240\u5728\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u3002");
        }
        List fscOrderIdList = fscOrderRefundPOList.stream().map(FscOrderRefundPO::getFscOrderId).collect(Collectors.toList());
        FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
        fscInvoiceRefundRelationPO.setFscOrderIdList(fscOrderIdList);
        List fscInvoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.getList(fscInvoiceRefundRelationPO);
        List invoiceIdList = fscInvoiceRefundRelationPOList.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
        FscInvoicePO setPO = new FscInvoicePO();
        setPO.setRefundFlag(REFUND_FLAG_NO);
        setPO.setStatus(FscConstants.FscInvoiceStatus.VALID);
        setPO.setUpdateTime(new Date());
        if (reqBO.getUserId() != null) {
            setPO.setUpdateOperId(reqBO.getUserId().toString());
        }
        FscInvoicePO wherePO = new FscInvoicePO();
        wherePO.setInvoiceIds(invoiceIdList);
        this.fscInvoiceMapper.updateBy(setPO, wherePO);
        for (FscOrderRefundPO orderRefundPO : fscOrderRefundPOList) {
            if (!FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(orderRefundPO.getRefundReasonType().toString())) continue;
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setRefundId(orderRefundPO.getRefundId());
            List fscOrderRelationPOList = this.fscOrderRelationMapper.getListOnly(fscOrderRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) continue;
            Map<Long, Long> abnormalMap = fscOrderRelationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getAbnormalVoucherId, FscOrderRelationPO::getOrderId));
            PebExtUpdateAbnormalRefundFlagReqBO refundFlagReqBO = new PebExtUpdateAbnormalRefundFlagReqBO();
            refundFlagReqBO.setReceiveType(orderRefundPO.getReceiveType());
            refundFlagReqBO.setAbnormalMap(abnormalMap);
            refundFlagReqBO.setRefundFlag(FscConstants.FscRefundFlag.NO);
            PebExtUpdateAbnormalRefundFlagRspBO refundFlagRspBO = this.pebExtUpdateAbnormalRefundFlagAbilityService.updateAbnormalFlag(refundFlagReqBO);
            if (refundFlagRspBO.getRespCode().equals("0000")) continue;
            throw new FscBusinessException(refundFlagRspBO.getRespCode(), "\u540c\u6b65\u5f02\u5e38\u8ba2\u5355\u9000\u7968\u72b6\u6001\u5931\u8d25:" + refundFlagRspBO.getRespDesc());
        }
        for (FscOrderRefundPO refundPO : fscOrderRefundPOList) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.CANCEL_ORDER);
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(refundPO.getRefundId());
            flowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(flowAtomReqBO);
            if ("0000".equals(flowAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
        FscComOrderRefundCancelBusiRspBO rspBO = new FscComOrderRefundCancelBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscComOrderRefundCancelBusiRspBO dealRefactorOrderRefundCancel(FscComOrderRefundCancelBusiReqBO reqBO) {
        int count;
        FscInvoiceItemPO itemPO;
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!(refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.TO_REFUND) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.REFUND_BACK) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.YC_REJECT) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.AUDITING) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.AUDIT_PASS) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.PURCHASE_REJECT))) {
            throw new FscBusinessException("198888", "\u5355\u636e\uff1a" + refundPO.getRefundNo() + "\u5f53\u524d\u9000\u7968\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88\uff01");
        }
        if (!refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            FscBillOrderRefundChangeAtomReqBO atomReqBO = new FscBillOrderRefundChangeAtomReqBO();
            atomReqBO.setRefundId(refundPO.getRefundId());
            atomReqBO.setCreateUserId(reqBO.getUserId());
            atomReqBO.setOperationType(Integer.valueOf(2));
            FscBillOrderRefundChangeAtomRspBO atomRspBO = this.fscBillOrderRefundChangeAtomService.recordRefundChange(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8bb0\u5f55\u6838\u9500\u865a\u62df\u53d8\u66f4\u8868\u5931\u8d25" + atomRspBO.getRespDesc());
            }
        }
        Integer settleType = refundPO.getSettleType();
        List beforeOrderItemPOList = new ArrayList();
        List invoiceItemPOList = new ArrayList();
        Boolean isExitInvoiceItem = false;
        FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
        searchOrderItemPO.setRefundId(reqBO.getRefundId());
        searchOrderItemPO.setOrderBy("id");
        beforeOrderItemPOList = this.fscOrderItemMapper.getListNoPage(searchOrderItemPO);
        FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
        searchInvoiceItemPO.setFscOrderId(refundPO.getFscOrderId());
        searchInvoiceItemPO.setOrderBy("ID");
        invoiceItemPOList = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
        if (!CollectionUtils.isEmpty(invoiceItemPOList)) {
            isExitInvoiceItem = true;
        }
        HashMap<Long, BigDecimal> updateInvoiceItemMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> updateFscOrderItemMap = new HashMap<Long, BigDecimal>();
        for (FscOrderItemPO fscOrderItemPO : beforeOrderItemPOList) {
            BigDecimal amt;
            if (isExitInvoiceItem.booleanValue()) {
                if (updateInvoiceItemMap.containsKey(fscOrderItemPO.getInvoiceItemId())) {
                    amt = ((BigDecimal)updateInvoiceItemMap.get(fscOrderItemPO.getInvoiceItemId())).add(fscOrderItemPO.getRefundAmt());
                    updateInvoiceItemMap.put(fscOrderItemPO.getInvoiceItemId(), amt);
                    continue;
                }
                updateInvoiceItemMap.put(fscOrderItemPO.getInvoiceItemId(), fscOrderItemPO.getRefundAmt());
                continue;
            }
            if (updateFscOrderItemMap.containsKey(fscOrderItemPO.getInvoiceItemId())) {
                amt = ((BigDecimal)updateFscOrderItemMap.get(fscOrderItemPO.getInvoiceItemId())).add(fscOrderItemPO.getRefundAmt());
                updateFscOrderItemMap.put(fscOrderItemPO.getId(), amt);
                continue;
            }
            updateFscOrderItemMap.put(fscOrderItemPO.getInvoiceItemId(), fscOrderItemPO.getRefundAmt());
        }
        FscOrderRefundPO updateRefundPO = new FscOrderRefundPO();
        ArrayList<Long> refundIdList = new ArrayList<Long>();
        refundIdList.add(reqBO.getRefundId());
        updateRefundPO.setRefundIdList(reqBO.getRefundIds());
        updateRefundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.DELETE);
        updateRefundPO.setUpdateTime(new Date());
        this.fscOrderRefundMapper.updateByRefundIds(updateRefundPO);
        if (!CollectionUtils.isEmpty(updateInvoiceItemMap)) {
            ArrayList<FscInvoiceItemPO> updateInvoiceItemBOS = new ArrayList<FscInvoiceItemPO>();
            for (Long invoiceItemId : updateInvoiceItemMap.keySet()) {
                itemPO = new FscInvoiceItemPO();
                itemPO.setId(invoiceItemId);
                itemPO.setRefundAmt(((BigDecimal)updateInvoiceItemMap.get(invoiceItemId)).negate());
                updateInvoiceItemBOS.add(itemPO);
            }
            count = this.fscInvoiceItemMapper.updateBatchRefundAmt(updateInvoiceItemBOS);
            if (updateInvoiceItemBOS.size() != count) {
                throw new FscBusinessException("198888", "\u56de\u9000\u53d1\u7968\u91d1\u989d\u4e0d\u6ee1\u8db3\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
        }
        if (!CollectionUtils.isEmpty(updateFscOrderItemMap)) {
            ArrayList<FscInvoiceItemPO> updateFscOrderItemBOS = new ArrayList<FscInvoiceItemPO>();
            for (Long fscOrderItemId : updateFscOrderItemMap.keySet()) {
                itemPO = new FscOrderItemPO();
                itemPO.setId(fscOrderItemId);
                itemPO.setRefundAmt(((BigDecimal)updateFscOrderItemMap.get(fscOrderItemId)).negate());
                updateFscOrderItemBOS.add(itemPO);
            }
            count = this.fscOrderItemMapper.updateBatchRefundAmt(updateFscOrderItemBOS);
            if (updateFscOrderItemBOS.size() != count) {
                throw new FscBusinessException("198888", "\u56de\u9000\u53d1\u7968\u91d1\u989d\u4e0d\u6ee1\u8db3\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
        }
        ArrayList<Object> refundItems = new ArrayList<Object>();
        if (refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            for (FscOrderItemPO orderItemPO : beforeOrderItemPOList) {
                PebExtUpdateAbnormalRefundItemBO itemBO = new PebExtUpdateAbnormalRefundItemBO();
                itemBO.setAbnormalVoucherId(orderItemPO.getAbnormalVoucherId());
                itemBO.setOrderId(orderItemPO.getOrderId());
                if (FscConstants.SettleType.ORDER.equals(settleType)) {
                    itemBO.setInspectionItemId(orderItemPO.getRefundOrderItemId());
                } else {
                    itemBO.setInspectionItemId(orderItemPO.getOrderItemId());
                }
                itemBO.setRefundAmt(BigDecimal.ZERO);
                itemBO.setRefundNum(BigDecimal.ZERO);
                refundItems.add(itemBO);
            }
        }
        if (!CollectionUtils.isEmpty(refundItems)) {
            ArrayList<PebExtUpdateAbnormalRefundItemBO> distRefundItems = new ArrayList<PebExtUpdateAbnormalRefundItemBO>();
            Map<Long, List<PebExtUpdateAbnormalRefundItemBO>> abnormalVoucherIdMap = refundItems.stream().collect(Collectors.groupingBy(PebExtUpdateAbnormalRefundItemBO::getAbnormalVoucherId));
            for (Long abnormalVoucherId : abnormalVoucherIdMap.keySet()) {
                Map<Long, List<PebExtUpdateAbnormalRefundItemBO>> itemIdMap = abnormalVoucherIdMap.get(abnormalVoucherId).stream().collect(Collectors.groupingBy(PebExtUpdateAbnormalRefundItemBO::getInspectionItemId));
                for (Long itemId : itemIdMap.keySet()) {
                    BigDecimal refundAmt = BigDecimal.ZERO;
                    BigDecimal refundNum = BigDecimal.ZERO;
                    for (PebExtUpdateAbnormalRefundItemBO pebExtUpdateAbnormalRefundItemBO : itemIdMap.get(itemId)) {
                        refundAmt = refundAmt.add(pebExtUpdateAbnormalRefundItemBO.getRefundAmt());
                        refundNum = refundNum.add(pebExtUpdateAbnormalRefundItemBO.getRefundNum());
                    }
                    PebExtUpdateAbnormalRefundItemBO pebExtUpdateAbnormalRefundItemBO = itemIdMap.get(itemId).get(0);
                    PebExtUpdateAbnormalRefundItemBO itemBO = new PebExtUpdateAbnormalRefundItemBO();
                    itemBO.setAbnormalVoucherId(pebExtUpdateAbnormalRefundItemBO.getAbnormalVoucherId());
                    itemBO.setOrderId(pebExtUpdateAbnormalRefundItemBO.getOrderId());
                    itemBO.setInspectionItemId(pebExtUpdateAbnormalRefundItemBO.getInspectionItemId());
                    itemBO.setRefundAmt(refundAmt);
                    itemBO.setRefundNum(refundNum);
                    distRefundItems.add(itemBO);
                }
            }
            PebExtUpdateAbnormalRefundFlagReqBO refundFlagReqBO = new PebExtUpdateAbnormalRefundFlagReqBO();
            refundFlagReqBO.setReceiveType(refundPO.getReceiveType());
            refundFlagReqBO.setRefundFlag(FscConstants.FscRefundFlag.YES);
            refundFlagReqBO.setRefundId(refundPO.getRefundId());
            refundFlagReqBO.setRefundItems(distRefundItems);
            log.info("\u540c\u6b65\u5f02\u5e38\u8ba2\u5355\u9000\u7968\u5165\u53c2" + JSONObject.toJSONString((Object)refundFlagReqBO));
            PebExtUpdateAbnormalRefundFlagRspBO rspBO = this.pebExtUpdateAbnormalRefundFlagAbilityService.updateAbnormalFlag(refundFlagReqBO);
            if (!rspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(rspBO.getRespCode(), "\u540c\u6b65\u5f02\u5e38\u8ba2\u5355\u9000\u7968\u72b6\u6001\u5931\u8d25:" + rspBO.getRespDesc());
            }
        }
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.CANCEL_ORDER);
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(refundPO.getRefundId());
        flowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
        ArrayList<Long> fscOrderIdList = new ArrayList<Long>();
        fscOrderIdList.add(refundPO.getFscOrderId());
        FscComOrderRefundCancelBusiRspBO rspBO = new FscComOrderRefundCancelBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

