/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscComRefundListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.busi.api.FscComRefundDetailsQueryBusiService;
import com.tydic.fsc.common.busi.api.FscComRefundSyncEsBusiService;
import com.tydic.fsc.common.busi.bo.FscComRefundDetailsQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComRefundDetailsQueryBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscComRefundListEsSyncReqBO;
import com.tydic.fsc.common.busi.bo.FscComRefundSyncEsBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComRefundSyncEsBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComRefundSyncEsBusiServiceImpl
implements FscComRefundSyncEsBusiService {
    @Autowired
    private FscComRefundDetailsQueryBusiService fscComRefundDetailsQueryBusiService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @Override
    public FscComRefundSyncEsBusiRspBO dealComRefundSyncEs(FscComRefundSyncEsBusiReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)((Object)reqBO));
        FscComRefundDetailsQueryBusiReqBO busiReqBO = (FscComRefundDetailsQueryBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComRefundDetailsQueryBusiReqBO.class));
        FscComRefundDetailsQueryBusiRspBO busiRspBO = this.fscComRefundDetailsQueryBusiService.queryRefundDetail(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + busiRspBO.getRespDesc());
        }
        FscComRefundListEsSyncReqBO syncReqBO = new FscComRefundListEsSyncReqBO();
        this.buildEsSearchCondition(busiRspBO.getRefundListBO(), syncReqBO);
        syncReqBO.setObjJson(JSONObject.toJSONString((Object)busiRspBO.getRefundListBO()));
        FscComRefundSyncEsBusiRspBO rspBO = new FscComRefundSyncEsBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSyncReqBO(syncReqBO);
        return rspBO;
    }

    private void buildEsSearchCondition(FscComRefundListBO refundListBO, FscComRefundListEsSyncReqBO fscComRefundListEsSyncReqBO) {
        fscComRefundListEsSyncReqBO.setPayerId(refundListBO.getPayerId());
        fscComRefundListEsSyncReqBO.setPayerName(refundListBO.getPayerName());
        fscComRefundListEsSyncReqBO.setPayeeId(refundListBO.getPayeeId());
        fscComRefundListEsSyncReqBO.setPayeeName(refundListBO.getPayeeName());
        fscComRefundListEsSyncReqBO.setBuynerName(refundListBO.getBuynerName());
        fscComRefundListEsSyncReqBO.setBuynerNo(refundListBO.getBuynerNo());
        fscComRefundListEsSyncReqBO.setSupplierId(refundListBO.getSupplierId());
        fscComRefundListEsSyncReqBO.setSupplierName(refundListBO.getSupplierName());
        fscComRefundListEsSyncReqBO.setOrderType(refundListBO.getOrderType());
        fscComRefundListEsSyncReqBO.setBusiType(refundListBO.getBusiType());
        fscComRefundListEsSyncReqBO.setFscOrderNo(refundListBO.getFscOrderNo());
        fscComRefundListEsSyncReqBO.setFscOrderId(refundListBO.getFscOrderId());
        fscComRefundListEsSyncReqBO.setFullElecNoList(refundListBO.getFullElecNoList());
        fscComRefundListEsSyncReqBO.setInvoiceNoList(refundListBO.getInvoiceNoList());
        fscComRefundListEsSyncReqBO.setOrderCodeList(refundListBO.getOrderCodeList());
        fscComRefundListEsSyncReqBO.setInvoiceStatus(refundListBO.getInvoiceStatus());
        fscComRefundListEsSyncReqBO.setTotalCharge(refundListBO.getTotalCharge());
        fscComRefundListEsSyncReqBO.setInvoiceAmount(refundListBO.getTotalCharge());
        fscComRefundListEsSyncReqBO.setRefundId(refundListBO.getRefundId());
        fscComRefundListEsSyncReqBO.setRefundNo(refundListBO.getRefundNo());
        fscComRefundListEsSyncReqBO.setRefundStatus(refundListBO.getRefundStatus());
        fscComRefundListEsSyncReqBO.setRefundReasonType(refundListBO.getRefundReasonType());
        fscComRefundListEsSyncReqBO.setBillTime(refundListBO.getBillTime());
        fscComRefundListEsSyncReqBO.setBillDate(refundListBO.getBillDate());
        fscComRefundListEsSyncReqBO.setCreateUserId(refundListBO.getCreateUserId());
        fscComRefundListEsSyncReqBO.setCreateUserName(refundListBO.getCreateUserName());
        fscComRefundListEsSyncReqBO.setAgentUserId(refundListBO.getAgentUserId());
        fscComRefundListEsSyncReqBO.setAgentUserName(refundListBO.getAgentUserName());
        fscComRefundListEsSyncReqBO.setAgentDeptId(refundListBO.getAgentDeptId());
        fscComRefundListEsSyncReqBO.setAgentDeptName(refundListBO.getAgentDeptName());
        fscComRefundListEsSyncReqBO.setActualPaidAmount(refundListBO.getActualPaidAmount());
        fscComRefundListEsSyncReqBO.setOperationName(refundListBO.getOperationName());
        fscComRefundListEsSyncReqBO.setOperationId(refundListBO.getOperatorId());
        fscComRefundListEsSyncReqBO.setOperatorId(refundListBO.getOperatorId());
        fscComRefundListEsSyncReqBO.setOperatorName(refundListBO.getOperatorName());
        fscComRefundListEsSyncReqBO.setSettleType(refundListBO.getSettleType());
        fscComRefundListEsSyncReqBO.setAuditStatus(refundListBO.getAuditStatus());
        fscComRefundListEsSyncReqBO.setMakeType(refundListBO.getMakeType());
        fscComRefundListEsSyncReqBO.setReceiveType(refundListBO.getReceiveType());
        fscComRefundListEsSyncReqBO.setOrderSource(refundListBO.getOrderSource());
        fscComRefundListEsSyncReqBO.setOrderType(refundListBO.getOrderType());
        fscComRefundListEsSyncReqBO.setOrderFlow(refundListBO.getOrderFlow());
        fscComRefundListEsSyncReqBO.setRefundAmount(refundListBO.getRefundAmount());
        fscComRefundListEsSyncReqBO.setOrderNoList(refundListBO.getOrderNoList());
        fscComRefundListEsSyncReqBO.setPurStatus(refundListBO.getPurStatus());
        fscComRefundListEsSyncReqBO.setBuildAction(refundListBO.getBuildAction());
        fscComRefundListEsSyncReqBO.setRefundByNo(refundListBO.getRefundByNo());
        fscComRefundListEsSyncReqBO.setPushUnifyStatus(refundListBO.getPushUnifyStatus());
        fscComRefundListEsSyncReqBO.setPushStatus(refundListBO.getPushStatus());
        fscComRefundListEsSyncReqBO.setRefundRelationBOS(refundListBO.getRefundRelationBOS());
        fscComRefundListEsSyncReqBO.setClaimNo(refundListBO.getClaimNo());
        fscComRefundListEsSyncReqBO.setRefundTime(refundListBO.getCreateTime());
        fscComRefundListEsSyncReqBO.setTradeMode(refundListBO.getTradeMode());
        fscComRefundListEsSyncReqBO.setSettlePlatform(refundListBO.getSettlePlatform());
        fscComRefundListEsSyncReqBO.setUserType(refundListBO.getUserType());
        fscComRefundListEsSyncReqBO.setIsOperateCreate(refundListBO.getIsOperateCreate());
        fscComRefundListEsSyncReqBO.setExt3(refundListBO.getExt3());
        FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
        fscTaskCandidatePO.setFscOrderId(refundListBO.getRefundId());
        List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getAuditedPostIdAndOperIdList(fscTaskCandidatePO);
        List pendAuditPostPOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
        if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
            List<String> auditedPostIdList = auditedPostIdAndOperIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            List<String> auditedTaskOperIdList = auditedPostIdAndOperIdList.stream().map(FscApprovalTaskQueryBO::getOwnOperId).distinct().collect(Collectors.toList());
            String auditedTaskOperNameList = auditedPostIdAndOperIdList.stream().map(FscApprovalTaskQueryBO::getOwnOperName).distinct().collect(Collectors.joining(","));
            fscComRefundListEsSyncReqBO.setAuditedPostIdList(auditedPostIdList);
            fscComRefundListEsSyncReqBO.setAuditedTaskOperIdList(auditedTaskOperIdList);
            fscComRefundListEsSyncReqBO.setAuditedTaskOperNameList(auditedTaskOperNameList);
        }
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostPOList)) {
            List<String> pendAuditPostIdList = pendAuditPostPOList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            fscComRefundListEsSyncReqBO.setTaskOperIdList(pendAuditPostIdList);
        }
        if (refundListBO.getOrderFlow().equals(FscConstants.OrderFlow.REFUND_INVOICE) || refundListBO.getOrderFlow().equals(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE)) {
            fscTaskCandidatePO.setOrderFlow(FscConstants.AuditObjType.REFUND_INVOICE);
        } else {
            fscTaskCandidatePO.setOrderFlow(FscConstants.AuditObjType.REFUND_PAY);
        }
        Long objId = this.fscTaskCandidateMapper.getObjIdByByIdAndType(fscTaskCandidatePO);
        List auditInfoList = this.fscTaskCandidateMapper.getByObjId(objId);
        if (!CollectionUtils.isEmpty((Collection)auditInfoList)) {
            FscApprovalTaskQueryBO fscApprovalTaskQueryBO = (FscApprovalTaskQueryBO)auditInfoList.get(auditInfoList.size() - 1);
            Map auditStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_AUDIT_STATUS");
            if (FscConstants.TaskState.APPROVED.equals(fscApprovalTaskQueryBO.getTaskState())) {
                if (FscConstants.AuditResultFlagKey.PASS.equals(fscApprovalTaskQueryBO.getAuditResult())) {
                    fscComRefundListEsSyncReqBO.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
                    refundListBO.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
                }
                if (FscConstants.AuditResultFlagKey.REFUSE.equals(fscApprovalTaskQueryBO.getAuditResult())) {
                    fscComRefundListEsSyncReqBO.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
                    refundListBO.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
                }
            } else {
                fscComRefundListEsSyncReqBO.setAuditStatus(FscConstants.AuditStatus.AUDITING);
                refundListBO.setAuditStatus(FscConstants.AuditStatus.AUDITING);
            }
            String auditStatusStr = (String)auditStatusMap.get(refundListBO.getAuditStatus() + "");
            refundListBO.setAuditStatusStr(auditStatusStr);
            if (StringUtils.isBlank((CharSequence)((FscApprovalTaskQueryBO)auditInfoList.get(0)).getOwnOperName())) {
                fscComRefundListEsSyncReqBO.setPreviousHandler(refundListBO.getCreateUserName());
                refundListBO.setPreviousHandler(refundListBO.getCreateUserName());
            } else if (!StringUtils.isBlank((CharSequence)fscApprovalTaskQueryBO.getOwnOperName())) {
                fscComRefundListEsSyncReqBO.setPreviousHandler(fscApprovalTaskQueryBO.getOwnOperName());
                refundListBO.setPreviousHandler(fscApprovalTaskQueryBO.getOwnOperName());
            } else {
                int index = Math.max(auditInfoList.size() - 1, 0);
                fscComRefundListEsSyncReqBO.setPreviousHandler(((FscApprovalTaskQueryBO)auditInfoList.get(index)).getOwnOperName());
                refundListBO.setPreviousHandler(((FscApprovalTaskQueryBO)auditInfoList.get(index)).getOwnOperName());
            }
            fscComRefundListEsSyncReqBO.setArrivalTime(fscApprovalTaskQueryBO.getCreateTime());
            fscComRefundListEsSyncReqBO.setAuditTime(fscApprovalTaskQueryBO.getFinishTime());
            refundListBO.setArrivalTime(fscApprovalTaskQueryBO.getCreateTime());
            List<String> ownOperNameList = auditInfoList.stream().map(FscApprovalTaskQueryBO::getOwnOperName).collect(Collectors.toList());
            ownOperNameList = ownOperNameList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            fscComRefundListEsSyncReqBO.setAuditOperName(ownOperNameList);
        }
    }
}

