/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscCreditBalanceInsertAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.umc.constants.UmcEnumConstant;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantCreateBusiService")
public class FscMerchantCreateBusiServiceImpl
implements FscMerchantCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantCreateBusiServiceImpl.class);
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private FscAccountCreateAtomService fscAccountCreateAtomService;
    @Autowired
    private FscCreditBalanceInsertAtomService fscCreditBalanceInsertAtomService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;

    @Override
    public FscMerchantCreateBusiRspBo dealCreate(FscMerchantCreateBusiReqBO reqBo) {
        int result;
        FscMerchantPO merchantPo;
        FscMerchantCreateBusiRspBo retBo = new FscMerchantCreateBusiRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Date nowTime = this.fscMerchantMapper.getDBDate();
        if (reqBo.getExceptionCategory() != null && reqBo.getExceptionFlag() != null && reqBo.getExceptionCategory().equals(2) && reqBo.getExceptionFlag().equals(1) && !StringUtils.isEmpty((Object)reqBo.getPayBusiSceneRange())) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            StringBuilder rangeStr = new StringBuilder();
            String[] range = reqBo.getPayBusiSceneRange().split(",");
            FscMerchantPO fscMerchantPO = new FscMerchantPO();
            fscMerchantPO.setParentId(reqBo.getParentId());
            fscMerchantPO.setExceptionUserLatitude(reqBo.getExceptionUserLatitude());
            fscMerchantPO.setExceptionCategory(Integer.valueOf(2));
            fscMerchantPO.setExceptionFlag(Integer.valueOf(1));
            fscMerchantPO.setDelFlag(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
            fscMerchantPO.setPayObjId(reqBo.getPayObjId());
            List fscMerchantList = this.fscMerchantMapper.getFscMerchantList(fscMerchantPO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantList)) {
                for (FscMerchantPO fscMerchantPO1 : fscMerchantList) {
                    if (fscMerchantPO1.getMerchantId() != null && fscMerchantPO1.getMerchantId().toString().equals(reqBo.getMerchantId())) continue;
                    for (int i = 0; i < range.length; ++i) {
                        if (fscMerchantPO1.getPayBusiSceneRange().indexOf(range[i]) == -1) continue;
                        rangeStr.append(dicMap.get("MERCHANT_BUSI_SCENE").get(range[i]));
                    }
                }
                if (rangeStr.toString().length() > 0) {
                    throw new FscBusinessException("193120", rangeStr.toString() + "\u4e1a\u52a1\u573a\u666f\uff1a\u5df2\u5b58\u5728\u4f8b\u5916\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\uff1b");
                }
            }
        }
        FscAccountAtomReqBO accountAtomReqBo = new FscAccountAtomReqBO();
        accountAtomReqBo.setAccountName(reqBo.getOrgName());
        accountAtomReqBo.setAccountCategory(reqBo.getMerchantCategory());
        accountAtomReqBo.setOrgId(reqBo.getOrgId());
        accountAtomReqBo.setOrgName(reqBo.getOrgName());
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            UmcDycEnterpriseOrgQryDetailAbilityReqBO orgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setOrgIdWeb(reqBo.getPayObjId());
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)orgQryDetailAbilityReqBO));
            UmcDycEnterpriseOrgQryDetailAbilityRspBO umcDycEnterpriseOrgQryDetailAbilityRspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)umcDycEnterpriseOrgQryDetailAbilityRspBO));
            if (umcDycEnterpriseOrgQryDetailAbilityRspBO != null && umcDycEnterpriseOrgQryDetailAbilityRspBO.getEnterpriseOrgBO() != null && !StringUtils.isEmpty((Object)umcDycEnterpriseOrgQryDetailAbilityRspBO.getEnterpriseOrgBO().getIsProfessionalOrg())) {
                accountAtomReqBo.setAccountCategory(Integer.valueOf(Integer.parseInt(umcDycEnterpriseOrgQryDetailAbilityRspBO.getEnterpriseOrgBO().getIsProfessionalOrg())));
            } else {
                accountAtomReqBo.setAccountCategory(Integer.valueOf(1));
            }
            accountAtomReqBo.setOrgId(reqBo.getPayObjId());
            accountAtomReqBo.setOrgName(reqBo.getPayObjName());
            accountAtomReqBo.setAccountName(reqBo.getPayObjName());
        }
        accountAtomReqBo.setStatus(FscConstants.AccountStatus.VALID);
        accountAtomReqBo.setCreateMethod(FscConstants.AccountOpenMethod.AUTO);
        accountAtomReqBo.setCreateTime(nowTime);
        accountAtomReqBo.setCreateOperId(reqBo.getUserId().toString());
        FscMerchantPO modelBy = new FscMerchantPO();
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            FscMerchantPO merchantPO = new FscMerchantPO();
            merchantPO.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
            merchantPO.setEnable(Integer.valueOf(0));
            modelBy = this.fscMerchantMapper.getModelBy(merchantPO);
        }
        if ((modelBy == null || modelBy.getMerchantId() == null) && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBo.getPayType()) && ("4".equals(reqBo.getPayBusiSceneRange()) || "0".equals(reqBo.getPayBusiSceneRange()))) {
            accountAtomReqBo.setCompanyCreditAmount(reqBo.getCompanyCreditAmount() == null ? BigDecimal.ZERO : reqBo.getCompanyCreditAmount());
            accountAtomReqBo.setUnionCreditAmount(reqBo.getUnionCreditAmount() == null ? BigDecimal.ZERO : reqBo.getUnionCreditAmount());
            accountAtomReqBo.setCompanyOverdraft(BigDecimal.ZERO);
            accountAtomReqBo.setUnionOverdraft(BigDecimal.ZERO);
        } else if ((modelBy == null || modelBy.getMerchantId() == null) && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(reqBo.getPayType()) && ("4".equals(reqBo.getPayBusiSceneRange()) || "0".equals(reqBo.getPayBusiSceneRange()))) {
            accountAtomReqBo.setCompanyOverdraft(reqBo.getCompanyOverdraft() == null ? BigDecimal.ZERO : reqBo.getCompanyOverdraft());
            accountAtomReqBo.setUnionOverdraft(reqBo.getUnionOverdraft() == null ? BigDecimal.ZERO : reqBo.getUnionOverdraft());
            accountAtomReqBo.setCompanyCreditAmount(BigDecimal.ZERO);
            accountAtomReqBo.setUnionCreditAmount(BigDecimal.ZERO);
        } else if ((modelBy == null || modelBy.getMerchantId() == null) && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_PERIOD.equals(reqBo.getPayType()) && ("4".equals(reqBo.getPayBusiSceneRange()) || "0".equals(reqBo.getPayBusiSceneRange()))) {
            accountAtomReqBo.setCompanyOverdraft(reqBo.getCompanyOverdraft() == null ? BigDecimal.ZERO : reqBo.getCompanyOverdraft());
            accountAtomReqBo.setUnionOverdraft(reqBo.getUnionOverdraft() == null ? BigDecimal.ZERO : reqBo.getUnionOverdraft());
            accountAtomReqBo.setCompanyCreditAmount(reqBo.getCompanyCreditAmount() == null ? BigDecimal.ZERO : reqBo.getCompanyCreditAmount());
            accountAtomReqBo.setUnionCreditAmount(reqBo.getUnionCreditAmount() == null ? BigDecimal.ZERO : reqBo.getUnionCreditAmount());
        } else {
            accountAtomReqBo.setCompanyOverdraft(null);
            accountAtomReqBo.setUnionOverdraft(null);
            accountAtomReqBo.setCompanyCreditAmount(null);
            accountAtomReqBo.setUnionCreditAmount(null);
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            accountAtomReqBo.setPayBusiSceneRange(reqBo.getPayBusiSceneRange());
        }
        accountAtomReqBo.setMerchantType(reqBo.getMerchantType());
        FscAccountAtomRspBO accountAtomRetBo = this.fscAccountCreateAtomService.createAccount(accountAtomReqBo);
        if (!"0000".equals(accountAtomRetBo.getRespCode())) {
            throw new FscBusinessException("193120", "\u521b\u5efa\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + accountAtomRetBo.getRespDesc());
        }
        retBo.setId(accountAtomRetBo.getAccountNo());
        FscMerchantPO queryReqBo = new FscMerchantPO();
        queryReqBo.setOrgId(reqBo.getOrgId());
        queryReqBo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        queryReqBo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        FscMerchantPO mainMerchant = this.fscMerchantMapper.getModelBy(queryReqBo);
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            if (null == mainMerchant) {
                throw new FscBusinessException("193120", "\u521b\u5efa\u4f8b\u5916\u4fe1\u606f\u5931\u8d25\uff1a\u6b64\u673a\u6784\u672a\u914d\u7f6e\u6709\u6548\u7684\u4e3b\u5546\u6237");
            }
            if ((FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory()) || FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MIX.equals(reqBo.getExceptionCategory())) && FscConstants.MerchantAllowException.NO.equals(mainMerchant.getPayAllowExceptionFlag())) {
                throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u652f\u4ed8\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
            }
            if ((FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory()) || FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MIX.equals(reqBo.getExceptionCategory())) && FscConstants.MerchantAllowException.NO.equals(mainMerchant.getModelAllowExceptionFlag())) {
                throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
            }
            FscMerchantPO qryException = new FscMerchantPO();
            qryException.setOrgId(reqBo.getOrgId());
            qryException.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            qryException.setPayBusiSceneRange(reqBo.getPayBusiSceneRange());
            if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                qryException.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            }
            if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory())) {
                qryException.setPayObjId(reqBo.getPayObjId());
            } else if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory())) {
                qryException.setModelObjId(reqBo.getModelObjId());
            } else {
                qryException.setPayObjId(reqBo.getPayObjId());
                qryException.setModelObjId(reqBo.getModelObjId());
            }
            if (null != reqBo.getModelSceneRange()) {
                if (FscConstants.MerchantAllowException.NO.equals(mainMerchant.getModelAllowExceptionFlag())) {
                    throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
                }
                qryException.setModelObjId(reqBo.getModelObjId());
            }
            if ((merchantPo = this.fscMerchantMapper.getModelBy(qryException)) != null) {
                merchantPo.setPayMerchantId(mainMerchant.getPayMerchantId());
                merchantPo.setMerchantCategory(mainMerchant.getMerchantCategory());
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(reqBo.getPayType()) && !"4".equals(reqBo.getPayBusiSceneRange())) {
                FscAccountPO set = new FscAccountPO();
                set.setOverdraft(reqBo.getOverdraft());
                FscAccountPO where = new FscAccountPO();
                where.setBusiType(FscConstants.FscBusiType.ELECTRONIC.toString());
                where.setOrgId(reqBo.getPayObjId());
                this.fscAccountMapper.updateBy(set, where);
            }
        } else {
            merchantPo = mainMerchant;
        }
        if (merchantPo != null) {
            if (!FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
                log.info("\u5df2\u5b58\u5728\u6709\u6548\u5546\u6237\uff1a\u673a\u6784ID:{}", (Object)reqBo.getOrgId());
                retBo.setRespCode("193120");
                retBo.setRespDesc("\u5df2\u5b58\u5728\u6709\u6548\u5546\u6237");
                return retBo;
            }
            if (FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
                int result2;
                BeanUtils.copyProperties((Object)((Object)reqBo), (Object)merchantPo);
                merchantPo.setUpdateOperId(reqBo.getUserId().toString());
                merchantPo.setUpdateOperName(reqBo.getName());
                merchantPo.setUpdateTime(nowTime);
                merchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
                if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(merchantPo.getExceptionFlag()) && FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(merchantPo.getExceptionCategory())) {
                    if (FscConstants.MerchantModelSceneRange.CATEGORY.equals(merchantPo.getModelSceneRange())) {
                        this.updateCategory(merchantPo.getMerchantId(), reqBo.getCategoryTrees());
                        merchantPo.setModelContractNo("-");
                        merchantPo.setModelContractName("-");
                    } else if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(merchantPo.getModelSceneRange())) {
                        this.deleteCategory(merchantPo.getMerchantId());
                    }
                }
                if (reqBo.getPayCreditAmount() == null) {
                    merchantPo.setPayCreditAmount(BigDecimal.ZERO);
                }
                if ((result2 = this.fscMerchantMapper.updateById(merchantPo)) < 1) {
                    throw new FscBusinessException("193120", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
                }
                retBo.setMerchantId(merchantPo.getMerchantId());
                if (null != merchantPo.getPayCreditAmount()) {
                    this.dealCreditBalance(merchantPo, reqBo);
                }
                if (reqBo.getPayObjId() != null && reqBo.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD)) {
                    this.dealMainCredit(reqBo, mainMerchant, merchantPo.getMerchantId());
                }
                return retBo;
            }
        }
        Long merchantId = Sequence.getInstance().nextId();
        String merchantNo = reqBo.getMerchantNo();
        if (StringUtils.isEmpty((Object)reqBo.getMerchantNo())) {
            String merchantIdStr = merchantId.toString();
            merchantNo = merchantIdStr.substring(merchantIdStr.length() - 4);
        }
        merchantPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)merchantPo);
        merchantPo.setMerchantId(merchantId);
        merchantPo.setMerchantNo(merchantNo);
        merchantPo.setCreateOperId(reqBo.getUserId().toString());
        merchantPo.setCreateOperName(reqBo.getName());
        merchantPo.setCreateTime(nowTime);
        merchantPo.setUpdateTime(nowTime);
        merchantPo.setStatus(FscConstants.MerchantStatus.DRAFT);
        merchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        merchantPo.setEnable(Integer.valueOf(1));
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag()) && !StringUtils.isEmpty((Object)mainMerchant.getMerchantCategory())) {
            merchantPo.setMerchantCategory(mainMerchant.getMerchantCategory());
        }
        merchantPo.setAccountId(Long.valueOf(accountAtomRetBo.getAccountId()));
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag()) && !StringUtils.isEmpty((Object)mainMerchant.getPayMerchantId())) {
            merchantPo.setPayMerchantId(mainMerchant.getPayMerchantId());
        }
        if (reqBo.getPayObjId() != null && reqBo.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD)) {
            this.dealMainCredit(reqBo, mainMerchant, merchantId);
        }
        if ((result = this.fscMerchantMapper.insert(merchantPo)) < 1) {
            throw new FscBusinessException("193120", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag()) && FscConstants.MerchantModelSceneRange.CATEGORY.equals(reqBo.getModelSceneRange())) {
            this.updateCategory(merchantId, reqBo.getCategoryTrees());
        }
        retBo.setMerchantId(merchantId);
        return retBo;
    }

    private void dealMainCredit(FscMerchantCreateBusiReqBO reqBo, FscMerchantPO mainMerchant, Long newMerchantId) {
        List<Object> payBusinessList = new ArrayList<String>();
        String payBusiness = reqBo.getPayBusiSceneRange();
        if (payBusiness.contains(",")) {
            String[] split = payBusiness.split(",");
            payBusinessList = Arrays.asList(split);
        } else if (payBusiness.equals("0")) {
            payBusinessList.add("1");
            payBusinessList.add("2");
            payBusinessList.add("3");
            payBusinessList.add("4");
            payBusinessList.add("5");
        } else {
            payBusinessList.add(reqBo.getPayBusiSceneRange());
        }
        FscCreditBalancePO creditBalancePo = new FscCreditBalancePO();
        creditBalancePo.setMerchantId(mainMerchant.getMerchantId());
        creditBalancePo.setPayBusinessList(payBusinessList);
        creditBalancePo.setPurOrgId(reqBo.getPayObjId());
        List list = this.fscCreditBalanceMapper.getList(creditBalancePo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FscCreditBalancePO creditBalancePO : list) {
                creditBalancePO.setNewMerchantId(newMerchantId);
                if (creditBalancePO.getPayBusiness() == null) {
                    creditBalancePO.setPayBusiness("-1");
                }
                this.fscCreditBalanceMapper.updateMerchantIdByCredit(creditBalancePO);
            }
        }
    }

    private void deleteCategory(Long merchantId) {
        FscSkuCategoryPO categoryPo = new FscSkuCategoryPO();
        categoryPo.setMerchantId(merchantId);
        this.fscSkuCategoryMapper.deleteBy(categoryPo);
    }

    private void updateCategory(Long merchantId, List<String> categoryTrees) {
        FscSkuCategoryPO categoryPo = new FscSkuCategoryPO();
        categoryPo.setMerchantId(merchantId);
        this.fscSkuCategoryMapper.deleteBy(categoryPo);
        AtomicInteger result = new AtomicInteger();
        categoryTrees.forEach(item -> {
            categoryPo.setCategoryTreePath(item);
            result.set(this.fscSkuCategoryMapper.insert(categoryPo));
            if (result.get() < 1) {
                throw new FscBusinessException("193120", "\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u5165\u5e93\u5931\u8d25");
            }
        });
    }

    private void dealCreditBalance(FscMerchantPO merchantPo, FscMerchantCreateBusiReqBO reqBO) {
        FscCreditBalanceInsertAtomRspBO rspBO;
        FscCreditBalanceInsertAtomReqBO creditBalanceInsertAtomReqBO = new FscCreditBalanceInsertAtomReqBO();
        creditBalanceInsertAtomReqBO.setMerchantId(merchantPo.getMerchantId());
        creditBalanceInsertAtomReqBO.setPayCreditAmount(merchantPo.getPayCreditAmount());
        creditBalanceInsertAtomReqBO.setUsedAmount(BigDecimal.ZERO);
        creditBalanceInsertAtomReqBO.setUpdateOper(reqBO.getName());
        if (!StringUtils.isEmpty((Object)reqBO.getPayBusiSceneRange()) && !reqBO.getPayBusiSceneRange().equals("0")) {
            creditBalanceInsertAtomReqBO.setPayBusiness(reqBO.getPayBusiSceneRange());
        }
        if (!"0000".equals((rspBO = this.fscCreditBalanceInsertAtomService.dealCreditBalanceInsert(creditBalanceInsertAtomReqBO)).getRespCode())) {
            throw new FscBusinessException("193120", "\u5904\u7406\u6388\u4fe1\u51fa\u9519");
        }
    }

    private Map<String, Map<String, String>> getDicMap() {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("MERCHANT_BUSI_SCENE");
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : codes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

