/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstHeadBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstInvoiceBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushNewYcSaleSettleChargeAgainstService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscPushNewYcSaleSettleChargeAgainstBusiService;
import com.tydic.fsc.common.busi.bo.FscPushNewYcSaleSettleChargeAgainstBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcSaleSettleChargeAgainstBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundChangePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionItemListBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPushNewYcSaleSettleChargeAgainstBusiServiceImpl
implements FscPushNewYcSaleSettleChargeAgainstBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcSaleSettleChargeAgainstBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Value(value="${settle.stage.value:2}")
    private String settleStage;
    @Autowired
    private FscPushNewYcSaleSettleChargeAgainstService fscPushNewYcSaleSettleChargeAgainstService;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    private final String SPECIFIC_STR = "1070101";
    private final String SPECIFIC_STR_CONVERT = "01";
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Value(value="${fsc.invoice.priceMode}")
    private String priceMode;
    private final String STR_01 = "01";
    private final String STR_02 = "02";
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Value(value="${INDIVIDUALLY_CUSTOMER_ID:9615}")
    private String individuallyCustomerId;
    @Value(value="${INDIVIDUALLY_CUSTOMER_NAME:\u4e2a\u4eba}")
    private String individuallyCustomerName;
    @Autowired
    private FscRefundChangeMapper fscRefundChangeMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;

    @Override
    @FscDuplicateCommitLimit
    public FscPushNewYcSaleSettleChargeAgainstBusiRspBO pushNewYcSaleSettleChargeAgainst(FscPushNewYcSaleSettleChargeAgainstBusiReqBO reqBO) {
        FscPushNewYcSaleSettleChargeAgainstBusiRspBO rspBO = new FscPushNewYcSaleSettleChargeAgainstBusiRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u63a8\u9001\u65b0\u4e1a\u8d22\u9500\u552e\u7ed3\u7b97\u51b2\u9500\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (fscOrderRefundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u9000\u7968\u5355\u4fe1\u606f\uff01" + reqBO.getRefundId());
        }
        if (FscConstants.FscClaimChangePushStatus.SUCCESS.equals(fscOrderRefundPO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u9000\u7968\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u63a8\u9001\uff01");
        }
        FscPushLogPO fscPushLogPo = new FscPushLogPO();
        try {
            String failMsg = this.check(fscOrderRefundPO);
            if (!org.springframework.util.StringUtils.isEmpty((Object)failMsg)) {
                throw new ZTBusinessException(failMsg);
            }
            FscPushNewYcSaleSettleChargeAgainstHeadBO headBO = new FscPushNewYcSaleSettleChargeAgainstHeadBO();
            ArrayList<FscPushNewYcSaleSettleChargeAgainstItemBO> itemBOS = new ArrayList<FscPushNewYcSaleSettleChargeAgainstItemBO>();
            FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
            dicDictionaryExernalPO.setExernalSysCode("YC");
            List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
            headBO.setEG_BILL_NUM(fscOrderRefundPO.getRefundNo());
            headBO.setPERSON_ID(fscOrderRefundPO.getYcUserId().toString());
            headBO.setPERSON_NAME(fscOrderRefundPO.getYcPersonName());
            headBO.setDEPT_ID(fscOrderRefundPO.getYcDeptId().toString());
            headBO.setORG_ID(this.operationOrgId);
            headBO.setORG_NAME(this.operationOrgName);
            headBO.setDEPT_NAME(fscOrderRefundPO.getYcDeptName());
            FscAttachmentPO attachmentPO = new FscAttachmentPO();
            attachmentPO.setObjId(fscOrderRefundPO.getRefundId());
            attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
            List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                headBO.setDOC_COUNT(attachmentPOS.size() + "");
            } else {
                headBO.setDOC_COUNT("0");
            }
            headBO.setBALANCE_ID(fscOrderRefundPO.getFscOrderId().toString());
            headBO.setINV_AMOUNT(fscOrderRefundPO.getTotalCharge().setScale(2, 4));
            headBO.setAMOUNT(fscOrderRefundPO.getRefundAmount().negate().setScale(2, 4));
            FscOrderItemPO searchRefundItemPO = new FscOrderItemPO();
            searchRefundItemPO.setRefundId(fscOrderRefundPO.getRefundId());
            List refundItems = this.fscOrderItemMapper.getListNoPage(searchRefundItemPO);
            if (CollectionUtils.isEmpty((Collection)refundItems)) {
                throw new ZTBusinessException("\u9000\u7968\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
            }
            List invoiceItemIds = refundItems.stream().filter(e -> e.getInvoiceItemId() != null).map(FscOrderItemPO::getInvoiceItemId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(invoiceItemIds)) {
                throw new ZTBusinessException("\u9000\u7968\u660e\u7ec6\u6570\u636e\u4e2d\u5173\u8054id\u4e0d\u5b58\u5728");
            }
            invoiceItemIds = invoiceItemIds.stream().distinct().collect(Collectors.toList());
            FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
            searchInvoiceItemPO.setIds(invoiceItemIds);
            searchInvoiceItemPO.setOrderBy("ID");
            List fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
            if (CollectionUtils.isEmpty((Collection)fscInvoiceItemPOS) || fscInvoiceItemPOS.size() != invoiceItemIds.size()) {
                throw new ZTBusinessException("\u9000\u7968\u660e\u7ec6\u6570\u636e\u4e2d\u6709\u5173\u8054\u53d1\u7968\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Map<Long, FscInvoiceItemPO> invoiceItemIdMap = fscInvoiceItemPOS.stream().collect(Collectors.toMap(FscInvoiceItemPO::getId, o -> o));
            Map<Long, List<FscInvoiceItemPO>> invoiceIdItemMap = fscInvoiceItemPOS.stream().collect(Collectors.groupingBy(FscInvoiceItemPO::getInvoiceId));
            FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
            searchOrderItemPO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
            List fscOrderItemPOS = this.fscOrderItemMapper.getList(searchOrderItemPO);
            Map<Long, List<FscOrderItemPO>> orderItemIdMap = fscOrderItemPOS.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
            BigDecimal TAX_AMOUNT = BigDecimal.ZERO;
            BigDecimal NOTAX_AMOUNT = BigDecimal.ZERO;
            BigDecimal COST_AMOUNT = BigDecimal.ZERO;
            BigDecimal COST_AMOUNT_NOTAX = BigDecimal.ZERO;
            for (FscOrderItemPO refundItem : refundItems) {
                FscInvoiceItemPO invoiceItemPO = invoiceItemIdMap.get(refundItem.getInvoiceItemId());
                FscOrderItemPO fscOrderItemPO = orderItemIdMap.get(invoiceItemPO.getOrderItemId()).get(0);
                BigDecimal costAmount = refundItem.getNum().multiply(fscOrderItemPO.getPurchasePrice()).setScale(2, 4);
                BigDecimal costAmountNotax = TaxUtils.calNoTaxAmt((BigDecimal)costAmount, (BigDecimal)fscOrderItemPO.getTaxRate());
                COST_AMOUNT = COST_AMOUNT.add(costAmount);
                COST_AMOUNT_NOTAX = COST_AMOUNT_NOTAX.add(costAmountNotax);
                BigDecimal amount = refundItem.getNum().multiply(fscOrderItemPO.getPrice()).setScale(2, 4);
                BigDecimal notaxAmount = TaxUtils.calNoTaxAmt((BigDecimal)amount, (BigDecimal)fscOrderItemPO.getTaxRate());
                BigDecimal taxAmount = TaxUtils.calTaxAmt((BigDecimal)amount, (BigDecimal)fscOrderItemPO.getTaxRate());
                TAX_AMOUNT = TAX_AMOUNT.add(taxAmount);
                NOTAX_AMOUNT = NOTAX_AMOUNT.add(notaxAmount);
            }
            headBO.setTAX_AMOUNT(TAX_AMOUNT.negate());
            headBO.setNOTAX_AMOUNT(NOTAX_AMOUNT.negate());
            headBO.setCOST_AMOUNT(COST_AMOUNT.negate());
            headBO.setCOST_AMOUNT_NOTAX(COST_AMOUNT_NOTAX.negate());
            headBO.setEG_COST_AMT(COST_AMOUNT.negate());
            headBO.setEG_COST_AMT_TAX(COST_AMOUNT_NOTAX.negate());
            FscInvoiceRefundRelationPO searchRelationPO = new FscInvoiceRefundRelationPO();
            searchRelationPO.setRefundId(fscOrderRefundPO.getRefundId());
            List refundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRelationPO);
            List relationInvoiceIds = refundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
            FscOrderPO searchOrderPO = new FscOrderPO();
            searchOrderPO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
            FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(searchOrderPO);
            if (fscOrderPO == null) {
                throw new ZTBusinessException("\u9000\u7968\u5173\u8054\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
            }
            headBO.setEG_SETTLE_NUMBER(fscOrderRefundPO.getRefundNo());
            headBO.setBALANCE_NUM(fscOrderPO.getOrderNo());
            Integer orderSource = fscOrderPO.getOrderType();
            List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource + "")).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fscTypeList)) {
                throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
            }
            headBO.setBALANCE_TYPE((String)fscTypeList.get(0));
            List fscTypeDisList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource + "")).map(FscDicDictionaryExernalPO::getExernalTitle).collect(Collectors.toList());
            headBO.setBALANCE_TYPE_DIS((String)fscTypeDisList.get(0));
            FscInvoicePO searchInvoicePO = new FscInvoicePO();
            searchInvoicePO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
            searchInvoicePO.setInvoiceIds(relationInvoiceIds);
            List invoicePOS = this.fscInvoiceMapper.getList(searchInvoicePO);
            Map<Long, FscInvoicePO> invoiceIdMap = invoicePOS.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, o -> o));
            FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
            fscOrderInvoicePo.setFscOrderId(fscOrderRefundPO.getFscOrderId());
            FscOrderInvoicePO fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
            String buyName = fscOrderInvoicePO.getBuyName();
            if (!org.springframework.util.StringUtils.isEmpty((Object)buyName)) {
                if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL)) {
                    headBO.setVENDOR_ID(this.individuallyCustomerId);
                    headBO.setVENDOR_NAME(this.individuallyCustomerName);
                } else {
                    FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
                    custInfoReqBO.setCustomerName(buyName);
                    FscGetErpCustInfoRspBO custInfoRspBO = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
                    if (!custInfoRspBO.getRespCode().equals("0000")) {
                        throw new FscBusinessException(custInfoRspBO.getRespCode(), custInfoRspBO.getRespDesc());
                    }
                    headBO.setVENDOR_ID(custInfoRspBO.getCustAccountId());
                    headBO.setVENDOR_NAME(buyName);
                }
            }
            String invoiceKey = FscConstants.FscInvoiceCategory.ELEC.equals(fscOrderInvoicePO.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_SALE_ELECTORNIC" : (FscConstants.FscInvoiceCategory.FULL.equals(fscOrderInvoicePO.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_ELECTRONIC_FULL" : "FSC_INVOICE_TYPE_SALE");
            String invoiceType = fscOrderInvoicePO.getInvoiceType();
            List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals(invoiceKey)).filter(p -> p.getCode().equals(invoiceType)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(invoiceTypeList)) {
                throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
            }
            headBO.setEG_TESCO_EMAIL(fscOrderInvoicePO.getReceiveEmail());
            headBO.setEG_TESCO_SETTLE_ID(fscOrderRefundPO.getRefundId().toString());
            headBO.setBILL_DATE(DateUtil.dateToStr((Date)fscOrderRefundPO.getCreateTime()));
            headBO.setDESCRIPTIONS(fscOrderRefundPO.getReason());
            headBO.setEG_TESCO_ID(fscOrderRefundPO.getRefundId().toString());
            headBO.setTASK_FLAG("Y");
            headBO.setPRICE_TYPE(this.priceMode);
            headBO.setINV_TYPE((String)invoiceTypeList.get(0));
            headBO.setTAXPAYER_NUM(fscOrderInvoicePO.getTaxNo());
            headBO.setINV_DESCRIPTIONS(fscOrderPO.getInvoiceRemark());
            headBO.setCOMPANY_ADDRESS(fscOrderInvoicePO.getAddress().trim());
            headBO.setBANK_NAME(fscOrderInvoicePO.getBank().trim());
            headBO.setCOMPANY_PHONE(fscOrderInvoicePO.getPhone().trim());
            headBO.setBANK_ACC(fscOrderInvoicePO.getAccount().trim());
            ArrayList<FscPushNewYcSaleSettleChargeAgainstInvoiceBO> invoiceBOS = new ArrayList<FscPushNewYcSaleSettleChargeAgainstInvoiceBO>();
            for (FscInvoicePO invoicePO : invoicePOS) {
                FscPushNewYcSaleSettleChargeAgainstInvoiceBO invoiceBO = new FscPushNewYcSaleSettleChargeAgainstInvoiceBO();
                if (FscConstants.FscInvoiceCategory.FULL.equals(fscOrderInvoicePO.getInvoiceCategory())) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)invoicePO.getInvoiceCode())) {
                        invoiceBO.setORIGINAL_INV_NO(invoicePO.getInvoiceCode() + invoicePO.getInvoiceNo());
                    } else {
                        invoiceBO.setORIGINAL_INV_NO(invoicePO.getInvoiceNo());
                    }
                } else {
                    invoiceBO.setORIGINAL_INV_NO(invoicePO.getInvoiceNo());
                    invoiceBO.setORIGINAL_INV_CODE(invoicePO.getInvoiceCode());
                }
                invoiceBO.setORIGINAL_INV_TYPE((String)invoiceTypeList.get(0));
                invoiceBO.setORIGINAL_INV_AMOUNT(invoicePO.getAmt().setScale(2, 4));
                invoiceBO.setORIGINAL_INV_TAX(invoicePO.getTaxAmt().setScale(2, 4));
                if (FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(fscOrderRefundPO.getRefundReasonType().toString())) {
                    invoiceBO.setRED_REASON("02");
                } else {
                    invoiceBO.setRED_REASON("01");
                }
                String taxCode = invoiceIdItemMap.get(invoicePO.getInvoiceId()).get(0).getTaxCode();
                if (taxCode.startsWith("1070101")) {
                    invoiceBO.setORI_SPECIFIC_FACTOR("01");
                }
                invoiceBO.setEG_TESCO_ID(invoicePO.getInvoiceId().toString());
                invoiceBOS.add(invoiceBO);
            }
            HashMap<String, UocInspectionItemListBO> itemMap = new HashMap<String, UocInspectionItemListBO>();
            String purPlaceOrderName = "";
            if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
                List inspectionIdList = fscOrderItemPOS.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
                UocInspectionDetailsListPageQueryReqBO inspectionDetailsListQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
                inspectionDetailsListQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
                inspectionDetailsListQueryReqBO.setTabId(this.TAB_ID);
                inspectionDetailsListQueryReqBO.setIsChange("0");
                inspectionDetailsListQueryReqBO.setIsFscQuery("0");
                inspectionDetailsListQueryReqBO.setInspectionVoucherIdList(inspectionIdList);
                inspectionDetailsListQueryReqBO.setPageSize(100000);
                UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(inspectionDetailsListQueryReqBO);
                if (!uocInspectionDetailsListPageQueryRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(uocInspectionDetailsListPageQueryRspBO.getRespCode(), "\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + uocInspectionDetailsListPageQueryRspBO.getRespDesc());
                }
                for (UocInspectionDetailsListBO row : uocInspectionDetailsListPageQueryRspBO.getRows()) {
                    for (UocInspectionItemListBO uocInspectionItemListBO : row.getInspectionItemInfo()) {
                        itemMap.put(uocInspectionItemListBO.getInspectionItemId(), uocInspectionItemListBO);
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)row.getPurPlaceOrderName())) continue;
                    purPlaceOrderName = row.getPurPlaceOrderName();
                }
            } else {
                List orderIds = fscOrderItemPOS.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toList());
                UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
                saleDetailsReqBO.setOrderIdList(orderIds);
                saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
                saleDetailsReqBO.setPageSize(10000);
                saleDetailsReqBO.setIsAfterSales(Boolean.valueOf(false));
                log.debug("\u63a8\u9001\u4e1a\u8d22\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsReqBO));
                UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
                log.debug("\u63a8\u9001\u4e1a\u8d22\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsRspBO));
                if (!saleDetailsRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u7269\u6599\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + saleDetailsRspBO.getRespDesc());
                }
                for (UocInspectionDetailsListBO row : saleDetailsRspBO.getRows()) {
                    for (UocPebChildOrderAbilityBO childOrderAbilityBO : row.getChildOrderList()) {
                        for (UocPebOrderItemAbilityBO uocPebOrderItemAbilityBO : childOrderAbilityBO.getOrderItemList()) {
                            UocInspectionItemListBO uocInspectionItemListBO = (UocInspectionItemListBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uocPebOrderItemAbilityBO), UocInspectionItemListBO.class);
                            uocInspectionItemListBO.setOrdItemId(uocPebOrderItemAbilityBO.getOrderItemId());
                            itemMap.put(uocInspectionItemListBO.getOrdItemId(), uocInspectionItemListBO);
                        }
                        if (StringUtils.isEmpty((CharSequence)childOrderAbilityBO.getPurPlaceOrderName())) continue;
                        purPlaceOrderName = childOrderAbilityBO.getPurPlaceOrderName();
                    }
                }
            }
            for (FscOrderItemPO refundItem : refundItems) {
                FscInvoiceItemPO invoiceItemPO = invoiceItemIdMap.get(refundItem.getInvoiceItemId());
                FscOrderItemPO orderItemPO = orderItemIdMap.get(invoiceItemPO.getOrderItemId()).get(0);
                FscPushNewYcSaleSettleChargeAgainstItemBO againstItemBO = new FscPushNewYcSaleSettleChargeAgainstItemBO();
                againstItemBO.setLINE_TYPE((String)fscTypeList.get(0));
                againstItemBO.setEG_TESCO_ID(refundItem.getId().toString());
                againstItemBO.setEG_BALANCE_LINE_ID(orderItemPO.getId().toString());
                againstItemBO.setTRADE_NAME(orderItemPO.getSkuName());
                if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getSpec())) {
                    againstItemBO.setSPE_MODEL(orderItemPO.getSpec());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getSpec()) && !org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel())) {
                    againstItemBO.setSPE_MODEL(orderItemPO.getSpec() + "|" + orderItemPO.getModel());
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel())) {
                    againstItemBO.setSPE_MODEL(orderItemPO.getModel());
                }
                againstItemBO.setQUANTITY(refundItem.getNum().negate());
                againstItemBO.setAMOUNT(refundItem.getRefundAmt().negate().setScale(2, 4));
                againstItemBO.setTAX_RATE(orderItemPO.getTaxRate().setScale(2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                againstItemBO.setNOTAX_AMOUNT(TaxUtils.calNoTaxAmt((BigDecimal)refundItem.getRefundAmt(), (BigDecimal)orderItemPO.getTaxRate()).negate());
                againstItemBO.setTAX_AMOUNT(TaxUtils.calTaxAmt((BigDecimal)refundItem.getRefundAmt(), (BigDecimal)orderItemPO.getTaxRate()).negate());
                againstItemBO.setPRICE(orderItemPO.getPrice());
                againstItemBO.setPRICE_NOTAX(orderItemPO.getPrice().divide(BigDecimal.ONE.add(orderItemPO.getTaxRate()), 8, 4));
                againstItemBO.setCOST_PRICE(orderItemPO.getPurchasePrice().divide(BigDecimal.ONE.add(orderItemPO.getTaxRate()), 8, 4));
                againstItemBO.setORG_ID(this.operationOrgId);
                againstItemBO.setORI_LINE_CODE(invoiceItemPO.getItemNo());
                UocInspectionItemListBO uocInspectionItemListBO = (UocInspectionItemListBO)itemMap.get(orderItemPO.getOrderItemId().toString());
                if (uocInspectionItemListBO == null) {
                    throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff01");
                }
                if (Objects.nonNull(fscOrderPO.getOrderSource()) && ("2".equals(String.valueOf(fscOrderPO.getOrderSource())) || "1".equals(String.valueOf(fscOrderPO.getOrderSource())))) {
                    againstItemBO.setEG_ITEM_DESCRIPTION(!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getProductDescription()) ? orderItemPO.getProductDescription() : uocInspectionItemListBO.getSkuName());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getSpecificationsModel())) {
                        againstItemBO.setPART_NUMBER(orderItemPO.getSpecificationsModel());
                    } else {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getSpec())) {
                            againstItemBO.setPART_NUMBER(orderItemPO.getSpec());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel()) && !org.springframework.util.StringUtils.isEmpty((Object)againstItemBO.getEG_ITEM_DESCRIPTION())) {
                            againstItemBO.setPART_NUMBER(orderItemPO.getSpec() + "|" + orderItemPO.getModel());
                        } else if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel())) {
                            againstItemBO.setPART_NUMBER(orderItemPO.getModel());
                        }
                    }
                } else {
                    againstItemBO.setEG_ITEM_DESCRIPTION(!org.springframework.util.StringUtils.isEmpty((Object)uocInspectionItemListBO.getSkuMaterialName()) ? uocInspectionItemListBO.getSkuMaterialName() : uocInspectionItemListBO.getSkuName());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getSpec())) {
                        againstItemBO.setPART_NUMBER(orderItemPO.getSpec());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel()) && !org.springframework.util.StringUtils.isEmpty((Object)againstItemBO.getEG_ITEM_DESCRIPTION())) {
                        againstItemBO.setPART_NUMBER(orderItemPO.getSpec() + "|" + orderItemPO.getModel());
                    } else if (!org.springframework.util.StringUtils.isEmpty((Object)orderItemPO.getModel())) {
                        againstItemBO.setPART_NUMBER(orderItemPO.getModel());
                    }
                }
                againstItemBO.setUNIT_DIS(invoiceItemPO.getUnit());
                againstItemBO.setMATERIAL_CODE(!org.springframework.util.StringUtils.isEmpty((Object)uocInspectionItemListBO.getSkuMaterialId()) ? uocInspectionItemListBO.getSkuMaterialId() : String.valueOf(orderItemPO.getSkuId()));
                againstItemBO.setTAX_TYPE(invoiceItemPO.getTaxCode());
                againstItemBO.setEG_INV_LINE_ID(invoiceItemPO.getInvoiceId().toString());
                itemBOS.add(againstItemBO);
            }
            if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL)) {
                headBO.setINV_DESCRIPTIONS(purPlaceOrderName);
            }
            List<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO> claimChangeBOList = this.getClaimChangeBO(reqBO.getRefundId());
            FscPushNewYcSaleSettleChargeAgainstReqBO fscPushNewYcSaleSettleChargeAgainstReqBO = new FscPushNewYcSaleSettleChargeAgainstReqBO();
            fscPushNewYcSaleSettleChargeAgainstReqBO.setHeadBO(headBO);
            fscPushNewYcSaleSettleChargeAgainstReqBO.setInvoiceBOS(invoiceBOS);
            fscPushNewYcSaleSettleChargeAgainstReqBO.setItemBOS(itemBOS);
            fscPushNewYcSaleSettleChargeAgainstReqBO.setClaimChangeBOList(claimChangeBOList);
            FscPushNewYcSaleSettleChargeAgainstRspBO pushRspBo = this.dealParamToYc(fscOrderRefundPO.getExt1(), fscPushNewYcSaleSettleChargeAgainstReqBO, fscPushLogPo);
            if (!pushRspBo.getRespCode().equals("0000")) {
                this.saveLog(fscOrderRefundPO, FscConstants.FscPushStatus.FAIL, fscPushLogPo);
                rspBO.setRespCode(pushRspBo.getRespCode());
                rspBO.setRespDesc(pushRspBo.getRespDesc());
                this.savePushStatus(fscOrderRefundPO.getRefundId(), FscConstants.pushState.NO_PUSH, pushRspBo.getRespDesc());
                return rspBO;
            }
            this.savePushStatus(fscOrderRefundPO.getRefundId(), FscConstants.pushState.SUCCESS, null);
            this.pushFile(reqBO, fscOrderRefundPO);
        }
        catch (Exception e2) {
            log.error("\u63a8\u9001\u65b0\u4e1a\u8d22\u9500\u552e\u7ed3\u7b97\u51b2\u9500\u5931\u8d25\uff01" + FscCommonUtils.dealStackTrace((Exception)e2));
            this.savePushStatus(fscOrderRefundPO.getRefundId(), FscConstants.pushState.NO_PUSH, e2.getMessage());
            fscPushLogPo.setStatus(FscConstants.logPushState.FAILED);
            fscPushLogPo.setRespData(e2.getMessage());
            this.saveLog(fscOrderRefundPO, FscConstants.FscPushStatus.FAIL, fscPushLogPo);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(e2.getMessage());
            return rspBO;
        }
        this.saveLog(fscOrderRefundPO, FscConstants.FscPushStatus.SUCCESS, fscPushLogPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(FscOrderRefundPO refundPO, Integer status, FscPushLogPO fscPushLogPo) {
        try {
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(refundPO.getRefundId());
            fscPushLogPo.setObjectNo(refundPO.getRefundNo());
            fscPushLogPo.setType(FscConstants.FscPushType.SALE_SETTLE_CHARGE_AGAINST);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            int count = this.fscPushLogMapper.insert(fscPushLogPo);
            if (count == 0) {
                throw new FscBusinessException("190000", "\u6dfb\u52a0\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u63a8\u9001\u65b0\u4e1a\u8d22\u9500\u552e\u7ed3\u7b97\u51b2\u9500\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(Long refundId, Integer status, String failReason) {
        if (refundId != null) {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundId(refundId);
            fscOrderRefundPO.setExt2(failReason);
            fscOrderRefundPO.setPushStatus(Integer.valueOf(status == 0 ? 0 : 1));
            this.fscOrderRefundMapper.updateById(fscOrderRefundPO);
        }
    }

    private String check(FscOrderRefundPO po) {
        String fail = "";
        if (po.getYcUserId() == null) {
            fail = fail + "\u7ecf\u529e\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (po.getYcPersonId() == null) {
            fail = fail + "\u7ecf\u529e\u4eba\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)po.getYcPersonName())) {
            fail = fail + "\u7ecf\u529e\u4eba\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (po.getYcDeptId() == null) {
            fail = fail + "\u7ecf\u529e\u4eba\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)po.getYcDeptName())) {
            fail = fail + "\u7ecf\u529e\u4eba\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)po.getExt1())) {
            fail = fail + "\u7ecf\u529e\u4ebaerp\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        if (po.getFscOrderId() == null) {
            fail = fail + "\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a;";
        }
        return fail;
    }

    private void pushFile(FscPushNewYcSaleSettleChargeAgainstBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        try {
            FscAttachmentPO searchAttachmentPO = new FscAttachmentPO();
            searchAttachmentPO.setObjId(reqBO.getRefundId());
            searchAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            searchAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
            List attachmentPOS = this.fscAttachmentMapper.getList(searchAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                List fileList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOS), AttachmentBO.class);
                FscPushYcAttachmentAbilityReqBO fscPushYcAttachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                fscPushYcAttachmentAbilityReqBO.setObjId(reqBO.getRefundId());
                fscPushYcAttachmentAbilityReqBO.setObjNo(refundPO.getRefundNo());
                fscPushYcAttachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.SALE_SETTLE_CHARGE_AGAINST);
                fscPushYcAttachmentAbilityReqBO.setAgentName(refundPO.getCreateUserName());
                fscPushYcAttachmentAbilityReqBO.setAgentAccount(refundPO.getAgentAccount());
                if (refundPO.getCreateUserId() != null) {
                    fscPushYcAttachmentAbilityReqBO.setUserId(refundPO.getCreateUserId().toString());
                } else {
                    fscPushYcAttachmentAbilityReqBO.setUserId(refundPO.getAgentAccount());
                }
                fscPushYcAttachmentAbilityReqBO.setFileList(fileList);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(fscPushYcAttachmentAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u9644\u4ef6\u62a5\u9519" + e.getMessage());
        }
    }

    private FscPushNewYcSaleSettleChargeAgainstRspBO dealParamToYc(String agentAccount, FscPushNewYcSaleSettleChargeAgainstReqBO pushReqBo, FscPushLogPO fscPushLogPo) {
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("BALANCE", (Object)pushReqBo.getHeadBO());
        jsonObject.put("BALANCE_INVOICE", (Object)pushReqBo.getInvoiceBOS());
        jsonObject.put("BALANCE_LINE", (Object)pushReqBo.getItemBOS());
        jsonObject.put("STAGE", (Object)this.settleStage);
        jsonObject.put("CLAIM_CHG", (Object)pushReqBo.getClaimChangeBOList());
        jsonArray.add((Object)jsonObject);
        fscPushLogPo.setObjData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPo.setPushParseData(encryPtionRspBO.getData());
        FscPushNewYcSaleSettleChargeAgainstReqBO pushNewYcSaleSettleChargeAgainstReqBO = new FscPushNewYcSaleSettleChargeAgainstReqBO();
        pushNewYcSaleSettleChargeAgainstReqBO.setData(encryPtionRspBO.getData());
        pushNewYcSaleSettleChargeAgainstReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscPushNewYcSaleSettleChargeAgainstRspBO fscPushNewYcSaleSettleChargeAgainstRspBO = this.fscPushNewYcSaleSettleChargeAgainstService.pushNewYcSaleSettleChargeAgainst(pushNewYcSaleSettleChargeAgainstReqBO);
        log.info("\u8c03\u7528fscPushNewYcSaleSettleChargeAgainstService\u670d\u52a1\u51fa\u53c2" + JSONObject.toJSONString((Object)fscPushNewYcSaleSettleChargeAgainstRspBO));
        if (!org.springframework.util.StringUtils.isEmpty((Object)fscPushNewYcSaleSettleChargeAgainstRspBO.getData()) || !org.springframework.util.StringUtils.isEmpty((Object)fscPushNewYcSaleSettleChargeAgainstRspBO.getMsg())) {
            FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
            decryptionAbilityReqBO.setData("0000".equals(fscPushNewYcSaleSettleChargeAgainstRspBO.getRespCode()) ? fscPushNewYcSaleSettleChargeAgainstRspBO.getData() : fscPushNewYcSaleSettleChargeAgainstRspBO.getMsg());
            FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
            log.info("\u8c03\u7528fscUnifySettleRelatedInterfacesAtomService\u670d\u52a1\u51fa\u53c2" + JSONObject.toJSONString((Object)decryptionAbilityRspBO));
            fscPushLogPo.setRespData(decryptionAbilityRspBO.getData());
            fscPushLogPo.setRespParseData(fscPushNewYcSaleSettleChargeAgainstRspBO.getRspData());
            fscPushNewYcSaleSettleChargeAgainstRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        }
        return fscPushNewYcSaleSettleChargeAgainstRspBO;
    }

    private List<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO> getClaimChangeBO(Long refundId) {
        ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO> claimChangeBOS = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO>();
        List refundChangePOS = this.fscRefundChangeMapper.queryByRefundId(refundId);
        if (!CollectionUtils.isEmpty((Collection)refundChangePOS)) {
            refundChangePOS = refundChangePOS.stream().filter(e -> e.getDelFlag() == null || e.getDelFlag() != 1).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)refundChangePOS)) {
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            List changeItemPOS = this.fscRefundChangeItemMapper.queryByRefundId(refundId);
            if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
                changeItemPOS = changeItemPOS.stream().filter(e -> e.getDelFlag() == null || e.getDelFlag() != 1).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
                Map<Long, List<FscRefundChangePO>> claimIdHeadMap = refundChangePOS.stream().collect(Collectors.groupingBy(FscRefundChangePO::getClaimId));
                Map<Long, List<FscRefundChangeItemPO>> claimIdItemMap = changeItemPOS.stream().collect(Collectors.groupingBy(FscRefundChangeItemPO::getPreClaimId));
                for (Long claimId : claimIdHeadMap.keySet()) {
                    FscPushNewYcSaleSettleChargeAgainstClaimChangeBO claimChangeBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeBO();
                    FscRefundChangePO refundChangePO = claimIdHeadMap.get(claimId).get(0);
                    FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO claimChangeHeadBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO();
                    claimChangeHeadBO.setORG_ID(refundChangePO.getYcOrgId().toString());
                    claimChangeHeadBO.setORG_NAME(refundChangePO.getYcOrgName());
                    claimChangeHeadBO.setPERSON_ID(refundChangePO.getYcUserId().toString());
                    claimChangeHeadBO.setPERSON_NAME(refundChangePO.getYcUserName());
                    claimChangeHeadBO.setDEPT_ID(refundChangePO.getYcDeptId().toString());
                    claimChangeHeadBO.setDEPT_NAME(refundChangePO.getYcDeptName());
                    claimChangeHeadBO.setEG_REC_ID(claimId.toString());
                    claimChangeHeadBO.setEG_REC_BILL_NUM(refundChangePO.getClaimNo());
                    claimChangeHeadBO.setEG_BILL_NUM(refundChangePO.getChangeNo());
                    claimChangeHeadBO.setBILL_DATE(DateUtil.dateToStr((Date)refundChangePO.getCreateTime()));
                    claimChangeHeadBO.setCHANGE_AMOUNT(refundChangePO.getChangeAmt());
                    claimChangeHeadBO.setEG_TESCO_ID(refundChangePO.getChangeId().toString());
                    claimChangeBO.setClaimChangeHeadBO(claimChangeHeadBO);
                    ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO> newItemBOList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO>();
                    ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO> changeItemBOList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO>();
                    List<FscRefundChangeItemPO> refundChangeItemPOS = claimIdItemMap.get(claimId);
                    for (FscRefundChangeItemPO changeItemPO : refundChangeItemPOS) {
                        FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO changeItemBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO();
                        changeItemBO.setCLAIM_TYPE(dicMap.get(changeItemPO.getClaimType().toString()));
                        if (changeItemPO.getPreFscOrderId() != null) {
                            changeItemBO.setBALANCE_ID(changeItemPO.getPreFscOrderId().toString());
                        }
                        changeItemBO.setBALANCE_NUM(changeItemPO.getPreFscOrderNo());
                        changeItemBO.setAMOUNT(changeItemPO.getChangeAmt());
                        changeItemBO.setEG_FROM_TESCO_ID(changeItemPO.getPreClaimDetailId().toString());
                        changeItemBO.setPERSON_ID(changeItemPO.getPreHandleUserId().toString());
                        changeItemBO.setPERSON_NAME(changeItemPO.getPreHandleUserName());
                        changeItemBO.setDEPT_ID(changeItemPO.getPreHandleDeptId().toString());
                        changeItemBO.setDEPT_NAME(changeItemPO.getPreHandleDeptName());
                        changeItemBOList.add(changeItemBO);
                        FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO newItemBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO();
                        newItemBO.setPERSON_ID(changeItemPO.getHandleUserId().toString());
                        newItemBO.setPERSON_NAME(changeItemPO.getHandleUserName());
                        newItemBO.setDEPT_ID(changeItemPO.getHandleDeptId().toString());
                        newItemBO.setDEPT_NAME(changeItemPO.getHandleDeptName());
                        newItemBO.setCLAIM_TYPE(dicMap.get(changeItemPO.getClaimType().toString()));
                        newItemBO.setEG_TESCO_ID(changeItemPO.getChangeItemId().toString());
                        newItemBO.setCLAIM_AMOUNT(changeItemPO.getClaimAmt());
                        newItemBOList.add(newItemBO);
                    }
                    claimChangeBO.setNewItemBOList(newItemBOList);
                    claimChangeBO.setChangeItemBOList(changeItemBOList);
                    claimChangeBOS.add(claimChangeBO);
                }
            }
        }
        return claimChangeBOS;
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }
}

