/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyChargeBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyChargeBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyChargeBillService;
import com.tydic.fsc.common.busi.api.FscPushUnifyChargeBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyChargeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPushUnifyChargeBusiServiceImpl
implements FscPushUnifyChargeBusiService {
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscPushUnifyChargeBillService fscPushUnifyChargeBillService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;

    @Override
    public FscPushUnifyChargeBusiRspBO dealPushCharge(FscPushUnifyChargeBusiReqBO reqBO) {
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u5355id[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargePO chargePO = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (chargePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5145\u503c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscPushUnifyChargeBusiRspBO rspBO = new FscPushUnifyChargeBusiRspBO();
        if (chargePO.getUnifyPushStatus() != null && chargePO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\u3002\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        FscPushUnifyChargeBillReqBO fscPushUnifyChargeBillReqBO = new FscPushUnifyChargeBillReqBO();
        fscPushUnifyChargeBillReqBO.setData(reqBO.getParseData());
        fscPushUnifyChargeBillReqBO.setToken(reqBO.getToken());
        FscPushUnifyChargeBillRspBO fscPushUnifyChargeBillRspBO = this.fscPushUnifyChargeBillService.pushUnifyCharge(fscPushUnifyChargeBillReqBO);
        pushLogPo.setObjectNo(chargePO.getAdvanceDepositNo());
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(reqBO.getChargeId());
        pushLogPo.setType(FscConstants.FscPurchasePushType.CHARGE);
        pushLogPo.setRespData(JSONObject.toJSONString((Object)fscPushUnifyChargeBillRspBO));
        pushLogPo.setPushData(reqBO.getReqData());
        pushLogPo.setCreateTime(new Date());
        if (!fscPushUnifyChargeBillRspBO.getRespCode().equals("0000")) {
            pushLogPo.setPushParseData(reqBO.getParseData());
            pushLogPo.setPushStatus(FscConstants.FscPushStatus.FAIL);
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            FscAccountChargePO extPO = new FscAccountChargePO();
            extPO.setChargeId(reqBO.getChargeId());
            extPO.setUnifyPushStatus(FscConstants.FscPushStatus.FAIL);
            extPO.setFailReason(fscPushUnifyChargeBillRspBO.getRespDesc());
            this.fscAccountChargeMapper.update(extPO);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(fscPushUnifyChargeBillRspBO.getMsg());
        } else {
            pushLogPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            pushLogPo.setPushParseData(reqBO.getParseData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            FscAccountChargePO extPO = new FscAccountChargePO();
            extPO.setChargeId(reqBO.getChargeId());
            extPO.setUnifyPushStatus(FscConstants.FscPushStatus.SUCCESS);
            this.fscAccountChargeMapper.update(extPO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }
}

