/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcRecvClaimBillBusiServiceImpl
implements FscPushYcRecvClaimBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcRecvClaimBillBusiServiceImpl.class);
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${settle.stage.value:2}")
    private String settleStage;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscPushYcRecvClaimBillBusiRspBO pushYcRecvClaim(FscPushYcRecvClaimBillBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u5355\u4fe1\u606f\uff01" + reqBO.getClaimId());
        }
        if (!FscClaimStatusEnum.CLAIM.getCode().equals(fscRecvClaimPo.getClaimStatus()) && !FscClaimStatusEnum.PRE_CLAIM.getCode().equals(fscRecvClaimPo.getClaimStatus())) {
            return new FscPushYcRecvClaimBillBusiRspBO();
        }
        if (fscRecvClaimPo.getStatus() == 1) {
            return new FscPushYcRecvClaimBillBusiRspBO();
        }
        List claimDetailList = this.fscClaimDetailMapper.selectClaimInfoListByCliaimId(reqBO.getClaimId());
        if (CollectionUtils.isEmpty((Collection)claimDetailList) && fscRecvClaimPo.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) != 0) {
            throw new FscBusinessException("190000", "\u8ba4\u9886\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)claimDetailList) && ((FscClaimDetailBO)claimDetailList.get(0)).getClaimType().equals(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode())) {
            throw new FscBusinessException("190000", "\u4f1a\u5458\u8d39\u8ba4\u9886\u65e0\u9700\u63a8\u9001\u65b0\u4e1a\u8d22\uff01");
        }
        FscPushYcRecvClaimBillBusiRspBO rspBO = new FscPushYcRecvClaimBillBusiRspBO();
        rspBO.setFlag(1);
        rspBO.setOrderNo(fscRecvClaimPo.getClaimNo());
        FscPushLogPO fscPushLogPo = new FscPushLogPO();
        FscPushYcRecvClaimBillReqBO pushReqBo = new FscPushYcRecvClaimBillReqBO();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        try {
            FscPushYcRecvClaimBillBO claimBillBO = new FscPushYcRecvClaimBillBO();
            if (!((FscClaimDetailBO)claimDetailList.get(0)).getClaimType().equals(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode())) {
                FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
                custInfoReqBO.setCustomerName(fscRecvClaimPo.getCustomerName());
                FscGetErpCustInfoRspBO custInfoRspBO = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
                if (!custInfoRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(custInfoRspBO.getRespCode(), custInfoRspBO.getRespDesc());
                }
                claimBillBO.setCUSTOMER_ID(custInfoRspBO.getCustAccountId());
            }
            claimBillBO.setINIT_FLAG(reqBO.getInitFlag());
            claimBillBO.setORG_ID(this.operationOrgId);
            claimBillBO.setORG_NAME(this.operationOrgName);
            claimBillBO.setCHARGEMAN_ID(fscRecvClaimPo.getHandleUserId().toString());
            claimBillBO.setCHARGEMAN_NAME(fscRecvClaimPo.getHandleUserName());
            claimBillBO.setDEPT_ID(fscRecvClaimPo.getHandleDeptId().toString());
            claimBillBO.setDEPT_NAME(fscRecvClaimPo.getHandleDeptName());
            claimBillBO.setRECEIVABLE_CLAIM_NUMBER(fscRecvClaimPo.getClaimNo());
            claimBillBO.setBANK_SERIAL_NUMBER(fscRecvClaimPo.getSerialNumber());
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("RECEIVABLES_CLAIM_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            FscDicDictionaryExernalPO eternalPo1 = new FscDicDictionaryExernalPO();
            eternalPo1.setPCode("RECEIVABLES_CLAIM_BANK_ID");
            Map<String, String> dicMap1 = this.getDicMap(eternalPo1);
            claimBillBO.setRECEIVABLE_CLAIM_TYPE(dicMap.get(fscRecvClaimPo.getRecvType()));
            claimBillBO.setCUSTOMER_NAME(fscRecvClaimPo.getCustomerName());
            claimBillBO.setCUSTOMER_SITE_ID(null);
            claimBillBO.setCUSTOMER_SITE_NAME(null);
            claimBillBO.setSUB_ACCOUNT(fscRecvClaimPo.getChildAccount());
            claimBillBO.setRECEIVABLE_AMT(fscRecvClaimPo.getRecvAmt().toString());
            if (dicMap1.get(fscRecvClaimPo.getBankAccount()) != null) {
                claimBillBO.setRECEIVE_BANK_ID(Long.valueOf(dicMap1.get(fscRecvClaimPo.getBankAccount())));
            } else {
                claimBillBO.setRECEIVE_BANK_ID(fscRecvClaimPo.getBankId());
            }
            claimBillBO.setRECEIVE_BANK(fscRecvClaimPo.getAccountBranch());
            claimBillBO.setSUB_BRANCH(fscRecvClaimPo.getAccountBranch());
            claimBillBO.setBANK_ACCOUNT(fscRecvClaimPo.getBankAccount());
            claimBillBO.setRECEIVABLE_DATE(DateUtil.dateToStr((Date)fscRecvClaimPo.getRecvDate()));
            eternalPo.setPCode("FSC_CLAIM_STATUS_TYPE");
            Map<String, String> claimStatusMap = this.getDicMap(eternalPo);
            claimBillBO.setCLAIM_STATUS(claimStatusMap.get(fscRecvClaimPo.getClaimStatus()));
            claimBillBO.setREMARKS(fscRecvClaimPo.getRemark());
            claimBillBO.setTESCO_ID(fscRecvClaimPo.getClaimId());
            claimBillBO.setRECEIVABLE_CLAIM_ID("");
            claimBillBO.setBILL_DATE(DateUtil.dateToStr((Date)fscRecvClaimPo.getCreateTime()));
            claimBillBO.setUNCLAIM_AMT(fscRecvClaimPo.getNoClaimAmt());
            if (fscRecvClaimPo.getClaimStatus() != null && FscClaimStatusEnum.PRE_CLAIM.getCode().equals(fscRecvClaimPo.getClaimStatus())) {
                claimBillBO.setCLAIM_STATUS("Y");
                claimBillBO.setUNCLAIM_AMT(BigDecimal.ZERO);
            }
            claimBillBO.setPAYEE("");
            if (claimDetailList.size() == 1 && FscClaimTypeEnum.MEM_FEE_CLAIM.getCode().equals(((FscClaimDetailBO)claimDetailList.get(0)).getClaimType())) {
                claimBillBO.setINIT_FLAG("Y");
            }
            if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getLedgerId())) {
                claimBillBO.setDRAFT_ID(fscRecvClaimPo.getLedgerId());
            }
            LinkedList<FscPushYcRecvClaimBillLineBO> claimBillList = new LinkedList<FscPushYcRecvClaimBillLineBO>();
            for (FscClaimDetailBO fscClaimDetailBo : claimDetailList) {
                if ("0".equals(fscClaimDetailBo.getStatus())) continue;
                FscPushYcRecvClaimBillLineBO lineBO = new FscPushYcRecvClaimBillLineBO();
                detailIdList.add(fscClaimDetailBo.getClaimDetailId());
                lineBO.setCHARGEMAN_ID(fscClaimDetailBo.getHandleUserId().toString());
                lineBO.setCHARGEMAN_NAME(fscClaimDetailBo.getHandleUserName());
                lineBO.setDEPT_ID(fscClaimDetailBo.getHandleDeptId().toString());
                lineBO.setDEPT_NAME(fscClaimDetailBo.getHandleDeptName());
                FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
                eternal.setPCode("FSC_YC_CLAIM_TYPE");
                Map<String, String> dicMapE = this.getDicMap(eternal);
                lineBO.setCLAIM_TYPE(dicMapE.get(fscClaimDetailBo.getClaimType()));
                if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getFscOrderId())) {
                    lineBO.setBILL_ID(fscClaimDetailBo.getFscOrderId().toString());
                    lineBO.setBILL_NUMBER(fscClaimDetailBo.getFscOrderNo());
                } else {
                    lineBO.setBILL_NUMBER(fscClaimDetailBo.getDetailNo());
                }
                lineBO.setCLAIM_AMT(fscClaimDetailBo.getClaimAmt());
                lineBO.setCLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBo.getClaimDate()));
                lineBO.setCANCEL_CLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBo.getCancelClaimDate()));
                lineBO.setTESCO_ID(fscClaimDetailBo.getClaimDetailId());
                if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getStatus()) && "1".equals(fscClaimDetailBo.getStatus())) {
                    lineBO.setCANCEL_CLAIM_DATE(null);
                }
                claimBillList.add(lineBO);
            }
            pushReqBo.setReceivable(claimBillBO);
            pushReqBo.setReceivableClaim(claimBillList);
            FscPushYcRecvClaimBillRspBO pushRspBo = this.dealParamToYc(reqBO.getAgentAccount(), pushReqBo, fscPushLogPo);
            if (!pushRspBo.getRespCode().equals("0000")) {
                this.saveLog(fscRecvClaimPo, FscConstants.FscPushStatus.FAIL, fscPushLogPo);
                rspBO.setRespCode(pushRspBo.getRespCode());
                rspBO.setRespDesc(pushRspBo.getRespDesc());
                this.savePushStatus(detailIdList, FscConstants.pushState.NO_PUSH, pushRspBo.getRespDesc(), reqBO.getClaimId());
                return rspBO;
            }
            this.savePushStatus(detailIdList, FscConstants.pushState.SUCCESS, null, reqBO.getClaimId());
            this.pushFile(reqBO, fscRecvClaimPo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u8ba4\u9886\u5355\u5931\u8d25\uff01" + FscCommonUtils.dealStackTrace((Exception)e));
            this.savePushStatus(detailIdList, FscConstants.pushState.NO_PUSH, e.getMessage(), reqBO.getClaimId());
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        this.saveLog(fscRecvClaimPo, FscConstants.FscPushStatus.SUCCESS, fscPushLogPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(FscRecvClaimPO fscRecvClaimPo, Integer status, FscPushLogPO fscPushLogPo) {
        try {
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimPo.getClaimId());
            fscPushLogPo.setObjectNo(fscRecvClaimPo.getClaimNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            int count = this.fscPushLogMapper.insert(fscPushLogPo);
            if (count == 0) {
                throw new ZTBusinessException("\u5b58\u50a8\u5931\u8d25\uff0c\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u7684\u6761\u6570\u4e3a0");
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(List<Long> detailIdList, Integer status, String failReason, Long claimId) {
        if (!CollectionUtils.isEmpty(detailIdList)) {
            this.fscClaimDetailMapper.updateBtachByDetailId(detailIdList, status, failReason);
        }
        FscRecvClaimPO fscRecvClaim = new FscRecvClaimPO();
        fscRecvClaim.setClaimId(claimId);
        fscRecvClaim.setFailReason(failReason);
        fscRecvClaim.setStatus(Integer.valueOf(status == 0 ? 2 : 1));
        this.fscRecvClaimMapper.update(fscRecvClaim);
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }

    private FscPushYcRecvClaimBillRspBO dealParamToYc(String agentAccount, FscPushYcRecvClaimBillReqBO pushReqBo, FscPushLogPO fscPushLogPo) {
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("STAGE", (Object)1);
        jsonObject.put("RECEIPT", (Object)pushReqBo.getReceivable());
        jsonObject.put("RECEIPT_LINE", (Object)pushReqBo.getReceivableClaim());
        jsonObject.put("STAGE", (Object)this.settleStage);
        jsonArray.add((Object)jsonObject);
        fscPushLogPo.setObjData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPo.setPushParseData(encryPtionRspBO.getData());
        FscPushYcRecvClaimBillReqBO pushYcRecvClaimBillReqBO = new FscPushYcRecvClaimBillReqBO();
        pushYcRecvClaimBillReqBO.setData(encryPtionRspBO.getData());
        pushYcRecvClaimBillReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscPushYcRecvClaimBillRspBO fscPushYcRecvClaimBillRspBO = this.fscPushYcRecvClaimBillService.pushRecvClaimBill(pushYcRecvClaimBillReqBO);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(fscPushYcRecvClaimBillRspBO.getRespCode()) ? fscPushYcRecvClaimBillRspBO.getData() : fscPushYcRecvClaimBillRspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPo.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPo.setRespParseData(fscPushYcRecvClaimBillRspBO.getRspData());
        fscPushYcRecvClaimBillRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        return fscPushYcRecvClaimBillRspBO;
    }

    private void pushFile(FscPushYcRecvClaimBillBusiReqBO reqBO, FscRecvClaimPO fscRecvClaimPo) {
        try {
            FscAttachmentPO searchAttachmentPO = new FscAttachmentPO();
            searchAttachmentPO.setObjId(reqBO.getClaimId());
            searchAttachmentPO.setAttachmentType(FscConstants.AttachmentType.CLAIM);
            List attachmentPOS = this.fscAttachmentMapper.getList(searchAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                List fileList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOS), AttachmentBO.class);
                FscPushYcAttachmentAbilityReqBO fscPushYcAttachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                fscPushYcAttachmentAbilityReqBO.setObjId(reqBO.getClaimId());
                fscPushYcAttachmentAbilityReqBO.setObjNo(fscRecvClaimPo.getClaimNo());
                fscPushYcAttachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.CLAIM);
                fscPushYcAttachmentAbilityReqBO.setAgentName(fscRecvClaimPo.getHandleUserName());
                fscPushYcAttachmentAbilityReqBO.setAgentAccount(reqBO.getAgentAccount());
                if (fscRecvClaimPo.getHandleUserId() != null) {
                    fscPushYcAttachmentAbilityReqBO.setUserId(fscRecvClaimPo.getHandleUserId().toString());
                } else {
                    fscPushYcAttachmentAbilityReqBO.setUserId(reqBO.getAgentAccount());
                }
                fscPushYcAttachmentAbilityReqBO.setFileList(fileList);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(fscPushYcAttachmentAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u9644\u4ef6\u62a5\u9519" + e.getMessage());
        }
    }
}

