/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.busi.api.FscRefundBillDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundBillDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundBillDeleteBusiRspBO;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundBillDeleteBusiServiceImpl
implements FscRefundBillDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundBillDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscEsConfig fscEsConfig;
    @Autowired
    private FscElasticsearchUtil fscElasticsearchUtil;

    @Override
    public FscRefundBillDeleteBusiRspBO dealRefundBillDelete(FscRefundBillDeleteBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u7968\u5355\u96c6\u5408[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int count = this.fscOrderRefundMapper.deleteByIds(reqBO.getRefundIds());
        if (count != reqBO.getRefundIds().size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u9000\u7968\u4e3b\u5355\u5931\u8d25\uff01");
        }
        count = this.fscInvoiceRefundRelationMapper.deleteByRefundIds(reqBO.getRefundIds());
        if (count < 0) {
            throw new FscBusinessException("198888", "\u5220\u9664\u9000\u7968\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderRelationMapper.deleteByRefundIds(reqBO.getRefundIds());
        if (count < 0) {
            throw new FscBusinessException("198888", "\u5220\u9664\u9000\u7968\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderItemMapper.deleteByRefundIds(reqBO.getRefundIds());
        if (count < 0) {
            throw new FscBusinessException("198888", "\u5220\u9664\u9000\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.delOrderEs(reqBO.getRefundIds());
        FscRefundBillDeleteBusiRspBO rspBO = new FscRefundBillDeleteBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void delOrderEs(List<Long> refundIds) {
        String endPoint = "/" + this.fscEsConfig.getRefundIndexName() + "/" + this.fscEsConfig.getRefundIndexType() + "/_delete_by_query";
        JSONObject deleteConditionJson = new JSONObject();
        deleteConditionJson.put("refundId", refundIds);
        JSONObject termJson = new JSONObject();
        termJson.put("terms", (Object)deleteConditionJson);
        JSONObject qryJson = new JSONObject();
        qryJson.put("query", (Object)termJson);
        Boolean aBoolean = this.fscElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
        if (!aBoolean.booleanValue()) {
            log.debug("---------------\u5220\u9664\u5931\u8d25---------------");
        }
    }
}

