/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscRefundClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundClaimConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRefundClaimConfirmBusiServiceImpl
implements FscRefundClaimConfirmBusiService {
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;

    @Override
    public FscRefundClaimConfirmBusiRspBO dealRefundClaimConfirm(FscRefundClaimConfirmBusiReqBO reqBO) {
        int count;
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        BigDecimal refundClaimAmt = BigDecimal.ZERO;
        ArrayList<FscOrderRefundPayRelationPo> subRelationList = new ArrayList<FscOrderRefundPayRelationPo>();
        ArrayList<FscOrderRefundPayRelationPo> addRelationList = new ArrayList<FscOrderRefundPayRelationPo>();
        ArrayList<FscClaimDetailPO> updateClaimDetailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscClaimDetailPO> addClaimDetailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<Object> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo()) && fscRecvClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(fscRecvClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo())) {
            settleNoList.add(fscRecvClaimPo.getSettleNo());
        }
        for (FscClaimDetailBO detailBO : reqBO.getClaimDetailList()) {
            if (detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.UNCHANGE) || detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.CANCEL) && detailBO.getClaimDetailId() == null) continue;
            this.valid(detailBO);
            refundClaimAmt = detailBO.getStatus().equals("1") ? refundClaimAmt.add(detailBO.getClaimAmt()) : refundClaimAmt.subtract(detailBO.getCancelAmt());
            FscOrderRefundPayRelationPo refundPayRelationPo = new FscOrderRefundPayRelationPo();
            FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
            BeanUtils.copyProperties((Object)detailBO, (Object)claimDetailPO);
            claimDetailPO.setClaimId(reqBO.getClaimId());
            claimDetailPO.setPushStatus(FscConstants.FscPushStatus.NO_PUSH);
            claimDetailPO.setSysSource(FscSystemSourceEnum.YG.getCode());
            claimDetailPO.setRefundType(reqBO.getRefundType());
            refundPayRelationPo.setId(detailBO.getFscOrderRefundRelationId());
            if (detailBO.getClaimDetailId() == null) {
                claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                addClaimDetailList.add(claimDetailPO);
                refundPayRelationPo.setClaimAmt(claimDetailPO.getClaimAmt());
                addRelationList.add(refundPayRelationPo);
                if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
                settleNoList.add(detailBO.getFscOrderNo());
                continue;
            }
            updateClaimDetailList.add(claimDetailPO);
            refundPayRelationPo.setClaimAmt(detailBO.getCancelAmt());
            subRelationList.add(refundPayRelationPo);
            if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
            settleNoList.remove(detailBO.getFscOrderNo());
        }
        if (fscRecvClaimPo.getNoClaimAmt().subtract(refundClaimAmt).compareTo(reqBO.getNoClaimAmt()) != 0) {
            throw new FscBusinessException("198888", "\u672a\u8ba4\u9886\u91d1\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
        }
        FscRecvClaimPO fscRecvClaim = new FscRecvClaimPO();
        fscRecvClaim.setClaimId(reqBO.getClaimId());
        fscRecvClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0 && reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) != 0) {
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscRecvClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscRecvClaimMapper.update(fscRecvClaim);
        if (!CollectionUtils.isEmpty(addRelationList) && (count = this.fscOrderRefundPayRelationMapper.updateClaimAmtBatchAdd(addRelationList)) != addRelationList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList)) {
            this.fscClaimDetailMapper.insertBatch(addClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(subRelationList) && (count = this.fscOrderRefundPayRelationMapper.updateClaimAmtBatchSub(subRelationList)) != subRelationList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscClaimDetailMapper.updateBatch(updateClaimDetailList);
        }
        FscRefundClaimConfirmBusiRspBO busiRspBO = new FscRefundClaimConfirmBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void valid(FscClaimDetailBO detailBO) {
        if (detailBO.getFscOrderRefundRelationId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[fscOrderRefundRelationId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getStatus())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[status]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getOrderCode() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[orderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getClaimDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[claimDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getPayOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[payOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getPayOrderNo() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[payOrderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

