/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscRefundReceiveYcStatusBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundReceiveYcStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundReceiveYcStatusBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundReceiveYcStatusBusiServiceImpl
implements FscRefundReceiveYcStatusBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;

    @Override
    public FscRefundReceiveYcStatusBusiRspBO dealRefundReceiveYcStatus(FscRefundReceiveYcStatusBusiReqBO reqBO) {
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundIdList(reqBO.getRefundIdList());
        List refundList = this.fscOrderRefundMapper.getList(fscOrderRefundPO);
        ArrayList<FscOrdStateChgLogPO> logPOList = new ArrayList<FscOrdStateChgLogPO>();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        for (FscOrderRefundPO refundPO : refundList) {
            if (!refundPO.getOrderFlow().equals(FscConstants.OrderFlow.REFUND_INVOICE) || !refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION) || !refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.AUDIT_PASS)) continue;
            FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
            fscOrdStateChgLogPo.setFscOrderId(refundPO.getRefundId());
            fscOrdStateChgLogPo.setOldState(refundPO.getRefundStatus());
            fscOrdStateChgLogPo.setNewState(FscConstants.RefundInvoiceStatus.IN_ACCOUNT);
            fscOrdStateChgLogPo.setChgTime(new Date());
            logPOList.add(fscOrdStateChgLogPo);
            refundIds.add(refundPO.getRefundId());
        }
        if (!CollectionUtils.isEmpty(refundIds)) {
            FscOrderRefundPO updatePo = new FscOrderRefundPO();
            updatePo.setRefundIdList(refundIds);
            updatePo.setRefundStatus(FscConstants.RefundInvoiceStatus.IN_ACCOUNT);
            int count = this.fscOrderRefundMapper.updateStatusByRefundIds(updatePo);
            if (count != refundIds.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u51b2\u9500\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
            count = this.fscOrdStateChgLogMapper.insertBatch(logPOList);
            if (count != refundIds.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u65e5\u5fd7\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundIdList(reqBO.getRefundIdList());
        refundPO.setPostStatus(FscConstants.FscPostingStatus.POST);
        this.fscOrderRefundMapper.updateByRefundIds(refundPO);
        FscRefundReceiveYcStatusBusiRspBO rspBO = new FscRefundReceiveYcStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

