/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyUpdateInvoiceStateReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyUpdateInvoiceStateRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifyUpdateInvoiceStateService;
import com.tydic.fsc.common.busi.api.FscUnifyUpdateInvoiceStateBusiService;
import com.tydic.fsc.common.busi.bo.FscUnifyUpdateInvoiceStateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscUnifyUpdateInvoiceStateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscUnifyUpdateInvoiceStateBusiServiceImpl
implements FscUnifyUpdateInvoiceStateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUnifyUpdateInvoiceStateBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscUnifyUpdateInvoiceStateService fscUnifyUpdateInvoiceStateService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;

    @Override
    public FscUnifyUpdateInvoiceStateBusiRspBO updateInvoiceState(FscUnifyUpdateInvoiceStateBusiReqBO reqBO) {
        FscUnifyUpdateInvoiceStateBusiRspBO rspBO = new FscUnifyUpdateInvoiceStateBusiRspBO();
        this.vaildParam(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
        fscOrderExtPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderExtPO orderExtPO = this.fscOrderExtMapper.getModelBy(fscOrderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6269\u5c55\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setInvoiceId(reqBO.getInvoiceId());
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        FscInvoicePO invoicePO = this.fscInvoiceMapper.getModelBy(fscInvoicePO);
        if (invoicePO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u53d1\u7968\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (invoicePO.getUnifyInvoiceId() == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if ("0".equals(reqBO.getInvoiceState())) {
            this.fscInvoiceMapper.setNullUnifyInvoice(reqBO.getInvoiceId());
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        PebExtUnifySettlePersonQryAbilityReqBO personQryAbilityReqBO = new PebExtUnifySettlePersonQryAbilityReqBO();
        personQryAbilityReqBO.setToken(tokenQryAbilityRspBO.getData());
        personQryAbilityReqBO.setUSER_NAME(orderExtPO.getAgentAccount());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u5165\u53c2:" + JSONObject.toJSONString((Object)personQryAbilityReqBO));
        PebExtUnifySettlePersonQryAbilityRspBO personQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonInfo(personQryAbilityReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u51fa\u53c2:" + JSONObject.toJSONString((Object)personQryAbilityRspBO));
        if (!"0000".equals(tokenQryAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", personQryAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)personQryAbilityRspBO.getRows())) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f");
        }
        if (((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID() == null || ((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getUSER_ID() == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u673a\u6784ID\u4fe1\u606f");
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ORG_ID", (Object)((PebExtUnifySettlePersonBO)personQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID());
        jsonObject.put("INVOICE_ID", (Object)invoicePO.getUnifyInvoiceId().toString());
        jsonObject.put("INVOICE_STATUS", (Object)reqBO.getInvoiceState());
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.debug("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u53c2\u6570\u52a0\u5bc6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)encryptionAbilityReqBO));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        FscUnifyUpdateInvoiceStateReqBO fscUnifyUpdateInvoiceStateReqBO = new FscUnifyUpdateInvoiceStateReqBO();
        fscUnifyUpdateInvoiceStateReqBO.setData(encryptionAbilityRspBO.getData());
        fscUnifyUpdateInvoiceStateReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscUnifyUpdateInvoiceStateRspBO fscUnifyUpdateInvoiceStateRspBO = this.fscUnifyUpdateInvoiceStateService.updateInvoiceState(fscUnifyUpdateInvoiceStateReqBO);
        if (!fscUnifyUpdateInvoiceStateRspBO.getRespCode().equals("0000")) {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.FAIL, FscConstants.FscPurchasePushType.ORDER_UPDATE_INVOICE_STATE);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyUpdateInvoiceStateRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(fscUnifyUpdateInvoiceStateRspBO.getMsg());
        } else {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.SUCCESS, FscConstants.FscPurchasePushType.ORDER_UPDATE_INVOICE_STATE);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyUpdateInvoiceStateRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPurchasePushLogPo buildPushLog(FscOrderPO orderPO, Integer pushStatus, Integer pushType) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(orderPO.getFscOrderId());
        pushLogPo.setObjectNo(orderPO.getOrderNo());
        pushLogPo.setPushStatus(pushStatus);
        pushLogPo.setType(pushType);
        pushLogPo.setCreateTime(new Date());
        return pushLogPo;
    }

    private void vaildParam(FscUnifyUpdateInvoiceStateBusiReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getInvoiceId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getInvoiceState())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"0".equals(reqBO.getInvoiceState()) && !"1".equals(reqBO.getInvoiceState())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

