/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FscElectronicSettleStateServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscElectronicSettleStateServiceConsumer.class);
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            log.debug("---------------\u6536\u6b3e\u8ba4\u9886\u540e\u540c\u6b65\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u7ed3\u7b97\u72b6\u6001\u5f00\u59cb---------------");
            List electronicOrderIds = JSON.parseArray((String)proxyMessage.getContent(), Long.class);
            log.debug("\u6536\u6b3e\u8ba4\u9886\u540e\u540c\u6b65\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u7ed3\u7b97\u72b6\u6001\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u5165\u53c2\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)electronicOrderIds));
            if (CollectionUtils.isEmpty((Collection)electronicOrderIds)) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            for (Long orderId : electronicOrderIds) {
                FscOrderPO querVo = new FscOrderPO();
                querVo.setOrderId(orderId);
                querVo.setPayeeId(this.operationOrgId);
                BigDecimal invoiceAmt = this.fscOrderMapper.getInvoiceStatisticalByOrderId(orderId, this.operationOrgId);
                BigDecimal claimAmt = BigDecimal.ZERO;
                FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
                claimDetailPO.setOrderId(orderId);
                claimDetailPO.setStatus("1");
                claimDetailPO.setClaimType("4");
                List fscClaimDetailPOS = this.fscClaimDetailMapper.queryAll(claimDetailPO);
                if (!CollectionUtils.isEmpty((Collection)fscClaimDetailPOS)) {
                    for (FscClaimDetailPO e : fscClaimDetailPOS) {
                        if (e.getClaimAmt() == null) continue;
                        claimAmt = claimAmt.add(e.getClaimAmt());
                    }
                }
                BigDecimal orderAmt = BigDecimal.ZERO;
                UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
                uocInspectionDetailsListPageQueryReqBO.setOrderId(orderId);
                uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
                uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
                uocInspectionDetailsListPageQueryReqBO.setPageSize(1000000);
                uocInspectionDetailsListPageQueryReqBO.setIsChange("0");
                uocInspectionDetailsListPageQueryReqBO.setIsFscQuery("0");
                uocInspectionDetailsListPageQueryReqBO.setOrderType(Integer.valueOf(0));
                log.info("\u8c03\u7528\u8ba2\u5355\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uocInspectionDetailsListPageQueryReqBO));
                UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
                log.info("\u8c03\u7528\u8ba2\u5355\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)inspectionDetailsList));
                if (!inspectionDetailsList.getRespCode().equals("0000")) {
                    this.writeFailLog(orderId, inspectionDetailsList.getRespDesc());
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
                    this.writeFailLog(orderId, "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                    continue;
                }
                for (UocInspectionDetailsListBO row : inspectionDetailsList.getRows()) {
                    orderAmt = orderAmt.add(row.getInspTotalSaleMoney());
                }
                if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0 && claimAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                String statusType = "";
                if (invoiceAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
                    statusType = "5";
                    if (claimAmt.compareTo(BigDecimal.ZERO) > 0 && claimAmt.compareTo(orderAmt) < 0) {
                        statusType = "6";
                    } else if (claimAmt.compareTo(orderAmt) >= 0) {
                        statusType = "7";
                    }
                } else if (invoiceAmt.compareTo(orderAmt) >= 0) {
                    statusType = "8";
                    if (claimAmt.compareTo(BigDecimal.ZERO) > 0 && claimAmt.compareTo(orderAmt) < 0) {
                        statusType = "9";
                    } else if (claimAmt.compareTo(orderAmt) >= 0) {
                        statusType = "10";
                    }
                } else if (claimAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0 && claimAmt.compareTo(orderAmt) < 0) {
                    statusType = "3";
                } else if (claimAmt.compareTo(orderAmt) >= 0) {
                    statusType = "4";
                }
                if (StringUtils.isEmpty((Object)statusType)) continue;
                PebUpdateOrderReqBO orderReqBO = new PebUpdateOrderReqBO();
                orderReqBO.setOrderId(orderId);
                Map stateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_STATUS");
                orderReqBO.setFscStatus((String)stateMap.get(statusType));
                orderReqBO.setFscStatusType(statusType);
                log.info("\u8c03\u7528\u8ba2\u5355\u4fee\u6539\u8ba2\u5355\u7ed3\u7b97\u72b6\u6001\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)orderReqBO));
                PebUpdateOrderRspBO pebUpdateOrderRspBO = this.pebUpdateOrderAbilityService.updateFscStatus(orderReqBO);
                log.info("\u8c03\u7528\u8ba2\u5355\u4fee\u6539\u8ba2\u5355\u7ed3\u7b97\u72b6\u6001\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)pebUpdateOrderRspBO));
                if (pebUpdateOrderRspBO.getRespCode().equals("0000")) continue;
                throw new FscBusinessException(pebUpdateOrderRspBO.getRespCode(), pebUpdateOrderRspBO.getRespDesc());
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void writeFailLog(Long orderId, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(orderId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(desc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ELECTRONIC_SETTLE_STATE_SYNC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

