/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillOrderRefundInvoiceChangeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundInvoiceChangeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundInvoiceChangeAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderRefundInvoiceChangeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundInvoiceChangeBusiReqBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FscRefundInvoiceChangeConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscRefundInvoiceChangeConsumer.class);
    @Autowired
    private FscBillOrderRefundInvoiceChangeAbilityService fscBillOrderRefundInvoiceChangeAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscBillOrderRefundInvoiceChangeBusiService fscBillOrderRefundInvoiceChangeBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.debug("---------------\u53d1\u7968\u6362\u5f00\u53d1\u8d77\u670d\u52a1\u6d88\u8d39\u8005\u5f00\u59cb---------------");
        FscBillOrderRefundInvoiceChangeAbilityReqBO abilityReqBO = (FscBillOrderRefundInvoiceChangeAbilityReqBO)JSONObject.parseObject((String)message.getContent(), FscBillOrderRefundInvoiceChangeAbilityReqBO.class);
        try {
            FscBillOrderRefundInvoiceChangeAbilityRspBO abilityRspBO = this.fscBillOrderRefundInvoiceChangeAbilityService.dealRefundInvoiceChange(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException(abilityRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            try {
                FscBillOrderRefundInvoiceChangeBusiReqBO busiReqBO = new FscBillOrderRefundInvoiceChangeBusiReqBO();
                busiReqBO.setRefundId(abilityReqBO.getRefundId());
                busiReqBO.setReopenStatus(Integer.valueOf(0));
                this.fscBillOrderRefundInvoiceChangeBusiService.dealRefundInvoiceStatus(busiReqBO);
                FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
                fscOrderFailLogUpdateBusiReqBO.setObjId(abilityReqBO.getRefundId());
                fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(e.getMessage());
                fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_REFUND_INVOICE_CHANGE_FAIL);
                this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

