/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscSignBackFillInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.FscSignBackFillInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSignBackFillInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class FscSignBackFillInvoiceServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscSignBackFillInvoiceServiceConsumer.class);
    @Autowired
    private FscSignBackFillInvoiceBusiService fscSignBackFillInvoiceBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscSignBackFillInvoiceBusiRspBO rspBO;
            FscSignBackFillInvoiceBusiReqBO reqBO = (FscSignBackFillInvoiceBusiReqBO)((Object)JSON.parseObject((String)message.getContent(), FscSignBackFillInvoiceBusiReqBO.class));
            if (log.isDebugEnabled()) {
                log.debug("\u5f02\u6b65\u56de\u586b\u5e94\u4ed8\u5355\u53d1\u7968\u53f7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
            }
            if (!(rspBO = this.fscSignBackFillInvoiceBusiService.dealSignBackFillInvoice(reqBO)).getRespCode().equals("0000")) {
                this.writeFailLog(reqBO.getFscOrderId(), rspBO);
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getFscOrderIds())) {
                for (Long fscOrderId : rspBO.getFscOrderIds()) {
                    this.sendMq(fscOrderId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u56de\u586b\u5e94\u4ed8\u5355\u53d1\u7968\u53f7\u5931\u8d25\uff01" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void writeFailLog(Long fscOrderId, FscRspBaseBO rspBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_SIGN_BACK_FILL_INVOICE_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void sendMq(Long orderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

