/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.busi.api.FscCheckOneThreadBusiService;
import com.tydic.fsc.bill.busi.bo.FscAccountSerialReqBo;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeClaimAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeClaimAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeClaimBusiService;
import com.tydic.fsc.common.busi.api.FscEmployeeAccountChargeClaimWelfareBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiRspBO;
import com.tydic.fsc.common.consumer.bo.FscOrderStatusSyncBO;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService"})
public class FscAccountChargeClaimAbilityServiceImpl
implements FscAccountChargeClaimAbilityService {
    @Autowired
    private FscAccountChargeClaimBusiService fscAccountChargeClaimBusiService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscCheckOneThreadBusiService fscCheckOneThreadBusiService;
    @Autowired
    private FscEmployeeAccountChargeClaimWelfareBusiService fscEmployeeAccountChargeClaimWelfareBusiService;
    @Resource(name="fscSyncOrderSettleStatusMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderSettleStatusMqServiceProvider;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    private static final Integer CHARGE_FLAGE = 444;
    public static final Integer TAB_ID = 30001;
    @Value(value="${es.FSC_ORDER_SETTLE_STATUS_SYNC_TOPIC:FSC_ORDER_SETTLE_STATUS_SYNC_TOPIC}")
    private String orderStatusTopic;
    @Value(value="${es.FSC_ORDER_SETTLE_STATUS_SYNC_TAG:FSC_ORDER_SETTLE_STATUS_SYNC_TAG}")
    private String orderStatusTag;

    /*
     * Enabled aggressive block sorting
     */
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountChargeClaim"})
    public FscAccountChargeClaimAbilityRspBO dealAccountChargeClaim(@RequestBody FscAccountChargeClaimAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2chargeId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscAccountChargeClaimBusiRspBO busiRspBO = null;
        FscAccountChargeClaimBusiReqBO busiReqBO = (FscAccountChargeClaimBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscAccountChargeClaimBusiReqBO.class));
        if ("4".equals(reqBO.getBusiType())) {
            if (reqBO.getOperationType() != 2) {
                List chargeDetailList = this.fscAccountChargeDetailMapper.queryByChargeId(reqBO.getChargeId());
                List collect = chargeDetailList.stream().map(FscAccountChargeDetailPO::getUseDeptId).collect(Collectors.toList());
                FscAccountSerialReqBo fscAccountSerialReqBo = new FscAccountSerialReqBo();
                fscAccountSerialReqBo.setOrgIds(collect);
                fscAccountSerialReqBo.setSerialNumber(CHARGE_FLAGE);
                List list = this.fscCheckOneThreadBusiService.getList(fscAccountSerialReqBo);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    FscAccountChargeClaimAbilityRspBO fscAccountChargeAbilityRspBO = new FscAccountChargeClaimAbilityRspBO();
                    fscAccountChargeAbilityRspBO.setRespCode("7777");
                    fscAccountChargeAbilityRspBO.setRespDesc("\u5f53\u524d\u673a\u6784\u6b63\u5728\u5145\u503c\u8bf7\u7a0d\u540e");
                    return fscAccountChargeAbilityRspBO;
                }
                ArrayList<FscAccountSerialReqBo> addBos = new ArrayList<FscAccountSerialReqBo>();
                for (Long orgId : collect) {
                    FscAccountSerialReqBo fscAccountSerial = new FscAccountSerialReqBo();
                    Long serialId = Sequence.getInstance().nextId();
                    fscAccountSerial.setSerialId(serialId);
                    fscAccountSerial.setOrgId(orgId);
                    fscAccountSerial.setSerialNumber(CHARGE_FLAGE);
                    addBos.add(fscAccountSerial);
                }
                this.fscCheckOneThreadBusiService.add(addBos);
                busiRspBO = this.fscEmployeeAccountChargeClaimWelfareBusiService.dealAccountChargeClaim(busiReqBO);
                List serialIds = addBos.stream().map(FscAccountSerialReqBo::getSerialId).collect(Collectors.toList());
                FscAccountSerialReqBo delete = new FscAccountSerialReqBo();
                delete.setSerialIds(serialIds);
                this.fscCheckOneThreadBusiService.delete(delete);
            } else {
                busiRspBO = this.fscEmployeeAccountChargeClaimWelfareBusiService.dealAccountChargeClaim(busiReqBO);
            }
        } else {
            busiRspBO = this.fscAccountChargeClaimBusiService.dealAccountChargeClaim(busiReqBO);
        }
        if (busiRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty(busiRspBO.getPushDetailBOList())) {
            this.dealPushYc(busiRspBO, reqBO.getAgentAccount());
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscAccountChargeClaimAbilityRspBO)JSONObject.parseObject((String)respString, FscAccountChargeClaimAbilityRspBO.class);
    }

    private void dealPushYc(FscAccountChargeClaimBusiRspBO busiRspBO, String agentAccount) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(busiRspBO.getClaimId());
        abilityReqBO.setClaimList(busiRspBO.getPushDetailBOList());
        abilityReqBO.setAgentAccount(agentAccount);
        FscPushYcRecvClaimBillAbilityRspBO abilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
    }

    @PostMapping(value={"dealAccountChargeClaimed"})
    public FscAccountChargeClaimAbilityRspBO dealAccountChargeClaimed(@RequestBody FscAccountChargeClaimAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOrgIdWeb())) {
            throw new FscBusinessException("190000", "\u5165\u53c2orgIdWeb\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("190000", "\u5165\u53c2chargeAmount\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscAccountChargeClaimBusiReqBO busiReqBO = (FscAccountChargeClaimBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscAccountChargeClaimBusiReqBO.class));
        FscAccountChargeClaimBusiRspBO busiRspBO = this.fscAccountChargeClaimBusiService.dealAccountChargeClaimed(busiReqBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getOrderIds())) {
            ArrayList<Long> synOrderIds = new ArrayList<Long>();
            UocSalesSingleDetailsListQueryReqBO uocSalesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
            uocSalesSingleDetailsListQueryReqBO.setOrderIdList(busiRspBO.getOrderIds());
            uocSalesSingleDetailsListQueryReqBO.setTabId(TAB_ID);
            uocSalesSingleDetailsListQueryReqBO.setPageSize(1000000);
            UocSalesSingleDetailsListQueryRspBO salesListRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(uocSalesSingleDetailsListQueryReqBO);
            if ("0000".equals(salesListRspBO.getRespCode())) {
                for (UocPebUpperOrderAbilityBO orderAbilityBO : salesListRspBO.getRows()) {
                    if (CollectionUtils.isEmpty((Collection)orderAbilityBO.getChildOrderList()) || String.valueOf(FscOrderTypeEnum.INDIVIDUALLY.getCode()).equals(((UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0)).getOrderType()) || String.valueOf(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode()).equals(((UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0)).getOrderType()) || StringUtils.isEmpty((Object)((UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0)).getOrderId())) continue;
                    synOrderIds.add(Long.parseLong(((UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0)).getOrderId()));
                }
            }
            if (!CollectionUtils.isEmpty(synOrderIds)) {
                FscOrderStatusSyncBO fscOrderStatusSyncBO = new FscOrderStatusSyncBO();
                fscOrderStatusSyncBO.setOrderIdList(synOrderIds);
                this.fscSyncOrderSettleStatusMqServiceProvider.send(new ProxyMessage(this.orderStatusTopic, this.orderStatusTag, JSONObject.toJSONString((Object)fscOrderStatusSyncBO)));
            }
        }
        return (FscAccountChargeClaimAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscAccountChargeClaimAbilityRspBO.class);
    }
}

