/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityRspBO;
import com.tydic.fsc.common.ability.impl.FscComOrderEsSyncThreadsImpl;
import com.tydic.fsc.common.busi.api.FscComOrderSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderListBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscThreadPoolExecutorConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderSyncAbilityServiceImpl
implements FscComOrderSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderSyncAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="fscSyncOrderListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Value(value="${es.FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    private static final ThreadPoolExecutor executor = FscThreadPoolExecutorConfig.poolExecutor;
    @Autowired
    private FscComOrderSyncEsBusiService fscComOrderSyncEsBusiService;
    @Autowired
    private FscEsSyncComOrderListBusiService fscEsSyncComOrderListBusiService;
    @Value(value="${auto.es.pageSize:500}")
    private int PAGE_SIZE;

    public void dealComOrderSyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
        }
    }

    private void writeFailLog(FscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public void syncAllComOrderList(FscComOrderListSyncAbilityReqBO reqBO) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
            }
        }
    }

    public FscComOrderListSyncAbilityRspBO dealSyncAllOrder(FscComOrderListSyncAbilityReqBO reqBO) {
        if (reqBO.getOrderFlow() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2orderFlow\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPO = (FscOrderPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscOrderPO.setOrderBy("CREATE_TIME DESC");
        List fscOrderList = this.fscOrderMapper.getListByCreateTime(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderList)) {
            return new FscComOrderListSyncAbilityRspBO();
        }
        FscComOrderListSyncAbilityRspBO rspBO = new FscComOrderListSyncAbilityRspBO();
        if (reqBO.getIsThread().booleanValue()) {
            ArrayList<FscSyncReqBO> dataList = new ArrayList<FscSyncReqBO>(fscOrderList.size());
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO syncReqBO = new FscSyncReqBO();
                syncReqBO.setFscOrderId(orderPO.getFscOrderId());
                dataList.add(syncReqBO);
            }
            try {
                FscComOrderEsSyncThreadsImpl syncThreads = new FscComOrderEsSyncThreadsImpl();
                if (syncThreads.handleList(dataList, reqBO.getThreadNum(), false).booleanValue()) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                }
            }
            catch (Exception e) {
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
            }
        } else {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO reqBo = new FscSyncReqBO();
                reqBo.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBo)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        }
        return null;
    }

    public FscComOrderListSyncAbilityRspBO syncAllComOrderListPage(FscComOrderListSyncAbilityReqBO reqBO) {
        int count;
        long startTime = System.currentTimeMillis();
        FscOrderPO orderPO = new FscOrderPO();
        if (Objects.nonNull(reqBO.getOrderFlow())) {
            orderPO.setOrderFlow(reqBO.getOrderFlow());
        }
        if (Objects.nonNull(reqBO.getCreateTimeStart())) {
            orderPO.setCreateTimeStart(reqBO.getCreateTimeStart());
        }
        if (Objects.nonNull(reqBO.getCreateTimeEnd())) {
            orderPO.setCreateTimeEnd(reqBO.getCreateTimeEnd());
        }
        int pageCount = (count = this.fscOrderMapper.qryOrderCount(orderPO)) % this.PAGE_SIZE == 0 ? count / this.PAGE_SIZE : count / this.PAGE_SIZE + 1;
        log.info("syncAllComOrderListPage \u540c\u6b65\u7ed3\u7b97\u5217\u8868\uff0c\u603b\u6570:{},\u603b\u9875\u6570:{}", (Object)count, (Object)pageCount);
        CountDownLatch countDownLatch = new CountDownLatch(pageCount);
        Page pageBO = new Page();
        pageBO.setPageSize(this.PAGE_SIZE);
        orderPO.setOrderBy("CREATE_TIME DESC");
        for (int page = 0; page < pageCount; ++page) {
            pageBO.setPageNo(page);
            List fscOrderIds = this.fscOrderMapper.qryOrderPageIds(orderPO, pageBO);
            List syncList = fscOrderIds.stream().map(x -> {
                FscSyncReqBO syncReqBO = new FscSyncReqBO();
                syncReqBO.setFscOrderId((Long)x);
                return syncReqBO;
            }).collect(Collectors.toList());
            executor.submit(() -> {
                try {
                    this.syncFscData(syncList);
                }
                catch (Exception e) {
                    log.error("syncAllComOrderListPage \u540c\u6b65es\u5931\u8d25:{}", (Object)e.getMessage());
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("syncAllComOrderListPage error:{}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        executor.shutdown();
        long endTime = System.currentTimeMillis();
        log.info("syncAllComOrderListPage \u540c\u6b65es\u6d41\u7a0b\u65b9\u5f0f\uff1a{},\u540c\u6b65\u6d88\u8017\u65f6\u95f4(\u5206)\uff1a{}", (Object)reqBO.getOrderFlow(), (Object)((endTime - startTime) / 1000L / 60L));
        return null;
    }

    private void syncFscData(List<FscSyncReqBO> syncList) {
        syncList.forEach(x -> {
            try {
                x.setIsStatistics(true);
                FscComOrderListQueryBusiReqBO fscComOrderListQueryBusiReqBO = (FscComOrderListQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)x), FscComOrderListQueryBusiReqBO.class);
                FscComOrderSyncRspBO fscComOrderSyncRspBO = this.fscComOrderSyncEsBusiService.dealComOrderSyncEs(fscComOrderListQueryBusiReqBO);
                if (fscComOrderSyncRspBO.getRespCode().equals("0000")) {
                    FscComOrderListEsSyncRspBO fscComOrderListEsSyncRspBO = this.fscEsSyncComOrderListBusiService.esSyncComOrderList(fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO());
                    if (!fscComOrderListEsSyncRspBO.getRespCode().equals("0000")) {
                        log.error("syncAllComOrderListPage \u7ed3\u7b97\u5355id:{},\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)x.getFscOrderId(), (Object)fscComOrderSyncRspBO.getRespDesc());
                    }
                } else {
                    log.error("syncAllComOrderListPage \u7ed3\u7b97\u5355id:{},\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)x.getFscOrderId(), (Object)fscComOrderSyncRspBO.getRespDesc());
                }
            }
            catch (Exception e) {
                log.error("syncAllComOrderListPage \u7ed3\u7b97\u5355id:{},\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)x.getFscOrderId(), (Object)e);
            }
        });
    }
}

