/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bo.FscItemInvoiceInfoBO;
import com.tydic.fsc.common.ability.api.FscInspectionInvoiceInfoAbilityService;
import com.tydic.fsc.common.ability.bo.FscInspectionInvoiceInfoAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscInspectionInvoiceInfoAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscInspectionItemInvoiceInfoListAbilityRspBO;
import com.tydic.fsc.common.ability.enums.FscInvoiceStateEnum;
import com.tydic.fsc.dao.FscOrderItemMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscInspectionInvoiceInfoAbilityService"})
public class FscInspectionInvoiceInfoAbilityServiceImpl
implements FscInspectionInvoiceInfoAbilityService {
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"queryInspectionInvoiceInfo"})
    public FscInspectionInvoiceInfoAbilityRspBO queryInspectionInvoiceInfo(@RequestBody FscInspectionInvoiceInfoAbilityReqBO reqBO) {
        FscInspectionInvoiceInfoAbilityRspBO fscInspectionInvoiceInfoAbilityRspBO = new FscInspectionInvoiceInfoAbilityRspBO();
        List itemInvoiceInfoList = this.fscOrderItemMapper.selectListByAcceptOrderId(reqBO.getInspectionVoucherId());
        if (CollectionUtils.isEmpty((Collection)itemInvoiceInfoList)) {
            return fscInspectionInvoiceInfoAbilityRspBO;
        }
        this.handle(itemInvoiceInfoList, fscInspectionInvoiceInfoAbilityRspBO, reqBO);
        return fscInspectionInvoiceInfoAbilityRspBO;
    }

    private void handle(List<FscItemInvoiceInfoBO> itemInvoiceInfoList, FscInspectionInvoiceInfoAbilityRspBO fscInspectionInvoiceInfoAbilityRspBO, FscInspectionInvoiceInfoAbilityReqBO reqBO) {
        BigDecimal totalInvoicedAmt = itemInvoiceInfoList.stream().map(FscItemInvoiceInfoBO::getCurrentInvoiceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalInvoicedNum = itemInvoiceInfoList.stream().map(FscItemInvoiceInfoBO::getCurrentInvoiceNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        Long fscOrderId = itemInvoiceInfoList.get(0).getFscOrderId();
        List<FscItemInvoiceInfoBO> fscOrderItemList = itemInvoiceInfoList.stream().filter(e -> fscOrderId.equals(e.getFscOrderId())).collect(Collectors.toList());
        BigDecimal totalInvoiceAmt = fscOrderItemList.stream().map(FscItemInvoiceInfoBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalInvoiceNum = fscOrderItemList.stream().map(FscItemInvoiceInfoBO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        fscInspectionInvoiceInfoAbilityRspBO.setInspectionVoucherId(itemInvoiceInfoList.get(0).getAcceptOrderId());
        fscInspectionInvoiceInfoAbilityRspBO.setTotalInvoicedAmt(totalInvoicedAmt);
        fscInspectionInvoiceInfoAbilityRspBO.setTotalInvoicedNum(totalInvoicedNum);
        fscInspectionInvoiceInfoAbilityRspBO.setTotalLeaveInvoiceAmt(totalInvoiceAmt.subtract(totalInvoicedAmt));
        fscInspectionInvoiceInfoAbilityRspBO.setTotalLeaveInvoiceNum(totalInvoiceNum.subtract(totalInvoicedNum));
        if (totalInvoicedNum.compareTo(BigDecimal.ZERO) == 0) {
            fscInspectionInvoiceInfoAbilityRspBO.setInvoiceState(FscInvoiceStateEnum.NO_INVOICED.getCode());
        } else if (totalInvoiceNum.compareTo(totalInvoicedNum) == 0) {
            fscInspectionInvoiceInfoAbilityRspBO.setInvoiceState(FscInvoiceStateEnum.INVOICED.getCode());
        } else {
            fscInspectionInvoiceInfoAbilityRspBO.setInvoiceState(FscInvoiceStateEnum.PART_INVOICED.getCode());
        }
        Map<Long, BigDecimal> invoicedAmtMap = itemInvoiceInfoList.stream().collect(Collectors.groupingBy(FscItemInvoiceInfoBO::getOrderItemId, Collectors.mapping(FscItemInvoiceInfoBO::getCurrentInvoiceAmt, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        if (CollectionUtils.isEmpty(invoicedAmtMap)) {
            throw new ZTBusinessException("\u540e\u53f0\u8f6c\u6362\u5f02\u5e38\uff0c\u9a8c\u6536\u5355id\uff1a" + reqBO.getInspectionVoucherId());
        }
        Map<Long, BigDecimal> invoicedNumMap = itemInvoiceInfoList.stream().collect(Collectors.groupingBy(FscItemInvoiceInfoBO::getOrderItemId, Collectors.mapping(FscItemInvoiceInfoBO::getCurrentInvoiceNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        if (CollectionUtils.isEmpty(invoicedNumMap)) {
            throw new ZTBusinessException("\u540e\u53f0\u8f6c\u6362\u5f02\u5e38\uff0c\u9a8c\u6536\u5355id\uff1a" + reqBO.getInspectionVoucherId());
        }
        ArrayList itemInvoiceInfoListRspBO = new ArrayList();
        fscOrderItemList.forEach(e -> {
            FscInspectionItemInvoiceInfoListAbilityRspBO itemRspBO = new FscInspectionItemInvoiceInfoListAbilityRspBO();
            itemRspBO.setInspectionItemId(e.getOrderItemId());
            itemRspBO.setInvoicedAmt((BigDecimal)invoicedAmtMap.get(e.getOrderItemId()));
            itemRspBO.setInvoicedNum((BigDecimal)invoicedNumMap.get(e.getOrderItemId()));
            itemInvoiceInfoListRspBO.add(itemRspBO);
        });
        fscInspectionInvoiceInfoAbilityRspBO.setItemInvoiceInfoList(itemInvoiceInfoListRspBO);
    }
}

