/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.payVerificationSelectedPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService"})
public class FscPayVerificationAbilityServiceImpl
implements FscPayVerificationAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;

    @PostMapping(value={"queryPayVerificationPageList"})
    public FscPayVerificationAbilityRspBO queryPayVerificationPageList(@RequestBody FscPayVerificationAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageNo() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageSize() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscPayVerificationAbilityRspBO rspBO = new FscPayVerificationAbilityRspBO();
        List orderIds = this.fscOrderMapper.selectOrderIds(reqBO.getFscOrderId(), reqBO.getContractId());
        if (CollectionUtils.isEmpty((Collection)orderIds)) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setPayTimeStart(reqBO.getPayTimeStart());
        queryVo.setPayTimeEnd(reqBO.getPayTimeEnd());
        queryVo.setOrderNo(reqBO.getOrderNo());
        queryVo.setPayOperName(reqBO.getPayOperName());
        queryVo.setPayAmountStart(reqBO.getPayAmountStart());
        queryVo.setPayAmountEnd(reqBO.getPayAmountEnd());
        queryVo.setOrderIds(orderIds);
        queryVo.setSelectedOrderNos(reqBO.getSelectedOrderNos());
        queryVo.setPayerName(reqBO.getPayerName());
        queryVo.setOrderCodeStr(reqBO.getOrderCode());
        queryVo.setBuynerNo(this.operationOrgCode);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSelectedBos())) {
            List collect = reqBO.getSelectedBos().stream().map(e -> {
                payVerificationSelectedPO po = new payVerificationSelectedPO();
                po.setShouldPayId(e.getShouldPayId());
                po.setFscOrderId(e.getFscOrderId());
                return po;
            }).collect(Collectors.toList());
            queryVo.setPayVerificationSelectedPOS(collect);
        }
        List orderList = new ArrayList();
        orderList = orderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscOrderMapper.selectPrePayVerification(queryVo, page) : this.fscOrderMapper.selectOrderPrePayVerification(queryVo, page);
        ArrayList<FscComOrderListBO> orderInfoList = new ArrayList<FscComOrderListBO>(orderList.size());
        for (FscOrderPO fscOrderPo : orderList) {
            FscComOrderListBO infoBo = new FscComOrderListBO();
            BeanUtils.copyProperties((Object)fscOrderPo, (Object)infoBo);
            infoBo.setShouldPaidAmount(BigDecimal.ZERO);
            if (fscOrderPo.getPaidAmount() != null && fscOrderPo.getPaidAmount().compareTo(fscOrderPo.getPayAmount()) >= 0) {
                infoBo.setShouldPaidAmount(fscOrderPo.getPayAmount());
            }
            orderInfoList.add(infoBo);
        }
        rspBO.setRows(orderInfoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

