/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyPayBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillBusiReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillBusiRspBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayBillBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayCapitalBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayContractBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPayLineBO;
import com.tydic.fsc.common.ability.bo.FscUnifyPaySettleBO;
import com.tydic.fsc.common.busi.api.FscPushUnifyFailBusiService;
import com.tydic.fsc.common.busi.api.FscPushUnifyPrePayBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyFailBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscContractCapitalPlanPo;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdContractBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushUnifyPayBillAbilityService"})
public class FscPushUnifyPayBillAbilityServiceImpl
implements FscPushUnifyPayBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyPayBillAbilityServiceImpl.class);
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private PebUocUnifyContractQryAbilityService pebUocUnifyContractQryAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscPushUnifyPrePayBillBusiService fscPushUnifyPrePayBillBusiService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPushUnifyFailBusiService fscPushUnifyFailBusiService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyPayBill"})
    public FscPushUnifyPayBillAbilityRspBO dealPushUnifyPayBill(@RequestBody FscPushUnifyPayBillAbilityReqBO reqBO) {
        FscPushUnifyPayBillBusiRspBO pushRspBO;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4ed8\u6b3e\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        List shouldPayPoList = this.fscShouldPayMapper.getByFscOrderId(orderPO.getFscOrderId());
        FscPushUnifyPayBillAbilityRspBO rspBO = new FscPushUnifyPayBillAbilityRspBO();
        if (((FscShouldPayPO)shouldPayPoList.get(0)).getShouldPayMethod().equals(FscConstants.PaymentMethod.PRE_PAY)) {
            FscPushUnifyPayBillBusiReqBO pushReqBO;
            try {
                pushReqBO = this.buildPrePayBillInfo(orderPO, reqBO, shouldPayPoList);
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u9884\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + FscCommonUtils.dealStackTrace((Exception)e));
                e.printStackTrace();
                this.dealFail(orderPO.getFscOrderId(), e.getMessage());
                this.sendMq(reqBO.getFscOrderId());
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            pushRspBO = this.fscPushUnifyPrePayBillBusiService.dealPushPayBill(pushReqBO);
        } else {
            FscPushUnifyPayBillBusiReqBO pushReqBO;
            try {
                pushReqBO = this.buildPayBillInfo(orderPO, reqBO);
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + FscCommonUtils.dealStackTrace((Exception)e));
                e.printStackTrace();
                this.dealFail(orderPO.getFscOrderId(), e.getMessage());
                this.sendMq(reqBO.getFscOrderId());
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            pushRspBO = this.fscPushUnifyPrePayBillBusiService.dealPushPayBill(pushReqBO);
        }
        this.sendMq(reqBO.getFscOrderId());
        return (FscPushUnifyPayBillAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pushRspBO), FscPushUnifyPayBillAbilityRspBO.class);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyPayBatch"})
    public FscPushUnifyPayBillAbilityRspBO dealPushUnifyPayBatch(@RequestBody FscPushUnifyPayBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355id\u96c6\u5408[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscPushUnifyPayBillAbilityReqBO billAbilityReqBO = new FscPushUnifyPayBillAbilityReqBO();
            billAbilityReqBO.setFscOrderId(fscOrderId);
            FscPushUnifyPayBillAbilityRspBO rspBO = this.dealPushUnifyPayBill(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u7ed3\u7b97\u5355[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushUnifyPayBillAbilityRspBO rspBO = new FscPushUnifyPayBillAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPushUnifyPayBillBusiReqBO buildPayBillInfo(FscOrderPO orderPO, FscPushUnifyPayBillAbilityReqBO reqBO) {
        FscPushUnifyPayBillBusiReqBO pushReqBO = new FscPushUnifyPayBillBusiReqBO();
        FscUnifyPayBillBO payBillBO = this.buildPayInfo(orderPO, false);
        List<FscUnifyPayCapitalBO> capitalList = this.buildCapitalInfo(orderPO, false);
        List<FscUnifyPayLineBO> payLineList = this.buildPayLine(orderPO);
        LinkedList<FscUnifyPaySettleBO> settleList = new LinkedList<FscUnifyPaySettleBO>();
        this.buildSettleInfo(orderPO, payBillBO, settleList);
        if (!CollectionUtils.isEmpty(capitalList)) {
            BigDecimal capitalAmount = capitalList.stream().map(FscUnifyPayCapitalBO::getEXE_AMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = settleList.stream().map(FscUnifyPaySettleBO::getAMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payAmount.compareTo(capitalAmount) != 0) {
                throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u548c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6b63\u540e\u63d0\u4ea4\uff01");
            }
        }
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(orderPO.getFscOrderId());
        List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
        payBillBO.setDOC_COUNT(Integer.valueOf(attachmentPOS.size()));
        ArrayList<FscUnifyAttachmentBO> attachmentBOList = new ArrayList<FscUnifyAttachmentBO>();
        this.buildFileInfo(attachmentBOList, orderPO, payBillBO, false);
        pushReqBO.setFscOrderId(orderPO.getFscOrderId());
        pushReqBO.setIsPrePay(Boolean.valueOf(false));
        pushReqBO.setToken(payBillBO.getToken());
        payBillBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillBO);
        jsonObject.put("conLine", settleList);
        jsonObject.put("celine", capitalList);
        jsonObject.put("payLine", payLineList);
        jsonObject.put("fileList", attachmentBOList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private FscPushUnifyPayBillBusiReqBO buildPrePayBillInfo(FscOrderPO orderPO, FscPushUnifyPayBillAbilityReqBO reqBO, List<FscShouldPayPO> shouldPayPoList) {
        FscPushUnifyPayBillBusiReqBO pushReqBO = new FscPushUnifyPayBillBusiReqBO();
        FscUnifyPayBillBO payBillBO = this.buildPayInfo(orderPO, true);
        List<Long> orderIdList = shouldPayPoList.stream().map(FscShouldPayPO::getOrderId).distinct().collect(Collectors.toList());
        PebUocUnifyContractQryAbilityRspBO contractQryAbilityRspBO = this.qryOrderContractInfo(orderIdList, orderPO.getBuynerNo());
        payBillBO.setVENDOR_SITE_CODE(contractQryAbilityRspBO.getVendorSiteName());
        List<FscUnifyPayContractBO> contractList = this.buildContractInfo(contractQryAbilityRspBO.getContractMap(), shouldPayPoList, orderPO, payBillBO);
        List<FscUnifyPayCapitalBO> capitalList = this.buildCapitalInfo(orderPO, true);
        if (!CollectionUtils.isEmpty(capitalList)) {
            BigDecimal capitalAmount = capitalList.stream().map(FscUnifyPayCapitalBO::getEXE_AMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = contractList.stream().map(FscUnifyPayContractBO::getAMOUNT).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payAmount.compareTo(capitalAmount) != 0) {
                throw new FscBusinessException("198888", "\u8d44\u91d1\u8ba1\u5212\u548c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6b63\u540e\u63d0\u4ea4\uff01");
            }
        }
        ArrayList<FscUnifyAttachmentBO> attachmentBOList = new ArrayList<FscUnifyAttachmentBO>();
        this.buildFileInfo(attachmentBOList, orderPO, payBillBO, true);
        pushReqBO.setFscOrderId(orderPO.getFscOrderId());
        pushReqBO.setIsPrePay(Boolean.valueOf(true));
        pushReqBO.setToken(payBillBO.getToken());
        payBillBO.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)payBillBO);
        jsonObject.put("fileList", attachmentBOList);
        jsonObject.put("celine", capitalList);
        jsonObject.put("conLine", contractList);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.info("--------\u63a8\u9001\u4e1a\u8d22\u4ed8\u6b3e\u4fe1\u606f\u660e\u6587\u6253\u5370\uff1a" + JSON.toJSON((Object)jsonArray.toJSONString()));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private PebUocUnifyContractQryAbilityRspBO qryOrderContractInfo(List<Long> orderIdList, String buynerNo) {
        PebUocUnifyContractQryAbilityReqBO contractQryAbilityReqBO = new PebUocUnifyContractQryAbilityReqBO();
        contractQryAbilityReqBO.setOrderIdList(orderIdList);
        contractQryAbilityReqBO.setBuynerNo(buynerNo);
        PebUocUnifyContractQryAbilityRspBO contractQryAbilityRspBO = this.pebUocUnifyContractQryAbilityService.qryOrderContractInfo(contractQryAbilityReqBO);
        if (!contractQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(contractQryAbilityRspBO.getRespCode(), contractQryAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)contractQryAbilityRspBO.getContractMap())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return contractQryAbilityRspBO;
    }

    private void buildFileInfo(List<FscUnifyAttachmentBO> attachmentBOList, FscOrderPO orderPO, FscUnifyPayBillBO payBillBO, Boolean isPrePay) {
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(orderPO.getFscOrderId());
        List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
        for (FscAttachmentPO fscAttachmentPO : attachmentPOS) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
            uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setUUID("zjht");
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setUSER_NAME(payBillBO.getPERSON_NAME());
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBOList.add(attachmentBO);
            if (isPrePay.booleanValue()) {
                attachmentBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
                attachmentBO.setDOC_TYPE("8013");
                continue;
            }
            attachmentBO.setEG_BILL_NUM(orderPO.getOrderNo());
            attachmentBO.setDOC_TYPE("8018");
        }
        payBillBO.setDOC_COUNT(Integer.valueOf(attachmentBOList.size()));
    }

    private void buildSettleInfo(FscOrderPO orderPO, FscUnifyPayBillBO payBillBO, List<FscUnifyPaySettleBO> settleBOList) {
        List shouldPayPoList = this.fscShouldPayMapper.getByFscOrderId(orderPO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)shouldPayPoList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<Long> shouldPayIdList = new ArrayList<Long>(shouldPayPoList.size());
        for (FscShouldPayPO fscShouldPayPO : shouldPayPoList) {
            shouldPayIdList.add(fscShouldPayPO.getShouldPayId());
        }
        FscOrderPayDetailPO payDetailPO = new FscOrderPayDetailPO();
        payDetailPO.setFscOrderId(orderPO.getFscOrderId());
        payDetailPO.setShouldPayIdList(shouldPayIdList);
        List payDetailList = this.fscOrderPayDetailMapper.getSpecialOrderPayAmt(payDetailPO);
        HashMap<String, BigDecimal> orderAmtMap = new HashMap<String, BigDecimal>(payDetailList.size());
        ArrayList<Long> settleIdList = new ArrayList<Long>(payDetailList.size());
        ArrayList<Long> orderIdList = new ArrayList<Long>(payDetailList.size());
        for (FscOrderPayDetailPO fscOrderPayDetailPO : payDetailList) {
            orderAmtMap.put(fscOrderPayDetailPO.getOrderId().toString() + "-" + fscOrderPayDetailPO.getSettleId(), fscOrderPayDetailPO.getPayAmount());
            orderIdList.add(fscOrderPayDetailPO.getOrderId());
            settleIdList.add(fscOrderPayDetailPO.getSettleId());
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderIds(settleIdList);
        fscOrderRelationPO.setOrderIds(orderIdList);
        List fscOrderRelationPOS = this.fscOrderRelationMapper.sumSettleAmtByOrder(fscOrderRelationPO);
        FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
        fscOrderPayDetailPO.setSettleIdList(settleIdList);
        fscOrderPayDetailPO.setOrderIdList(orderIdList);
        List orderPayDetailPOS = this.fscOrderPayDetailMapper.getSpecialOrderPaidAmt(fscOrderPayDetailPO);
        HashMap<String, BigDecimal> orderPaidMap = new HashMap<String, BigDecimal>(orderPayDetailPOS.size());
        for (FscOrderPayDetailPO orderPayDetailPO : orderPayDetailPOS) {
            orderPaidMap.put(orderPayDetailPO.getOrderId() + "-" + orderPayDetailPO.getSettleId(), orderPayDetailPO.getPayAmount());
        }
        PebUocUnifyContractQryAbilityRspBO contractQryAbilityRspBO = this.qryOrderContractInfo(orderIdList, orderPO.getBuynerNo());
        payBillBO.setVENDOR_SITE_CODE(contractQryAbilityRspBO.getVendorSiteName());
        for (FscOrderRelationPO orderRelationPO : fscOrderRelationPOS) {
            UocOrdContractBO uocOrdContractBO = (UocOrdContractBO)contractQryAbilityRspBO.getContractMap().get(orderRelationPO.getOrderId());
            if (uocOrdContractBO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BigDecimal orderAmt = (BigDecimal)orderAmtMap.get(orderRelationPO.getOrderId().toString() + "-" + orderRelationPO.getFscOrderId());
            if (orderAmt == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8ba2\u5355\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            BigDecimal paidAmount = (BigDecimal)orderPaidMap.get(orderRelationPO.getOrderId().toString() + "-" + orderRelationPO.getFscOrderId());
            if (paidAmount == null) {
                paidAmount = BigDecimal.ZERO;
            }
            FscUnifyPaySettleBO settleBO = new FscUnifyPaySettleBO();
            settleBO.setBALANCE_AMT(orderRelationPO.getSettleAmt().setScale(2, RoundingMode.HALF_UP));
            settleBO.setPAID_AMOUNT(paidAmount.setScale(2, RoundingMode.HALF_UP));
            settleBO.setORG_ID(payBillBO.getORG_ID());
            settleBO.setORG_NAME(payBillBO.getORG_NAME());
            settleBO.setCONTRACT_NUM(uocOrdContractBO.getContractNo());
            settleBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
            settleBO.setCONTRACT_AMOUNT(uocOrdContractBO.getContractAmt().setScale(2, RoundingMode.HALF_UP));
            settleBO.setAMOUNT(orderAmt.setScale(2, RoundingMode.HALF_UP));
            settleBO.setNO_PAID_AMOUNT(orderRelationPO.getSettleAmt().subtract(paidAmount).setScale(2, RoundingMode.HALF_UP));
            settleBO.setBAL_REAMOUNT(orderRelationPO.getSettleAmt().subtract(paidAmount).setScale(2, RoundingMode.HALF_UP));
            settleBO.setBALANCE_NUM(orderRelationPO.getFscOrderNo());
            settleBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
            settleBO.setPOORDER_IDS(uocOrdContractBO.getErpOrderId());
            settleBO.setPOORDER_NUM(uocOrdContractBO.getSaleVoucherNo());
            settleBOList.add(settleBO);
        }
    }

    private List<FscUnifyPayContractBO> buildContractInfo(Map<Long, UocOrdContractBO> orderMap, List<FscShouldPayPO> shouldPayPoList, FscOrderPO orderPO, FscUnifyPayBillBO payBillBO) {
        ArrayList<FscUnifyPayContractBO> contractBOList = new ArrayList<FscUnifyPayContractBO>(shouldPayPoList.size());
        for (FscShouldPayPO shouldPayPO : shouldPayPoList) {
            UocOrdContractBO uocOrdContractBO = orderMap.get(shouldPayPO.getOrderId());
            if (uocOrdContractBO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff1a" + shouldPayPO.getObjectNo());
            }
            FscUnifyPayContractBO contractBO = new FscUnifyPayContractBO();
            contractBO.setAMOUNT(shouldPayPO.getPayAmount().setScale(2, RoundingMode.HALF_UP));
            contractBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
            contractBO.setCONTRACT_AMT(uocOrdContractBO.getContractAmt().setScale(2, RoundingMode.HALF_UP));
            contractBO.setCONTRACT_NUM(uocOrdContractBO.getContractNo());
            contractBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
            contractBO.setORG_ID(payBillBO.getORG_ID());
            contractBO.setORG_NAME(payBillBO.getORG_NAME());
            contractBO.setTOTAL_PREPAY_AMT(null);
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setOrderId(shouldPayPO.getOrderId());
            BigDecimal paidAmt = this.fscShouldPayMapper.sumPayPaidAmt(fscShouldPayPO);
            contractBO.setTOTAL_PREPAY_AMT(paidAmt.setScale(2, RoundingMode.HALF_UP));
            contractBO.setTOTAL_PAY_AMT(paidAmt.setScale(2, RoundingMode.HALF_UP));
            contractBO.setCOM_CODE(payBillBO.getCOM_CODE());
            contractBOList.add(contractBO);
        }
        return contractBOList;
    }

    private List<FscUnifyPayLineBO> buildPayLine(FscOrderPO orderPO) {
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<FscUnifyPayLineBO> fscUnifyPayLineBOList = new ArrayList<FscUnifyPayLineBO>();
        FscUnifyPayLineBO fscUnifyPayLineBO = new FscUnifyPayLineBO();
        if (FscConstants.FscPaymentMethod.BANK_PAY.equals(orderPO.getPaymentMethod())) {
            fscUnifyPayLineBO.setPAY_MODE("\u76f4\u63a5\u4ed8\u6b3e");
        } else if (FscConstants.FscPaymentMethod.INVOICE_PAY.equals(orderPO.getPaymentMethod())) {
            fscUnifyPayLineBO.setPAY_MODE("\u5e94\u4ed8\u7968\u636e");
        }
        fscUnifyPayLineBO.setORG_NAME(orderExtPO.getUnifyOrgName());
        fscUnifyPayLineBO.setORG_ID(orderExtPO.getUnifyOrgId());
        fscUnifyPayLineBO.setEG_PAYMENT_ID(orderPO.getFscOrderId());
        fscUnifyPayLineBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
        fscUnifyPayLineBO.setUSER_ID(orderExtPO.getExt1());
        fscUnifyPayLineBO.setAMOUNT(orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP));
        fscUnifyPayLineBOList.add(fscUnifyPayLineBO);
        return fscUnifyPayLineBOList;
    }

    private FscUnifyPayBillBO buildPayInfo(FscOrderPO orderPO, Boolean isPrePay) {
        FscOrderExtPO orderExtPO = new FscOrderExtPO();
        orderExtPO.setFscOrderId(orderPO.getFscOrderId());
        orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
        if (orderExtPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (orderExtPO.getUnifyPushStatus() != null && orderExtPO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (StringUtils.isEmpty((Object)orderExtPO.getAgentAccount())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0agentAccount\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(orderExtPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        FscUnifyPayBillBO payBillBO = new FscUnifyPayBillBO();
        payBillBO.setToken(tokenQryAbilityRspBO.getData());
        payBillBO.setCOM_CODE(orderExtPO.getUnifyComCode());
        payBillBO.setPERSON_ID(orderExtPO.getUnifyUserId());
        payBillBO.setPERSON_NAME(orderExtPO.getUnifyUserName());
        payBillBO.setDEPT_ID(orderExtPO.getUnifyDeptId());
        payBillBO.setDEPT_NAME(orderExtPO.getUnifyDeptName());
        payBillBO.setORG_ID(orderExtPO.getUnifyOrgId());
        payBillBO.setORG_NAME(orderExtPO.getUnifyOrgName());
        payBillBO.setVENDOR_NAME(orderPO.getPayeeName());
        payBillBO.setVENDOR_NUM(orderExtPO.getSupplierErpCode());
        payBillBO.setAMOUNT(orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP));
        payBillBO.setDESCRIPTIONS(orderPO.getRemark());
        payBillBO.setSTATUS("N");
        payBillBO.setSTATUS_DIS("\u65b0\u5efa");
        payBillBO.setBUSINESS_NATURE(orderExtPO.getExt2());
        if (orderPO.getSettlePlatform() == 2 && orderPO.getTradeMode() == 2) {
            payBillBO.setSTATUS("Y");
            payBillBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
            payBillBO.setBUSINESS_NATURE(orderExtPO.getExt3());
            payBillBO.setCOLMUN_CODE(orderExtPO.getExt3());
            payBillBO.setCOLMUN_NAME(orderExtPO.getExt4());
        }
        payBillBO.setBANK_NAME(orderPO.getPayeeBankName());
        payBillBO.setBANK_NUM(orderPO.getPayeeBankAccount());
        if (isPrePay.booleanValue()) {
            payBillBO.setEG_PREPAY_TYPE("YFK");
            payBillBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
            payBillBO.setEG_PREPAY_ID(orderPO.getFscOrderId());
        } else {
            payBillBO.setEG_PAYMENT_ID(orderPO.getFscOrderId());
            payBillBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
        }
        payBillBO.setBILL_DATE(DateUtil.dateToStr((Date)orderPO.getCreateTime()));
        if (orderExtPO.getPayDate() != null) {
            payBillBO.setPAY_DATE(DateUtil.dateToStr((Date)orderExtPO.getPayDate()));
        }
        payBillBO.setUSER_ID(orderExtPO.getExt1());
        return payBillBO;
    }

    private List<FscUnifyPayCapitalBO> buildCapitalInfo(FscOrderPO orderPO, Boolean isPrePay) {
        ArrayList<FscUnifyPayCapitalBO> capitalBOList = new ArrayList<FscUnifyPayCapitalBO>();
        if (orderPO.getSettlePlatform() != null && orderPO.getSettlePlatform() == 2 && orderPO.getTradeMode() != null && orderPO.getTradeMode() == 2) {
            List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(orderPO.getFscOrderId());
            for (FscOperateCapitalPlanPO bo : list) {
                FscUnifyPayCapitalBO capitalBO = new FscUnifyPayCapitalBO();
                capitalBO.setEG_CE_LINE_ID(bo.getId());
                capitalBO.setPERIOD_M(bo.getPeriod());
                capitalBO.setCE_ITEM_ID(Long.valueOf(bo.getItemId()));
                capitalBO.setCE_ITEM_NAME(bo.getItemName());
                capitalBO.setAMOUNT(bo.getPlanAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setRE_AMOUNT(bo.getAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setORG_ID(Long.valueOf(bo.getOrgId()));
                capitalBO.setORG_NAME(orderPO.getOrgName());
                if (bo.getContractId() != null) {
                    capitalBO.setCONTRACT_ID(Long.valueOf(bo.getContractId()));
                }
                capitalBO.setEXE_AMOUNT(bo.getUseAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setCE_HEAD_ID(Long.valueOf(2784L));
                capitalBO.setCE_LINE_ID(Long.valueOf(3999L));
                capitalBO.setCE_TAB_TYPE("MANAGE");
                capitalBO.setCONTROL_MODE(bo.getControlMode());
                capitalBOList.add(capitalBO);
                if (isPrePay.booleanValue()) {
                    if (bo.getContractNum() != null) {
                        capitalBO.setEG_CONTRACT_NUM(bo.getContractNum());
                    }
                    capitalBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
                    continue;
                }
                if (bo.getContractNum() != null) {
                    capitalBO.setCONTRACT_NUM(bo.getContractNum());
                }
                capitalBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
            }
        } else {
            List planPoList = this.fscContractCapitalPlanMapper.getListByFscOrderId(orderPO.getFscOrderId());
            for (FscContractCapitalPlanPo fscContractCapitalPlanPo : planPoList) {
                FscUnifyPayCapitalBO capitalBO = new FscUnifyPayCapitalBO();
                capitalBO.setPERIOD_M(fscContractCapitalPlanPo.getPeriod());
                capitalBO.setCE_ITEM_ID(fscContractCapitalPlanPo.getItemId());
                capitalBO.setCE_ITEM_NAME(fscContractCapitalPlanPo.getItemName());
                capitalBO.setAMOUNT(fscContractCapitalPlanPo.getPlanAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setFINISH_AMT(fscContractCapitalPlanPo.getExeAmount().add(fscContractCapitalPlanPo.getOccAmount()).setScale(2, RoundingMode.HALF_UP));
                capitalBO.setRE_AMOUNT(fscContractCapitalPlanPo.getAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setORG_ID(fscContractCapitalPlanPo.getOrgId());
                capitalBO.setORG_NAME(fscContractCapitalPlanPo.getOrgName());
                capitalBO.setCONTRACT_ID(fscContractCapitalPlanPo.getContractId());
                capitalBO.setEXE_AMOUNT(fscContractCapitalPlanPo.getUseAmount().setScale(2, RoundingMode.HALF_UP));
                capitalBO.setCE_HEAD_ID(fscContractCapitalPlanPo.getHeaderId());
                capitalBO.setCE_LINE_ID(fscContractCapitalPlanPo.getLineId());
                capitalBO.setCE_TAB_TYPE(fscContractCapitalPlanPo.getTabType());
                capitalBOList.add(capitalBO);
                if (isPrePay.booleanValue()) {
                    capitalBO.setEG_CONTRACT_NUM(fscContractCapitalPlanPo.getContractNum());
                    capitalBO.setEG_PREPAY_NUM(orderPO.getOrderNo());
                    continue;
                }
                capitalBO.setCONTRACT_NUM(fscContractCapitalPlanPo.getContractNum());
                capitalBO.setEG_PAYMENT_NUM(orderPO.getOrderNo());
            }
        }
        return capitalBOList;
    }

    private void dealFail(Long fscOrderId, String failMsg) {
        FscPushUnifyFailBusiReqBO failBusiReqBO = new FscPushUnifyFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setFscOrderId(fscOrderId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.PAY);
        this.fscPushUnifyFailBusiService.dealPushUnifyFail(failBusiReqBO);
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

