/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceDeptDetailQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDeptDetailQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDeptDetailQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceOrgInfoByDeptIdVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceDeptDetailQryAbilityService"})
public class FscFinanceDeptDetailQryAbilityServiceImpl
implements FscFinanceDeptDetailQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceDeptDetailQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fsFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceDeptDetail"})
    public FscFinanceDeptDetailQryRspBO qryFinanceDeptDetail(@RequestBody FscFinanceDeptDetailQryReqBO reqBo) {
        FscFinanceDeptDetailQryRspBO rspBO = new FscFinanceDeptDetailQryRspBO();
        this.valid(reqBo);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fsFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainUrl), (String)"\u672a\u914d\u7f6e\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u5efa\u8bbe\u9879\u76ee\u63a5\u53e3");
            HashMap header = Maps.newHashMap();
            String token = financeShareTokenRspBO.getToken();
            header.put("Authorization", token);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u8d22\u52a1\u7ec4\u7ec7\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587 url:{} deptId:{} token:{}", new Object[]{this.fscShareFinanceServiceConfiguration.getBa102(), reqBo.getDeptId(), token});
            String json = SSLClient.doGet((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getBa102() + reqBo.getDeptId()), (Map)header);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u8d22\u52a1\u7ec4\u7ec7\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)json);
            FscFinanceOrgInfoByDeptIdVO vo = (FscFinanceOrgInfoByDeptIdVO)JSONObject.parseObject((String)json, FscFinanceOrgInfoByDeptIdVO.class);
            Assert.isTrue((vo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3a\u7a7a");
            Assert.isTrue((vo.getCode() == 0 ? 1 : 0) != 0, (String)vo.getMsg());
            BeanUtil.copyProperties((Object)vo.getData(), (Object)rspBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u8d22\u52a1\u7ec4\u7ec7\u63a5\u53e3\u62a5\u9519\uff1a%s", e.getMessage()));
        }
        return rspBO;
    }

    private void valid(FscFinanceDeptDetailQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getDeptId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d22\u52a1\u5171\u4eab\u90e8\u95e8id[deptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

