/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.busibase.external.impl.esb.FscGetErpCustInfoServiceImpl;
import com.tydic.fsc.common.ability.api.finance.FscFinanceReceiptStatementQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReceiptStatementListBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReceiptStatementQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReceiptStatementQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceReceiptStatementListResultVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceReceiptStatementQryAbilityService"})
public class FscFinanceReceiptStatementQryAbilityServiceImpl
implements FscFinanceReceiptStatementQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetErpCustInfoServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceReceiptStatementListList"})
    public FscFinanceReceiptStatementQryRspBO qryFinanceReceiptStatementListList(@RequestBody FscFinanceReceiptStatementQryReqBO reqBO) {
        FscFinanceReceiptStatementQryRspBO rspBO;
        this.valid(reqBO);
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        log.debug("\u83b7\u53d6Token\u4fe1\u606f\uff1a{}", (Object)financeShareTokenRspBO.getToken());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", financeShareTokenRspBO.getToken());
        String reqString = JSONObject.toJSONString((Object)reqBO);
        JSONObject object = JSONObject.parseObject((String)reqString);
        object.put("currentPage", (Object)reqBO.getPageNo());
        object.put("pageSize", (Object)reqBO.getPageSize());
        object.put("orgId", (Object)reqBO.getOrgIdWeb());
        log.debug("\u83b7\u53d6\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)object.toJSONString());
        log.debug("\u83b7\u53d6\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm103()));
        String respStr = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm103()), (String)object.toJSONString(), headerMap);
        log.debug("\u83b7\u53d6\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("191138", "\u83b7\u53d6\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            rspBO = this.resolveRreRsp(respStr, new BigDecimal(reqBO.getExchangeRate()));
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private void valid(FscFinanceReceiptStatementQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUnitCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u7ec4\u7ec7[unitCode]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrgIdWeb())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u673a\u6784id[orgIdWeb]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDeptCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u90e8\u95e8\u7f16\u53f7[deptCode]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getExchangeRate())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6c47\u7387[exchangeRate]\u4e3a\u7a7a");
        }
    }

    private FscFinanceReceiptStatementQryRspBO resolveRreRsp(String respStr, BigDecimal exchangeRate) {
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u8fd4\u56de\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscFinanceReceiptStatementQryRspBO rspBO = new FscFinanceReceiptStatementQryRspBO();
        JSONObject json = JSONObject.parseObject((String)respStr);
        if (!Objects.equals(json.getString("code"), "0")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u67e5\u8be2\u94f6\u884c\u6d41\u6c34\u5931\u8d25\uff01" + json.getString("msg"));
            return rspBO;
        }
        JSONObject data = json.getJSONObject("data");
        JSONArray records = data.getJSONArray("records");
        List resultVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)records), FscFinanceReceiptStatementListResultVO.class);
        if (CollectionUtils.isEmpty((Collection)resultVOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList detailList = new ArrayList();
        resultVOList.stream().forEach(e -> {
            FscFinanceReceiptStatementListBO listBO = (FscFinanceReceiptStatementListBO)BeanUtil.copyProperties((Object)e, FscFinanceReceiptStatementListBO.class);
            listBO.setAmountUnclaimedLocal(e.getAmountUnclaimed().multiply(exchangeRate));
            listBO.setBankFlowDate(DateUtil.convertDateFormat((String)e.getBankFlowDate()));
            detailList.add(listBO);
        });
        Integer total = data.getInteger("total") % data.getInteger("pageSize") > 0 ? data.getInteger("total") / data.getInteger("pageSize") + 1 : data.getInteger("total") / data.getInteger("pageSize");
        rspBO.setPageNo(data.getInteger("currentPage"));
        rspBO.setTotal(total);
        rspBO.setRecordsTotal(data.getInteger("total"));
        rspBO.setRows(detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.debug("\u89e3\u6790\u94f6\u884c\u6d41\u6c34\u6570\u636e\u96c6\u5408\uff1a{}", detailList);
        return rspBO;
    }
}

