/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseCapitalBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseCapitalReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceReleasePayInfoBusiServiceImpl
implements FscFinanceReleasePayInfoBusiService {
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;

    @Override
    public FscFinanceReleasePayInfoRspBO dealReleasePayInfo(FscFinanceReleasePayInfoReqBO reqBO) {
        FscFinancePayReducePO payReducePO = new FscFinancePayReducePO();
        payReducePO.setFscOrderId(reqBO.getFscOrderId());
        List reduceList = this.fscFinancePayReduceMapper.getList(payReducePO);
        if (!CollectionUtils.isEmpty((Collection)reduceList)) {
            for (FscFinancePayReducePO reducePO : reduceList) {
                reducePO.setReduceAmt(reducePO.getReduceAmt().negate());
            }
            int count = this.fscContractRelationMapper.updateBatchById(reduceList);
            if (count != reduceList.size()) {
                throw new FscBusinessException("0000", "\u56de\u9000\u4ed8\u6b3e\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscFinanceCapitalPlanPO planPO = new FscFinanceCapitalPlanPO();
        planPO.setFscOrderId(reqBO.getFscOrderId());
        List planList = this.fscFinanceCapitalPlanMapper.getList(planPO);
        if (!CollectionUtils.isEmpty((Collection)planList)) {
            this.releasePlan(planList, reqBO);
        }
        FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
        draftInfoPO.setFscOrderId(reqBO.getFscOrderId());
        List draftList = this.fscFinanceDraftInfoMapper.getList(draftInfoPO);
        if (!CollectionUtils.isEmpty((Collection)draftList)) {
            this.releaseDraft(draftList);
        }
        FscFinanceBankStatementPO statementPO = new FscFinanceBankStatementPO();
        statementPO.setFscOrderId(reqBO.getFscOrderId());
        List bankList = this.fscFinanceBankStatementMapper.getList(statementPO);
        if (!CollectionUtils.isEmpty((Collection)bankList)) {
            this.releaseBank(bankList);
        }
        FscFinanceReleasePayInfoRspBO rspBO = new FscFinanceReleasePayInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void releaseBank(List<FscFinanceBankStatementPO> bankList) {
        List extIds = bankList.stream().map(FscFinanceBankStatementPO::getExtId).distinct().collect(Collectors.toList());
        FscFinanceReleaseBankReqBO bankReqBO = new FscFinanceReleaseBankReqBO();
        bankReqBO.setGuids(extIds);
        FscFinanceReleaseRspBO rspBO = this.fscFinanceOccupyOrReleaseBankService.releaseBank(bankReqBO);
    }

    private void releaseDraft(List<FscFinanceDraftInfoPO> draftList) {
        FscFinanceReleaseDraftReqBO draftReqBO;
        HashSet<String> draftIds = new HashSet<String>();
        HashSet<String> recvDraftIds = new HashSet<String>();
        for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
            if (StringUtils.isEmpty((String)draftInfoPO.getExtId())) continue;
            if (FscConstants.FinanceDraftType.DRAFT.equals(draftInfoPO.getDraftType())) {
                draftIds.add(draftInfoPO.getExtId());
                continue;
            }
            recvDraftIds.add(draftInfoPO.getExtId());
        }
        if (!CollectionUtils.isEmpty(draftIds)) {
            draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setGuids(draftIds);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.DRAFT);
            this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
        }
        if (!CollectionUtils.isEmpty(recvDraftIds)) {
            draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setGuids(recvDraftIds);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.RECEIVABLE_DRAFT);
            this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
        }
    }

    private void releasePlan(List<FscFinanceCapitalPlanPO> planList, FscFinanceReleasePayInfoReqBO reqBO) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        String billCode = "";
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            FscAccountChargePO chargePO = new FscAccountChargePO();
            chargePO.setChargeId(reqBO.getFscOrderId());
            chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
            billCode = chargePO.getAdvanceDepositNo();
        } else {
            billCode = orderPO.getOrderNo();
        }
        ArrayList<FscFinanceReleaseCapitalBO> releaseList = new ArrayList<FscFinanceReleaseCapitalBO>(planList.size());
        for (FscFinanceCapitalPlanPO planPO : planList) {
            FscFinanceReleaseCapitalBO capitalBO = new FscFinanceReleaseCapitalBO();
            capitalBO.setBillCode(billCode);
            capitalBO.setBizTypeCode(financePO.getBizTypeCode());
            capitalBO.setGuid(planPO.getCaptialId() + "");
            releaseList.add(capitalBO);
        }
        FscFinanceReleaseCapitalReqBO capitalReqBO = new FscFinanceReleaseCapitalReqBO();
        capitalReqBO.setList(releaseList);
        capitalReqBO.setUnitCode(financePO.getCashUnitCode());
        FscFinanceReleaseRspBO rspBO = this.fscFinanceOccupyOrReleaseCapitalService.releaseCapital(capitalReqBO);
    }
}

