/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultDetailBO;
import com.tydic.fsc.common.busi.api.finance.FscSyncFinanceDealPayResultBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRespBO;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSyncFinanceDealPayResultBusiServiceImpl
implements FscSyncFinanceDealPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncFinanceDealPayResultBusiServiceImpl.class);
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;

    @Override
    @FscDuplicateCommitLimit
    public FscSyncFinanceDealPayResultRspBO dealFinanceDealPayResult(FscSyncFinanceDealPayResultRespBO reqBO) {
        FscSyncFinanceDealPayResultRspBO rspBO = new FscSyncFinanceDealPayResultRspBO();
        log.debug("\u91d1\u878d\u4ea4\u6613\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId(Long.valueOf(reqBO.getPayOrderId()));
        logAbilityReqBO.setObjectNo(reqBO.getPayOrderNo());
        logAbilityReqBO.setType(FscConstants.FscPurchasePushType.PAY_CALLBACK);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setPushData(JSONObject.toJSONString((Object)((Object)reqBO)));
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(logAbilityReqBO);
        log.debug("\u91d1\u878d\u4ea4\u6613\u63a8\u9001\u65e5\u5fd7\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)logAbilityReqBO));
        FscOrderPO queryFscOrderVo = new FscOrderPO();
        queryFscOrderVo.setOrderNo(reqBO.getPayOrderNo());
        queryFscOrderVo.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(queryFscOrderVo);
        FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
        rspBO.setFscOrderId(fscOrderPO.getFscOrderId());
        log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
        if (Objects.isNull(fscOrderPO)) {
            FscAccountChargePO queryFscAccountChargeVo = new FscAccountChargePO();
            queryFscAccountChargeVo.setAdvanceDepositNo(reqBO.getPayOrderNo());
            queryFscAccountChargeVo.setChargeId(Long.valueOf(reqBO.getPayOrderId()));
            fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(queryFscAccountChargeVo);
            rspBO.setFscOrderId(fscAccountChargePO.getChargeId());
            log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            if (Objects.isNull(fscAccountChargePO)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f\u6216\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f!");
            }
        }
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(rspBO.getFscOrderId());
        fscOrderFinancePO.setCurrency(reqBO.getDetailList().get(0).getCurrency());
        fscOrderFinancePO.setExchangeRate(reqBO.getDetailList().get(0).getExchangeRate());
        this.fscOrderFinanceMapper.updateExchangeRate(fscOrderFinancePO);
        log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7684\u8d22\u52a1\u5171\u4eab\u6838\u9500\u8868\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderFinancePO));
        if (!CollectionUtils.isEmpty(reqBO.getPayCertificate())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
            for (String attachmentUrl : reqBO.getPayCertificate()) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
                fscAttachmentPO.setAttachmentUrl(attachmentUrl);
                fscAttachmentPO.setCreateTime(new Date());
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u5b58\u5165\u652f\u4ed8\u51ed\u8bc1\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAttachmentPOList));
        }
        List fscOrderPayItemPOS = new ArrayList();
        List fscAccountChargeDetailPOS = new ArrayList();
        if (!Objects.isNull(fscOrderPO)) {
            FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
            payItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderPayItemPOS = this.fscOrderPayItemMapper.getListByFscOrder(payItemPO);
            if (CollectionUtils.isEmpty(fscOrderPayItemPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        if (!Objects.isNull(fscAccountChargePO)) {
            FscAccountChargeDetailPO accountChargeDetailPO = new FscAccountChargeDetailPO();
            accountChargeDetailPO.setChargeId(fscAccountChargePO.getChargeId());
            fscAccountChargeDetailPOS = this.fscAccountChargeDetailMapper.getListByChargeId(accountChargeDetailPO);
            if (CollectionUtils.isEmpty(fscAccountChargeDetailPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u9884\u4ed8\u6b3e\u5145\u503c\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        FscFinancePayItemPO financePayItemPO = new FscFinancePayItemPO();
        financePayItemPO.setFscOrderId(rspBO.getFscOrderId());
        List fscFinancePayItemPOS = this.fscFinancePayItemMapper.getListByFscOrder(financePayItemPO);
        if (CollectionUtils.isEmpty((Collection)fscFinancePayItemPOS)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
        }
        ArrayList<FscShouldPayPO> fscShouldPaySuccessfulPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscShouldPayPO> fscShouldPayfailPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscFinancePayItemPO> fscFinancePayItemPOList = new ArrayList<FscFinancePayItemPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOList = new ArrayList<FscOrderPayItemPO>();
        ArrayList<FscAccountChargeDetailPO> fscAccountChargeDetailPOList = new ArrayList<FscAccountChargeDetailPO>();
        ArrayList<String> payFailIdList = new ArrayList<String>();
        BigDecimal allPayAmount = BigDecimal.ZERO;
        BigDecimal totalPayingAmount = reqBO.getDetailList().stream().map(FscFinanceDealPayResultDetailBO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (FscFinanceDealPayResultDetailBO detailBO : reqBO.getDetailList()) {
            FscOrderPayItemPO orderPayItemPO;
            if (Objects.equals(detailBO.getPayStatus(), "0")) {
                FscOrderPayItemPO orderPayItemPO2;
                FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
                fsFinancePayItemPO.setOrderPayItemId(Long.valueOf(detailBO.getPayDetailId()));
                fsFinancePayItemPO.setPayAmount(detailBO.getPayAmt());
                fsFinancePayItemPO.setPayAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fsFinancePayItemPO.setPaidFailAmount(detailBO.getPayAmt());
                fsFinancePayItemPO.setPaidFailAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAY_FAIL);
                fscFinancePayItemPOList.add(fsFinancePayItemPO);
                payFailIdList.add(detailBO.getPayDetailId());
                if (!Objects.nonNull(fscOrderPO) || !Objects.nonNull(orderPayItemPO2 = (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(financePayItem -> Objects.equals(financePayItem.getOrderPayItemId(), detailBO.getPayDetailId())).findFirst().orElse(null))) continue;
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(orderPayItemPO2.getShouldPayId());
                fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
                fscShouldPayfailPOList.add(fscShouldPayPO);
                continue;
            }
            FscFinancePayItemPO fscFinancePayItemPO = fscFinancePayItemPOS.stream().filter(item -> Objects.equals(item.getFinancePayItemId(), detailBO.getPayDetailId())).findFirst().orElse(new FscFinancePayItemPO());
            if (Objects.nonNull(fscFinancePayItemPO.getOrderPayItemId()) && Objects.nonNull(fscOrderPO)) {
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
                fscOrderPayItemPO.setPayAmount(detailBO.getPayAmt());
                fscOrderPayItemPO.setPayAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fscOrderPayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                fscOrderPayItemPOList.add(fscOrderPayItemPO);
            }
            if (Objects.nonNull(fscFinancePayItemPO.getOrderPayItemId()) && Objects.nonNull(fscAccountChargePO)) {
                FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
                fscAccountChargeDetailPO.setChargeId(fscFinancePayItemPO.getOrderPayItemId());
                fscAccountChargeDetailPO.setPaidAmount(detailBO.getPayAmt());
                fscAccountChargeDetailPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fscAccountChargeDetailPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                fscAccountChargeDetailPOList.add(fscAccountChargeDetailPO);
            }
            FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
            fsFinancePayItemPO.setOrderPayItemId(Long.valueOf(detailBO.getPayDetailId()));
            fsFinancePayItemPO.setPayAmount(detailBO.getPayAmt());
            fsFinancePayItemPO.setPayAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
            fsFinancePayItemPO.setPaidAmount(detailBO.getPayAmt());
            fsFinancePayItemPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
            fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
            fscFinancePayItemPOList.add(fsFinancePayItemPO);
            allPayAmount = allPayAmount.add(detailBO.getPayAmt());
            if (!Objects.nonNull(fscOrderPO) || !Objects.nonNull(orderPayItemPO = (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(financePayItem -> Objects.equals(financePayItem.getOrderPayItemId(), detailBO.getPayDetailId())).findFirst().orElse(null))) continue;
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(orderPayItemPO.getShouldPayId());
            fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
            fscShouldPaySuccessfulPOList.add(fscShouldPayPO);
        }
        if (Objects.nonNull(fscOrderPO)) {
            fscOrderPO.setPaidAmount(allPayAmount);
            if (allPayAmount.compareTo(totalPayingAmount) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            } else if (allPayAmount.compareTo(totalPayingAmount) < 0 && allPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PART_COMFIR);
            } else if (allPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAY_FAIL);
            }
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7ed3\u7b97\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            if (allPayAmount.compareTo(fscOrderPO.getToPayAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u672a\u4ed8\u91d1\u989d!");
            }
            this.fscOrderMapper.updatePaidAmountAndToPayAmount(fscOrderPO);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            if (!CollectionUtils.isEmpty(fscOrderPayItemPOList)) {
                this.fscOrderPayItemMapper.updatePaidAmountAndPayStatusBatch(fscOrderPayItemPOList);
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscOrderPayItemPOList));
            }
        }
        if (Objects.nonNull(fscAccountChargePO.getChargeId())) {
            fscAccountChargePO.setPaidAmount(allPayAmount);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u9884\u4ed8\u6b3e\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            if (allPayAmount.compareTo(fscAccountChargePO.getChargeAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5145\u503c\u91d1\u989d!");
            }
            this.fscAccountChargeMapper.updatePaidAmount(fscAccountChargePO);
            if (!CollectionUtils.isEmpty(fscAccountChargeDetailPOList)) {
                this.fscAccountChargeDetailMapper.updatePaidAmountAndPayStatusBatch(fscAccountChargeDetailPOList);
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAccountChargeDetailPOList));
            }
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemPOList)) {
            this.fscFinancePayItemMapper.updatePayAmountAndPayStatusBatch(fscFinancePayItemPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscFinancePayItemPOList));
        }
        if (!CollectionUtils.isEmpty(fscShouldPaySuccessfulPOList)) {
            this.fscShouldPayMapper.updateByPaySuccessAndStatus(fscShouldPaySuccessfulPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPaySuccessfulPOList));
        }
        if (!CollectionUtils.isEmpty(fscShouldPayfailPOList)) {
            this.fscShouldPayMapper.updateByPayFailAndStatus(fscShouldPayfailPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u5931\u8d25\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPayfailPOList));
        }
        rspBO.setPayFailIdList(payFailIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

