/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bo.FscForOrderStatisticalClaimBO;
import com.tydic.fsc.bo.FscForOrderStatisticalInvoiceBO;
import com.tydic.fsc.bo.FscForOrderStatisticalPayBO;
import com.tydic.fsc.bo.FscForOrderStatisticalShipBO;
import com.tydic.fsc.common.ability.api.FscDownTaskOperatorAbilityService;
import com.tydic.fsc.common.ability.api.FscEsQryStatisticalListPageAbilityService;
import com.tydic.fsc.common.ability.api.FscForOrderStatisticalExportAbilityService;
import com.tydic.fsc.common.ability.bo.FscDownTaskAddAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsQryStatisticalListPageAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsQryStatisticalListPageAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscForOrderStatisticalExportAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscForOrderStatisticalExportAbilityRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscForOrderStatisticalExportAbilityService"})
public class FscForOrderStatisticalExportAbilityServiceImpl
implements FscForOrderStatisticalExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscForOrderStatisticalExportAbilityServiceImpl.class);
    @Autowired
    private FscEsQryStatisticalListPageAbilityService fscEsQryStatisticalListPageAbilityService;
    @Autowired
    private FscDownTaskOperatorAbilityService fscDownTaskOperatorAbilityService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/xlsx";
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fsc.export.pageSize:1000}")
    private Integer pageSize;

    @PostMapping(value={"exportForOrderStatistical"})
    public FscForOrderStatisticalExportAbilityRspBO exportForOrderStatistical(@RequestBody FscForOrderStatisticalExportAbilityReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscEsQryStatisticalListPageAbilityReqBO abilityReqBO = (FscEsQryStatisticalListPageAbilityReqBO)JSONObject.parseObject((String)reqString, FscEsQryStatisticalListPageAbilityReqBO.class);
        reqBO.setPageNo(Integer.valueOf(1));
        abilityReqBO.setPageSize(this.pageSize);
        FscEsQryStatisticalListPageAbilityRspBO abilityRspBO = this.fscEsQryStatisticalListPageAbilityService.qryEsStatisticalListPage(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u7edf\u8ba1\u62a5\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscDownTaskAddAbilityReqBO taskReqBO = new FscDownTaskAddAbilityReqBO();
        taskReqBO.setTaskId(Long.valueOf(new Date().getTime()));
        taskReqBO.setCreateTime(new Date());
        taskReqBO.setCreateUserId(reqBO.getUserId());
        taskReqBO.setCreateUserName(reqBO.getName());
        taskReqBO.setStatus(Integer.valueOf(0));
        this.fscDownTaskOperatorAbilityService.addOrUpdateDownTask(taskReqBO);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u8ba2\u5355-\u7ed3\u7b97\u7edf\u8ba1\u6570\u636e\u5bfc\u51fa");
        sheet.setDefaultColumnWidth(15);
        boolean sheetIdx = false;
        String[] columnTitles = new String[]{"\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4", "\u8ba2\u5355\u9500\u552e\u91d1\u989d", "\u5230\u8d27\u786e\u8ba4\u65f6\u95f4", "\u5230\u8d27\u786e\u8ba4\u91d1\u989d", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u5165\u5e93\u65f6\u95f4", "\u5165\u5e93\u91d1\u989d", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u91c7\u8d2d\u7ed3\u7b97\u5355\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4", "\u91c7\u8d2d\u7ed3\u7b97-\u5f00\u7968\u91d1\u989d", "\u91c7\u8d2d\u7ed3\u7b97-\u8ba2\u5355\u7ed3\u7b97\u91d1\u989d", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4", "\u9500\u552e\u7ed3\u7b97\u5355\u91d1\u989d", "\u5f00\u7968\u91d1\u989d", "\u8ba2\u5355\u7ed3\u7b97\u91d1\u989d", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u6536\u6b3e\u8ba4\u9886\u65f6\u95f4", "\u6536\u6b3e\u8ba4\u9886\u91d1\u989d", "\u9500\u552e\u8ba2\u5355\u7f16\u53f7", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u65f6\u95f4", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7", "\u4ed8\u6b3e\u91d1\u989d", "\u9884\u6536\u6b3e\u6838\u9500\u91d1\u989d", "\u6838\u9500\u65f6\u95f4", "\u7edf\u8ba1\u622a\u6b62\u65f6\u95f4"};
        HSSFRow hssfRow = sheet.createRow(0);
        for (int i = 0; i < columnTitles.length; ++i) {
            hssfRow.createCell(i).setCellValue(columnTitles[i]);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            int rowIndex = 1;
            Integer pageNo = 1;
            do {
                Object row2;
                abilityReqBO.setPageNo(pageNo);
                abilityReqBO.setPageSize(this.pageSize);
                abilityRspBO = this.fscEsQryStatisticalListPageAbilityService.qryEsStatisticalListPage(abilityReqBO);
                if (!abilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u7edf\u8ba1\u62a5\u8868\u6570\u636e\u5931\u8d25\uff01");
                }
                for (Object row2 : abilityRspBO.getRows()) {
                    for (int i = 0; i < row2.getMergeTotalNum(); ++i) {
                        hssfRow = sheet.createRow(rowIndex);
                        if (i == 0) {
                            hssfRow.createCell(0).setCellValue(row2.getOrderCode());
                            if (row2.getAuditDate() != null) {
                                hssfRow.createCell(1).setCellValue(df.format(row2.getAuditDate()));
                            }
                            hssfRow.createCell(2).setCellValue(row2.getSaleFee().toString());
                            hssfRow.createCell(26).setCellValue(df.format(row2.getAbortTime()));
                            if (row2.getMergeTotalNum() > 1) {
                                for (int j = 0; j < 3; ++j) {
                                    sheet.addMergedRegionUnsafe(new CellRangeAddress(rowIndex, row2.getMergeTotalNum() + rowIndex - 1, j, j));
                                }
                                sheet.addMergedRegionUnsafe(new CellRangeAddress(rowIndex, row2.getMergeTotalNum() + rowIndex - 1, 26, 26));
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)row2.getShipList()) && i < row2.getShipList().size() && row2.getShipList().get(i) != null && ((FscForOrderStatisticalShipBO)row2.getShipList().get(i)).getArriveTime() != null) {
                            hssfRow.createCell(3).setCellValue(df.format(((FscForOrderStatisticalShipBO)row2.getShipList().get(i)).getArriveTime()));
                            hssfRow.createCell(4).setCellValue(((FscForOrderStatisticalShipBO)row2.getShipList().get(i)).getShipMoney().toString());
                        }
                        if (!CollectionUtils.isEmpty((Collection)row2.getInvoiceList()) && i < row2.getInvoiceList().size() && row2.getInvoiceList().get(i) != null) {
                            hssfRow.createCell(5).setCellValue(row2.getOrderCode());
                            hssfRow.createCell(6).setCellValue(df.format(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getInspectionTime()));
                            hssfRow.createCell(7).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getInspectionSaleFee().toString());
                            hssfRow.createCell(8).setCellValue(row2.getOrderCode());
                            if (((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getUpDealTime() != null) {
                                hssfRow.createCell(9).setCellValue(df.format(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getUpDealTime()));
                                hssfRow.createCell(10).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getUpTotalCharge().toString());
                                hssfRow.createCell(11).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getUpOrderAmt().toString());
                            }
                            hssfRow.createCell(12).setCellValue(row2.getOrderCode());
                            if (((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownDealTime() != null) {
                                hssfRow.createCell(13).setCellValue(df.format(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownDealTime()));
                                hssfRow.createCell(14).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownTotalCharge().toString());
                                if (((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownInvoiceAmt() != null) {
                                    hssfRow.createCell(15).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownInvoiceAmt().toString());
                                }
                                hssfRow.createCell(16).setCellValue(((FscForOrderStatisticalInvoiceBO)row2.getInvoiceList().get(i)).getDownOrderAmt().toString());
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)row2.getClaimList()) && i < row2.getClaimList().size()) {
                            hssfRow.createCell(17).setCellValue(row2.getOrderCode());
                            if (((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getClaimDate() != null) {
                                hssfRow.createCell(18).setCellValue(df.format(((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getClaimDate()));
                                hssfRow.createCell(19).setCellValue(((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getClaimAmt().toString());
                            }
                            if (((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getWriteOffDate() != null) {
                                hssfRow.createCell(24).setCellValue(((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getWriteOffAmount().toString());
                                hssfRow.createCell(25).setCellValue(df.format(((FscForOrderStatisticalClaimBO)row2.getClaimList().get(i)).getWriteOffDate()));
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)row2.getPayList()) && i < row2.getPayList().size()) {
                            hssfRow.createCell(20).setCellValue(row2.getOrderCode());
                            hssfRow.createCell(21).setCellValue(df.format(((FscForOrderStatisticalPayBO)row2.getPayList().get(i)).getCreateTime()));
                            hssfRow.createCell(22).setCellValue(((FscForOrderStatisticalPayBO)row2.getPayList().get(i)).getOrderNo());
                            hssfRow.createCell(23).setCellValue(((FscForOrderStatisticalPayBO)row2.getPayList().get(i)).getPaidAmount().toString());
                        }
                        ++rowIndex;
                    }
                    int endRow = rowIndex - 1;
                    if (row2.getMergePayNum() > 1) {
                        if (row2.getMergePayNum() > row2.getMergeTotalNum()) {
                            this.merge(sheet, 20, 24, rowIndex - row2.getMergePayNum() + 1, endRow);
                        } else {
                            this.merge(sheet, 20, 24, rowIndex - row2.getMergePayNum(), endRow);
                        }
                    }
                    if (row2.getMergeClaimNum() > 1) {
                        if (row2.getMergeClaimNum() > row2.getMergeTotalNum()) {
                            this.merge(sheet, 17, 20, rowIndex - row2.getMergeClaimNum() + 1, endRow);
                            this.merge(sheet, 24, 26, rowIndex - row2.getMergeClaimNum() + 1, endRow);
                        } else {
                            this.merge(sheet, 17, 20, rowIndex - row2.getMergeClaimNum(), endRow);
                            this.merge(sheet, 24, 26, rowIndex - row2.getMergeClaimNum(), endRow);
                        }
                    }
                    if (row2.getMergeShipNum() > 1) {
                        if (row2.getMergeShipNum() > row2.getMergeTotalNum()) {
                            this.merge(sheet, 3, 5, rowIndex - row2.getMergeShipNum() + 1, endRow);
                        } else {
                            this.merge(sheet, 3, 5, rowIndex - row2.getMergeShipNum(), endRow);
                        }
                    }
                    if (row2.getMergeInvoiceNum() <= 1) continue;
                    if (row2.getMergeInvoiceNum() > row2.getMergeTotalNum()) {
                        this.merge(sheet, 5, 17, rowIndex - row2.getMergeInvoiceNum() + 1, endRow);
                        continue;
                    }
                    this.merge(sheet, 5, 17, rowIndex - row2.getMergeInvoiceNum(), endRow);
                }
                Integer n = pageNo;
                pageNo = pageNo + 1;
                row2 = pageNo;
            } while (pageNo <= abilityRspBO.getTotal());
        }
        catch (Exception e) {
            if (workbook != null) {
                IOUtils.closeQuietly((Closeable)workbook);
            }
            log.error("\u5904\u7406\u5bfc\u51fa\u6570\u636e\u5931\u8d25\uff01");
            taskReqBO.setStatus(Integer.valueOf(3));
            this.fscDownTaskOperatorAbilityService.addOrUpdateDownTask(taskReqBO);
            e.printStackTrace();
            throw new FscBusinessException("198888", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
        }
        FscForOrderStatisticalExportAbilityRspBO rspBO = new FscForOrderStatisticalExportAbilityRspBO();
        log.debug("\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb-------------------------------------------------");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String fileName = UUID.randomUUID() + ".xlsx";
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String fileUrl = "";
        String path = "";
        String innerFileUrl = null;
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)in);
            out.flush();
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u5730\u5740\uff1a" + path);
        }
        catch (IOException e) {
            try {
                taskReqBO.setStatus(Integer.valueOf(3));
                this.fscDownTaskOperatorAbilityService.addOrUpdateDownTask(taskReqBO);
                throw new FscBusinessException("198888", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                IOUtils.closeQuietly((Closeable)workbook);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
        IOUtils.closeQuietly((Closeable)workbook);
        try {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            log.debug("fileUrl\u5730\u5740\u4e3a\uff1a" + fileUrl);
            log.debug("innerFileUrl\u5730\u5740\u4e3a\uff1a" + innerFileUrl);
            rspBO.setFileUrl(fileUrl);
            rspBO.setInnerFileUrl(innerFileUrl);
            taskReqBO.setStatus(Integer.valueOf(2));
            taskReqBO.setFileUrl(fileUrl);
            this.fscDownTaskOperatorAbilityService.addOrUpdateDownTask(taskReqBO);
        }
        catch (Exception e) {
            taskReqBO.setStatus(Integer.valueOf(3));
            this.fscDownTaskOperatorAbilityService.addOrUpdateDownTask(taskReqBO);
            log.error(e.getMessage());
            throw new FscBusinessException("198888", "\u83b7\u53d6fastdfsDownloadUrl\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void merge(HSSFSheet sheet, int startCol, int endCol, int beginRow, int endRow) {
        if (endRow > beginRow) {
            for (int i = startCol; i < endCol; ++i) {
                sheet.addMergedRegionUnsafe(new CellRangeAddress(beginRow, endRow, i, i));
            }
        }
    }
}

