/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscMemFeeForFscQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMemFeeForFscQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMemFeeForFscQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscMemFeeInvoiceBO;
import com.tydic.fsc.common.ability.bo.FscMemFeeInvoiceDetailBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMemFeeForFscQryAbilityService"})
public class FscMemFeeForFscQryAbilityServiceImpl
implements FscMemFeeForFscQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMemFeeForFscQryAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"qryMemFeeForFsc"})
    public FscMemFeeForFscQryAbilityRspBO qryMemFeeForFsc(@RequestBody FscMemFeeForFscQryAbilityReqBO reqBO) {
        this.validParam(reqBO);
        FscMemFeeForFscQryAbilityRspBO rspBO = new FscMemFeeForFscQryAbilityRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscOrderRelationPOList = this.fscOrderMapper.getMemListByInspectionOrderId(fscOrderPO, page);
        List fscMemFeeInvoiceBOList = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderRelationPOList), FscMemFeeInvoiceBO.class);
        if (!CollectionUtils.isEmpty((Collection)fscMemFeeInvoiceBOList)) {
            List fscOrderIdList = fscMemFeeInvoiceBOList.stream().map(FscMemFeeInvoiceBO::getFscOrderId).collect(Collectors.toList());
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setOrderIds(fscOrderIdList);
            List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            Map<Long, List<FscOrderItemPO>> fscOrderItemListMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderId));
            log.debug("\u4f1a\u5458\u8d39\u4ed8\u6b3e\u5355\u660e\u7ec6map\uff1b{}", (Object)JSON.toJSONString(fscOrderItemListMap));
            for (FscMemFeeInvoiceBO fscMemFeeInvoiceBO : fscMemFeeInvoiceBOList) {
                if (null == fscOrderItemListMap.get(fscMemFeeInvoiceBO.getFscOrderId())) continue;
                List fscMemFeeInvoiceDetailBOList = JSONObject.parseArray((String)JSON.toJSONString(fscOrderItemListMap.get(fscMemFeeInvoiceBO.getFscOrderId())), FscMemFeeInvoiceDetailBO.class);
                fscMemFeeInvoiceBO.setInvoiceDetails(fscMemFeeInvoiceDetailBOList);
            }
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(fscMemFeeInvoiceBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    void validParam(FscMemFeeForFscQryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

