/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderInvoiceBackAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscOrderInvoiceBackBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceBackBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderInvoiceBackAbilityService"})
public class FscOrderInvoiceBackAbilityServiceImpl
implements FscOrderInvoiceBackAbilityService {
    @Autowired
    private FscOrderInvoiceBackBusiService fscOrderInvoiceBackBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"dealOrderInvoiceBack"})
    public FscOrderInvoiceBackAbilityRspBO dealOrderInvoiceBack(@RequestBody FscOrderInvoiceBackAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscOrderInvoiceBackBusiReqBO busiReqBO = (FscOrderInvoiceBackBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscOrderInvoiceBackBusiReqBO.class));
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            busiReqBO.setFscOrderId(fscOrderId);
            FscOrderInvoiceBackBusiRspBO busiRspBO = this.fscOrderInvoiceBackBusiService.dealOrderInvoiceBack(busiReqBO);
            if (busiRspBO.getRespCode().equals("0000")) continue;
            sb.append("[\u7ed3\u7b97\u5355").append(fscOrderId).append("\u56de\u9000\u5931\u8d25:").append(busiRspBO.getRespDesc()).append("]");
        }
        this.sendMq(reqBO);
        FscOrderInvoiceBackAbilityRspBO rspBO = new FscOrderInvoiceBackAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(FscOrderInvoiceBackAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }
}

