/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscComPayLogBo;
import com.tydic.fsc.bo.FscMerchantBO;
import com.tydic.fsc.common.ability.api.FscPayConfChangeAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayConfChangeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayConfChangeAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscPayConfChangeBusiService;
import com.tydic.fsc.common.busi.bo.FscPayConfChangeBusiServiceReqBo;
import com.tydic.fsc.common.busi.bo.FscPayConfChangeBusiServiceRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayConfChangeAbilityService"})
public class FscPayConfChangeAbilityServiceImpl
implements FscPayConfChangeAbilityService {
    @Autowired
    private FscPayConfChangeBusiService fscPayConfChangeBusiService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @PostMapping(value={"dealPayConfChange"})
    public FscPayConfChangeAbilityRspBO dealPayConfChange(@RequestBody FscPayConfChangeAbilityReqBO reqBO) {
        FscPayConfChangeAbilityRspBO rspBO = new FscPayConfChangeAbilityRspBO();
        this.valid(reqBO);
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgCode(reqBO.getOrgCodeWeb());
        fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u4e70\u53d7\u4eba\u8d26\u6237\u4e3a\u7a7a!");
        }
        reqBO.setOrgIdWeb(fscAccountPO.getOrgId());
        Integer beforePayType = FscConstants.PayConfChangeType.TO_CREDIT.equals(reqBO.getChangeType()) ? FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE : FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD;
        Integer afterPayType = FscConstants.PayConfChangeType.TO_ADVANCE.equals(reqBO.getChangeType()) ? FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE : FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD;
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setBusiOrderNo(reqBO.getOrderCode());
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        if (FscConstants.PayConfChangeType.TO_ADVANCE.equals(reqBO.getChangeType())) {
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        } else {
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
        }
        fscPayLogPO = this.fscPayLogMapper.getModelBy(fscPayLogPO);
        if (fscPayLogPO != null) {
            throw new FscBusinessException("191000", "\u8ba2\u5355\u5df2\u5b8c\u6210\u53d8\u66f4!");
        }
        this.validMerchat(reqBO, beforePayType, afterPayType);
        FscPayConfChangeBusiServiceReqBo busiServiceReqBo = (FscPayConfChangeBusiServiceReqBo)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscPayConfChangeBusiServiceReqBo.class));
        FscPayConfChangeBusiServiceRspBo busiServiceRspBo = this.fscPayConfChangeBusiService.dealPayConfChange(busiServiceReqBo);
        rspBO = (FscPayConfChangeAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiServiceRspBo)), FscPayConfChangeAbilityRspBO.class);
        rspBO.setFscMerchantBO(reqBO.getAfterMerchant());
        FscComPayLogBo fscComPayLogBo = new FscComPayLogBo();
        fscComPayLogBo.setAdvancePayType(busiServiceRspBo.getAdvancePayType());
        rspBO.setFscComPayLogBo(fscComPayLogBo);
        return rspBO;
    }

    private void valid(FscPayConfChangeAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getChangeType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b[changeType]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (FscConstants.PayConfChangeType.TO_ADVANCE.equals(reqBO.getChangeType()) && FscConstants.PayConfChangeType.TO_CREDIT.equals(reqBO.getChangeType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b[changeType]\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ea\u5141\u8bb81\uff08\u8d26\u671f\u53d8\u9884\u5b58\uff09\u6216\u80052\uff08\u9884\u5b58\u53d8\u8d26\u671f\uff09!");
        }
        if (reqBO.getOrderType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getOrderType() != 0) {
            throw new FscBusinessException("191000", "\u53ea\u6709\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u624d\u80fd\u53d8\u66f4\u4ed8\u6b3e\u65b9\u5f0f");
        }
        if (reqBO.getOrgCodeWeb() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e70\u53d7\u4eba\u7f16\u53f7[orgCodeWeb]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgCode(reqBO.getOrgCodeWeb());
        fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u4e70\u53d7\u4eba\u8d26\u6237\u4e3a\u7a7a");
        }
        reqBO.setOrgIdWeb(fscAccountPO.getOrgId());
    }

    private void validMerchat(FscPayConfChangeAbilityReqBO reqBO, Integer beforePayType, Integer afterPayType) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setEnable(Integer.valueOf(1));
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (fscMerchantPo != null) {
            reqBO.setBeforeMerchant((FscMerchantBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscMerchantPo), FscMerchantBO.class));
            if (afterPayType.equals(fscMerchantPo.getPayType())) {
                reqBO.setAfterMerchant((FscMerchantBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscMerchantPo), FscMerchantBO.class));
            }
            FscMerchantPO merchantElectricity = new FscMerchantPO();
            merchantElectricity.setPayBusiSceneRangeLike("1");
            merchantElectricity.setParentId(fscMerchantPo.getMerchantId());
            merchantElectricity.setDelFlag(FscConstants.DicDelFlag.NO);
            merchantElectricity.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchantElectricity.setPayObjId(reqBO.getOrgIdWeb());
            merchantElectricity.setEnable(Integer.valueOf(1));
            merchantElectricity = this.fscMerchantMapper.getModelBy(merchantElectricity);
            if (merchantElectricity != null) {
                if (afterPayType.equals(merchantElectricity.getPayType())) {
                    reqBO.setAfterMerchant((FscMerchantBO)JSON.parseObject((String)JSONObject.toJSONString((Object)merchantElectricity), FscMerchantBO.class));
                } else if (beforePayType.equals(merchantElectricity.getPayType())) {
                    reqBO.setBeforeMerchant((FscMerchantBO)JSON.parseObject((String)JSONObject.toJSONString((Object)merchantElectricity), FscMerchantBO.class));
                }
            }
        } else {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u5546\u6237\u914d\u7f6e\u4e3a\u7a7a!");
        }
        if (reqBO.getAfterMerchant() == null) {
            throw new FscBusinessException("191000", "\u5546\u6237\u672a\u914d\u7f6e\u53d8\u66f4\u540e\u7684\u4ed8\u6b3e\u65b9\u5f0f!");
        }
    }
}

