/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushNewYcPayRefundBillAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNewYcPayRefundBillBO;
import com.tydic.fsc.common.ability.bo.FscNewYcPayRefundBillLineBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundResultBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscPushNewYcFailBusiService;
import com.tydic.fsc.common.busi.api.FscPushNewYcPayRefundBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushNewYcFailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayRefundBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayRefundBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcQryErpCodeAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryErpCodeReqBO;
import com.tydic.umc.general.ability.bo.UmcQryErpCodeRspBO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocContractInfoQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryReqBO;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdProContractHeadBO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushNewYcPayRefundBillAbilityService"})
public class FscPushNewYcPayRefundBillAbilityServiceImpl
implements FscPushNewYcPayRefundBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPayRefundBillAbilityServiceImpl.class);
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPushNewYcPayRefundBillBusiService fscPushNewYcPayRefundBillBusiService;
    @Autowired
    private FscPushNewYcFailBusiService fscPushNewYcFailBusiService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private UocContractInfoQryAbilityService uocContractInfoQryAbilityService;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private UmcQryErpCodeAbilityService umcQryErpCodeAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Value(value="${settle.stage:TWO}")
    private String settleStage;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcPayRefundBill"})
    public FscPushNewYcPayRefundBillAbilityRspBO dealPushNewYcPayRefundBill(@RequestBody FscPushNewYcPayRefundBillAbilityReqBO reqBO) {
        if (reqBO.getClaimId() == null && CollectionUtils.isEmpty((Collection)reqBO.getClaimDetailIdList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u8ba4\u9886\u5355id[claimId]\u548c\u9000\u6b3e\u8ba4\u9886\u660e\u7ec6[claimDetailIdList]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        FscPushNewYcPayRefundBillAbilityRspBO rspBO = new FscPushNewYcPayRefundBillAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<FscPushNewYcPayRefundResultBO> resultBOS = new ArrayList<FscPushNewYcPayRefundResultBO>();
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setClaimId(reqBO.getClaimId());
        fscClaimDetailPO.setDetailIdList(reqBO.getClaimDetailIdList());
        fscClaimDetailPO.setNoPushStatus(FscConstants.FscPushStatus.SUCCESS);
        fscClaimDetailPO.setStatus("1");
        List pushDetailList = this.fscClaimDetailMapper.getList(fscClaimDetailPO);
        if (CollectionUtils.isEmpty((Collection)pushDetailList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u8ba4\u9886\u660e\u7ec6\u76f8\u5173\u4fe1\u606f\uff01");
        }
        List<Long> orderIds = pushDetailList.stream().map(FscClaimDetailPO::getOrderId).collect(Collectors.toList());
        Map<Long, UocOrdProContractHeadBO> contractHeadBOMap = this.qryOrderContractInfo(orderIds);
        for (FscClaimDetailPO po : pushDetailList) {
            FscPushNewYcPayRefundBillBusiReqBO pushReqBO;
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(po.getRefundId());
            refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
            if (refundPO == null) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
            }
            UocOrdProContractHeadBO contractHeadBO = contractHeadBOMap.get(po.getOrderId());
            refundPO.setClaimAmt(po.getClaimAmt());
            FscPushNewYcPayRefundBillBusiRspBO pushRspBO = new FscPushNewYcPayRefundBillBusiRspBO();
            FscPushYcAttachmentAbilityReqBO attachmentReqBO = new FscPushYcAttachmentAbilityReqBO();
            attachmentReqBO.setObjId(refundPO.getRefundId());
            attachmentReqBO.setObjNo(refundPO.getRefundNo());
            if (!FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
                try {
                    pushReqBO = this.buildPrePayRefundBillInfo(refundPO, po, contractHeadBO);
                    attachmentReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.PRE_REFUND);
                }
                catch (Exception e) {
                    log.error("\u7ec4\u88c5\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8\u6b3e\u9000\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + e);
                    e.printStackTrace();
                    this.dealFail(refundPO.getRefundId(), e.getMessage());
                    this.sendMq(refundPO.getRefundId());
                    rspBO.setRespCode("198888");
                    rspBO.setRespDesc(e.getMessage());
                    return rspBO;
                }
            } else {
                return rspBO;
            }
            pushRspBO = this.fscPushNewYcPayRefundBillBusiService.dealPushPayRefundBill(pushReqBO);
            attachmentReqBO.setAgentName(refundPO.getAgentUserName());
            attachmentReqBO.setAgentAccount(refundPO.getExt1());
            this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(attachmentReqBO);
            FscPushNewYcPayRefundResultBO refundResultBO = new FscPushNewYcPayRefundResultBO();
            refundResultBO.setClaimDetailId(po.getClaimDetailId());
            refundResultBO.setRespCode(pushRspBO.getRespCode());
            refundResultBO.setRespDesc(pushRspBO.getRespDesc());
            resultBOS.add(refundResultBO);
            this.sendMq(refundPO.getRefundId());
        }
        rspBO.setResultBOList(resultBOS);
        return rspBO;
    }

    private FscPushNewYcPayRefundBillBusiReqBO buildPrePayRefundBillInfo(FscOrderRefundPO refundPO, FscClaimDetailPO fscClaimDetailPO, UocOrdProContractHeadBO contractHeadBO) {
        FscPushNewYcPayRefundBillBusiReqBO pushReqBO = new FscPushNewYcPayRefundBillBusiReqBO();
        FscNewYcPayRefundBillBO head = new FscNewYcPayRefundBillBO();
        ArrayList<FscNewYcPayRefundBillLineBO> conLine = new ArrayList<FscNewYcPayRefundBillLineBO>();
        this.buildPrePayInfo(refundPO, head, conLine, fscClaimDetailPO, contractHeadBO);
        pushReqBO.setFscClaimDetailPO(fscClaimDetailPO);
        pushReqBO.setFscOrderRefundPO(refundPO);
        pushReqBO.setIsPrePay(true);
        pushReqBO.setToken(head.getToken());
        head.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)head);
        jsonObject.put("conLine", conLine);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.info("--------\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u9000\u6b3e\u4fe1\u606f\u660e\u6587\u6253\u5370\uff1a" + JSON.toJSON((Object)jsonArray.toJSONString()));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private void buildPrePayInfo(FscOrderRefundPO refundPO, FscNewYcPayRefundBillBO head, List<FscNewYcPayRefundBillLineBO> conLine, FscClaimDetailPO fscClaimDetailPO, UocOrdProContractHeadBO contractHeadBO) {
        if (StringUtils.isEmpty((Object)refundPO.getExt1())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getExt1());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        head.setToken(tokenQryAbilityRspBO.getData());
        head.setORG_ID(this.operationOrgId);
        head.setORG_NAME(this.operOrgName);
        head.setEG_HCPREPAY_ID(refundPO.getRefundId());
        head.setEG_HCPREPAY_NUM(refundPO.getRefundNo());
        head.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime(), (String)"yyyy-MM-dd"));
        head.setDESCRIPTIONS(refundPO.getRefundNote());
        FscPayShouldRefundPO shouldRefundPO = this.fscPayShouldRefundMapper.queryByRefundId(refundPO.getRefundId());
        if (shouldRefundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5e94\u9000\u5355\u4e3a\u7a7a\uff01");
        }
        head.setEG_PREPAY_ID(shouldRefundPO.getPayOrderId());
        head.setEG_PREPAY_NUM(shouldRefundPO.getPayOrderNo());
        head.setPAY_DATE(DateUtil.dateToStr((Date)fscClaimDetailPO.getClaimDate(), (String)"yyyy-MM-dd"));
        head.setSTATUS("Y");
        head.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        head.setUSER_ID(refundPO.getYcUserId());
        head.setPERSON_ID(refundPO.getYcPersonId());
        head.setPERSON_NAME(refundPO.getYcPersonName());
        head.setDEPT_ID(refundPO.getYcDeptId());
        head.setDEPT_NAME(refundPO.getYcDeptName());
        head.setAMOUNT(refundPO.getClaimAmt().setScale(2, RoundingMode.HALF_UP));
        head.setCASH_POOL_ID(fscClaimDetailPO.getSerialNumberId());
        head.setCASH_POOL_NUM(fscClaimDetailPO.getSerialNumber());
        head.setCASH_POOL_BANK_ID(fscClaimDetailPO.getBankId());
        head.setCASH_POOL_BANK_NAME(fscClaimDetailPO.getAccountBranch());
        head.setCASH_POOL_BANK_NUM(fscClaimDetailPO.getBankAccount());
        head.setCASH_POOL_AMOUNT(fscClaimDetailPO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        dicDictionaryExernalPO.setCode(String.valueOf(refundPO.getOrderSource()));
        dicDictionaryExernalPO.setPCode("BUZ_PROPERTY");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        if (CollectionUtils.isEmpty((Collection)fscDicDictionaryExernalPOList)) {
            throw new FscBusinessException("198888", "\u4e1a\u8d22\u4e1a\u52a1\u6027\u8d28\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        head.setBUZ_PROPERTY_DIS(((FscDicDictionaryExernalPO)fscDicDictionaryExernalPOList.get(0)).getExernalTitle());
        head.setSTAGE(this.settleStage);
        FscNewYcPayRefundBillLineBO fscNewYcPayRefundBillLineBO = new FscNewYcPayRefundBillLineBO();
        fscNewYcPayRefundBillLineBO.setCONTRACT_NUM(contractHeadBO.getEgContractNum());
        fscNewYcPayRefundBillLineBO.setCONTRACT_NAME(contractHeadBO.getContractName());
        fscNewYcPayRefundBillLineBO.setEG_PREPAY_ID(shouldRefundPO.getPayOrderId());
        fscNewYcPayRefundBillLineBO.setEG_PREPAY_NUM(shouldRefundPO.getPayOrderNo());
        fscNewYcPayRefundBillLineBO.setCONTRACT_AMOUNT(contractHeadBO.getContractAmount().setScale(2, RoundingMode.HALF_UP));
        fscNewYcPayRefundBillLineBO.setAMOUNT(refundPO.getClaimAmt().setScale(2, RoundingMode.HALF_UP));
        fscNewYcPayRefundBillLineBO.setORG_ID(this.operationOrgId);
        fscNewYcPayRefundBillLineBO.setORG_NAME(this.operOrgName);
        fscNewYcPayRefundBillLineBO.setUSER_ID(refundPO.getYcUserId());
        conLine.add(fscNewYcPayRefundBillLineBO);
    }

    private FscPushNewYcPayRefundBillBusiReqBO buildSetPayRefundBillInfo(FscOrderRefundPO refundPO, FscClaimDetailPO fscClaimDetailPO, UocOrdProContractHeadBO contractHeadBO, FscPushNewYcPayRefundBillAbilityReqBO reqBO) {
        FscPushNewYcPayRefundBillBusiReqBO pushReqBO = new FscPushNewYcPayRefundBillBusiReqBO();
        FscNewYcPayRefundBillBO head = new FscNewYcPayRefundBillBO();
        this.buildSetPayInfo(refundPO, head, fscClaimDetailPO, contractHeadBO, reqBO);
        pushReqBO.setFscClaimDetailPO(fscClaimDetailPO);
        pushReqBO.setFscOrderRefundPO(refundPO);
        pushReqBO.setIsPrePay(false);
        pushReqBO.setToken(head.getToken());
        head.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)head);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.info("--------\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u9000\u6b3e\u4fe1\u606f\u660e\u6587\u6253\u5370\uff1a" + JSON.toJSON((Object)jsonArray.toJSONString()));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private Map<Long, UocOrdProContractHeadBO> qryOrderContractInfo(List<Long> orderIdList) {
        UocContractInfoQryReqBO uocContractInfoQryReqBO = new UocContractInfoQryReqBO();
        uocContractInfoQryReqBO.setOrderIds(orderIdList);
        UocContractInfoQryRspBO uocContractInfoQryRspBO = this.uocContractInfoQryAbilityService.qryContractInfoByOrderId(uocContractInfoQryReqBO);
        if (!uocContractInfoQryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(uocContractInfoQryRspBO.getRespCode(), uocContractInfoQryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocContractInfoQryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return uocContractInfoQryRspBO.getRows().stream().collect(Collectors.toMap(UocOrdProContractHeadBO::getOrderId, Function.identity()));
    }

    private void buildSetPayInfo(FscOrderRefundPO refundPO, FscNewYcPayRefundBillBO head, FscClaimDetailPO fscClaimDetailPO, UocOrdProContractHeadBO contractHeadBO, FscPushNewYcPayRefundBillAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)refundPO.getExt1())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getExt1());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        head.setToken(tokenQryAbilityRspBO.getData());
        head.setORG_ID(this.operationOrgId);
        head.setORG_NAME(this.operOrgName);
        head.setEG_HCPAYMENT_ID(refundPO.getRefundId());
        head.setEG_HCPAYMENT_NUM(refundPO.getRefundNo());
        head.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime(), (String)"yyyy-MM-dd"));
        head.setDESCRIPTIONS(refundPO.getRefundNote());
        FscPayShouldRefundPO shouldRefundPO = this.fscPayShouldRefundMapper.queryByRefundId(refundPO.getRefundId());
        if (shouldRefundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5e94\u9000\u5355\u4e3a\u7a7a\uff01");
        }
        head.setEG_PAYMENT_ID(shouldRefundPO.getPayOrderId());
        head.setEG_PAYMENT_NUM(shouldRefundPO.getPayOrderNo());
        head.setCONTRACT_NUM(contractHeadBO.getEgContractNum());
        head.setCONTRACT_NAME(contractHeadBO.getContractName());
        UmcQryErpCodeReqBO umcReqBo = (UmcQryErpCodeReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), UmcQryErpCodeReqBO.class);
        umcReqBo.setOrgIdWeb(refundPO.getSupplierId());
        UmcQryErpCodeRspBO umcRspBo = this.umcQryErpCodeAbilityService.qryErpCode(umcReqBo);
        if (!"0000".equals(umcRspBo.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4f9b\u8d27\u65b9erp\u4fe1\u606f\u5931\u8d25\uff1a" + umcRspBo.getRespDesc());
        }
        head.setVENDOR_NUM(umcRspBo.getErpCode());
        head.setVENDOR_NAME(umcRspBo.getErpName());
        head.setSTATUS("Y");
        head.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        head.setUSER_ID(refundPO.getYcUserId());
        head.setPERSON_ID(refundPO.getYcPersonId());
        head.setPERSON_NAME(refundPO.getYcPersonName());
        head.setDEPT_ID(refundPO.getYcDeptId());
        head.setDEPT_NAME(refundPO.getYcDeptName());
        head.setAMOUNT(refundPO.getClaimAmt().negate().setScale(2, RoundingMode.HALF_UP));
        head.setWRITE_TYPE("REFUND");
        head.setWRITE_TYPE_DIS("\u9000\u6b3e\u9000\u7968");
        head.setCASH_POOL_ID(fscClaimDetailPO.getSerialNumberId());
        head.setCASH_POOL_NUM(fscClaimDetailPO.getSerialNumber());
        head.setCASH_POOL_BANK_ID(fscClaimDetailPO.getBankId());
        head.setCASH_POOL_BANK_NAME(fscClaimDetailPO.getAccountBranch());
        head.setCASH_POOL_BANK_NUM(fscClaimDetailPO.getBankAccount());
        head.setCASH_POOL_AMOUNT(fscClaimDetailPO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        head.setSTAGE(this.settleStage);
    }

    private void dealFail(Long fscOrderId, String failMsg) {
        FscPushNewYcFailBusiReqBO failBusiReqBO = new FscPushNewYcFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setFscOrderId(fscOrderId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.PAY);
        this.fscPushNewYcFailBusiService.dealPushNewYcFail(failBusiReqBO);
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncReqBO = new FscComRefundSyncAbilityReqBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        refundIds.add(refundId);
        syncReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(syncReqBO);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcPayRefundBatch"})
    public FscPushNewYcPayRefundBillAbilityRspBO dealPushNewYcPayRefundBatch(@RequestBody FscPushNewYcPayRefundBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getClaimIdList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u8ba4\u9886\u5355id\u96c6\u5408[claimIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long claimId : reqBO.getClaimIdList()) {
            FscPushNewYcPayRefundBillAbilityReqBO billAbilityReqBO = new FscPushNewYcPayRefundBillAbilityReqBO();
            billAbilityReqBO.setClaimId(claimId);
            FscPushNewYcPayRefundBillAbilityRspBO rspBO = this.dealPushNewYcPayRefundBill(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u9000\u6b3e\u8ba4\u9886\u5355[").append(claimId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushNewYcPayRefundBillAbilityRspBO rspBO = new FscPushNewYcPayRefundBillAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return new FscPushNewYcPayRefundBillAbilityRspBO();
    }
}

