/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceDealPayResultAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultRspBO;
import com.tydic.fsc.common.busi.api.finance.FscSyncFinanceDealPayResultBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRespBO;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceDealPayResultAbilityService"})
public class FscFinanceDealPayResultAbilityServiceImpl
implements FscFinanceDealPayResultAbilityService {
    @Autowired
    private FscSyncFinanceDealPayResultBusiService fscSyncFinanceDealPayResultBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @PostMapping(value={"dealFinancePayResult"})
    public FscFinanceDealPayResultRspBO dealFinancePayResult(@RequestBody FscFinanceDealPayResultReqBO reqBO) {
        this.valid(reqBO);
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId(Long.valueOf(reqBO.getPayOrderId()));
        logAbilityReqBO.setObjectNo(reqBO.getPayOrderNo());
        logAbilityReqBO.setType(FscConstants.FscPurchasePushType.PAY_CALLBACK);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setPushData(JSONObject.toJSONString((Object)reqBO));
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(logAbilityReqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscSyncFinanceDealPayResultRespBO resultReqBO = (FscSyncFinanceDealPayResultRespBO)((Object)JSONObject.parseObject((String)reqString, FscSyncFinanceDealPayResultRespBO.class));
        FscSyncFinanceDealPayResultRspBO resultRspBO = this.fscSyncFinanceDealPayResultBusiService.dealFinanceDealPayResult(resultReqBO);
        if (Objects.equals(resultRspBO.getRespCode(), "0000")) {
            this.sendMq(resultRspBO.getFscOrderId());
        }
        String respString = JSONObject.toJSONString((Object)((Object)resultRspBO));
        return (FscFinanceDealPayResultRspBO)JSONObject.parseObject((String)respString, FscFinanceDealPayResultRspBO.class);
    }

    private void valid(FscFinanceDealPayResultReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPayOrderNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u7f16\u53f7[payOrderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayOrderId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u5355id[payOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayTime())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u65f6\u95f4[payTime]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperAccount())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ebf\u7ecf\u529e\u4eba\u8d26\u53f7[operAccount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ecf\u529e\u4eba\u540d\u79f0[operName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f[detailList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscFinanceDealPayResultDetailBO detailBO : reqBO.getDetailList()) {
            if (StringUtils.isEmpty((Object)detailBO.getPayDetailId())) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u884cid[payDetailId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getPayAmt() == null) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d(\u539f\u5e01)[payAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getPayAmtLocal() == null) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d(\u672c\u4f4d\u5e01)[payAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getPayStatus())) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u4ed8\u6b3e\u72b6\u6001[payStatus]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getCurrency())) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u5e01\u79cd\u7f16\u7801[currency]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getCurrencyName())) {
                throw new FscBusinessException("190000", "\u5165\u53c2\u5e01\u79cd\u540d\u79f0[currencyName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getExchangeRate() != null) continue;
            throw new FscBusinessException("190000", "\u5165\u53c2\u6c47\u7387[exchangeRate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

