/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.bo.FscPushFinanceAttachmentBO;
import com.tydic.fsc.bo.FscPushFinancePayCapitalBO;
import com.tydic.fsc.bo.FscPushFinancePayDraftBO;
import com.tydic.fsc.bo.FscPushFinancePayItemBO;
import com.tydic.fsc.bo.FscPushFinancePrePayBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePushChargeAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePushPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiRspBO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePushChargeAbilityService"})
public class FscFinancePushChargeAbilityServiceImpl
implements FscFinancePushChargeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushChargeAbilityServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinancePushPayBillBusiService fscFinancePushPayBillBusiService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;

    @PostMapping(value={"dealPushCharge"})
    public FscFinancePushChargeAbilityRspBO dealPushCharge(@RequestBody FscFinancePushChargeAbilityReqBO reqBO) {
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargePO chargePO = new FscAccountChargePO();
        chargePO.setChargeId(reqBO.getChargeId());
        chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
        if (chargePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5145\u503c\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getChargeId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8d26\u6237\u5145\u503c\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        return this.dealPushPrePay(reqBO, chargePO, financePO);
    }

    private FscFinancePushChargeAbilityRspBO dealPushPrePay(FscFinancePushChargeAbilityReqBO reqBO, FscAccountChargePO chargePO, FscOrderFinancePO financePO) {
        try {
            FscFinancePayItemPO queryVo = new FscFinancePayItemPO();
            queryVo.setFscOrderId(reqBO.getChargeId());
            List payItemList = this.fscFinancePayItemMapper.getList(queryVo);
            FscPushFinancePrePayBO prePayBO = this.buildPrePayInfo(chargePO, financePO);
            List<FscPushFinancePayItemBO> itemList = this.buildPayItemInfo(chargePO, payItemList);
            List<FscPushFinancePayDraftBO> draftList = this.buildDraftInfo(reqBO);
            List<FscPushFinancePayCapitalBO> capitalList = this.buildCaptialInfo(reqBO);
            BigDecimal payLocalAmt = payItemList.stream().map(FscFinancePayItemPO::getPayAmountLocal).reduce(BigDecimal.ZERO, BigDecimal::add);
            prePayBO.setAdvPayLocalAmt(payLocalAmt);
            List<FscPushFinanceAttachmentBO> fileList = this.buildAttachmentInfo(reqBO, financePO);
            prePayBO.setAttachmentNum(Integer.valueOf(fileList.size()));
            JSONObject reqObj = new JSONObject();
            reqObj.put("baseInfoData", (Object)prePayBO);
            reqObj.put("cmRpList", itemList);
            reqObj.put("cmRpBillDetailList", draftList);
            reqObj.put("cmCashPlanList", capitalList);
            reqObj.put("cmAttachmentList", fileList);
            FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
            if (StringUtils.isEmpty((Object)shareToken.getToken())) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
            }
            FscFinancePushPayBillBusiReqBO busiReqBO = new FscFinancePushPayBillBusiReqBO();
            busiReqBO.setFscOrderId(reqBO.getChargeId());
            busiReqBO.setReqData(reqObj);
            busiReqBO.setToken(shareToken.getToken());
            busiReqBO.setOrderNo(chargePO.getAdvanceDepositNo());
            busiReqBO.setShouldPayMethod(FscConstants.PaymentMethod.PRE_PAY);
            FscFinancePushPayBillBusiRspBO busiRspBO = this.fscFinancePushPayBillBusiService.dealPushPayBill(busiReqBO);
            FscFinancePushChargeAbilityRspBO rspBO = new FscFinancePushChargeAbilityRspBO();
            rspBO.setRespCode(busiRspBO.getRespCode());
            rspBO.setRespDesc(busiRspBO.getRespDesc());
            return rspBO;
        }
        catch (Exception e) {
            return this.dealBuildFail(chargePO, e);
        }
    }

    private FscPushFinancePrePayBO buildPrePayInfo(FscAccountChargePO chargePO, FscOrderFinancePO financePO) {
        FscPushFinancePrePayBO payBO = new FscPushFinancePrePayBO();
        payBO.setSrcSys("EB");
        payBO.setSrcBillId(chargePO.getChargeId() + "");
        payBO.setSrcBillCode(chargePO.getAdvanceDepositNo());
        payBO.setCreateUser(financePO.getFinanceUserId());
        payBO.setCreateUserName(financePO.getFinanceUserName());
        payBO.setCreateDate(DateUtil.dateToStrLong((Date)chargePO.getCreateTime()));
        payBO.setDeptCode(financePO.getFinanceDeptId());
        payBO.setDeptName(financePO.getFinanceDeptName());
        payBO.setOrgId(financePO.getFinanceOrgId());
        payBO.setOrgName(financePO.getFinanceOrgName());
        payBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)chargePO.getCreateTime()));
        payBO.setBizDeptCode(financePO.getBizDeptCode());
        payBO.setBizDeptName(financePO.getBizDeptName());
        payBO.setBizTypeCode(financePO.getBizTypeCode());
        payBO.setBizTypeName(financePO.getBizTypeName());
        payBO.setBizItemCode(financePO.getBusinessItemCode());
        payBO.setBizItemName(financePO.getBusinessItemName());
        payBO.setNote(financePO.getNote());
        payBO.setSegmentCode(financePO.getSegmentCode());
        payBO.setSegmentName(financePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(chargePO.getCreateTime());
        payBO.setBillYear(calendar.get(1) + "");
        payBO.setBillTypeCode(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName());
        payBO.setBillTypeName(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription());
        payBO.setSegCompanyCode(financePO.getCompanySegmentCode());
        payBO.setSegCompanyName(financePO.getCompanySegmentName());
        payBO.setSegProjectCode(financePO.getProjectSegmentCode());
        payBO.setSegProjectName(financePO.getProjectSegmentName());
        payBO.setSegContractCode(financePO.getContractSegmentCode());
        payBO.setSegContractName(financePO.getContractSegmentName());
        payBO.setSegProductCode(null);
        payBO.setSegProductName(null);
        payBO.setSegMainSubjectName(null);
        payBO.setSegMainSubjectCode(null);
        payBO.setSegSubSubjectCode(null);
        payBO.setSegSubSubjectName(null);
        payBO.setSegCorrespondentCode(null);
        payBO.setSegCorrespondentName(null);
        payBO.setSegCalcCostCode(null);
        payBO.setSegCalcCostName(null);
        payBO.setSegProduceStageCode(null);
        payBO.setSegProduceStageName(null);
        payBO.setSegBakCode(null);
        payBO.setSegBakName(null);
        Map paymentPhaseMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAYMENT_PHASE");
        payBO.setPayStageCode(financePO.getPaymentPhase());
        payBO.setPayStageName((String)paymentPhaseMap.get(financePO.getPaymentPhase()));
        payBO.setContractName(chargePO.getContractName());
        payBO.setContractCode(chargePO.getContractNo());
        payBO.setSupplierCode(financePO.getExt1());
        payBO.setSupplierName(chargePO.getRecvDeptName());
        payBO.setSupplierAreaCode(financePO.getVendorSiteId() + "");
        payBO.setSupplierAreaName(financePO.getVendorSiteName());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        payBO.setCurrencyCode(financePO.getCurrency());
        payBO.setCurrencyName((String)currencTypeMap.get(financePO.getCurrency()));
        payBO.setRate(financePO.getExchangeRate());
        payBO.setAdvPayAmt(chargePO.getChargeAmount());
        payBO.setAdvPayDate(DateUtil.dateToStrYYYYMMdd((Date)chargePO.getPayTime()));
        payBO.setIsAgent(financePO.getIsAgent() + "");
        payBO.setAgentCompanyCode(financePO.getAgentCompanyCode());
        payBO.setAgentCompanyName(financePO.getAgentCompanyName());
        payBO.setCashUnitCode(financePO.getCashUnitCode());
        payBO.setCashUnitName(financePO.getCashUnitName());
        payBO.setCashItemCode(financePO.getCashItemCode());
        payBO.setCashItemName(financePO.getCashItemName());
        payBO.setCashItemDetailCode(financePO.getCashDetailCode());
        payBO.setCashItemDetailName(financePO.getCashDetailName());
        payBO.setBizAccountant(financePO.getFinanceAuditAccount());
        payBO.setBizAccountantName(financePO.getFinanceAuditName());
        return payBO;
    }

    private List<FscPushFinancePayItemBO> buildPayItemInfo(FscAccountChargePO chargePO, List<FscFinancePayItemPO> poList) {
        ArrayList<FscPushFinancePayItemBO> itemList = new ArrayList<FscPushFinancePayItemBO>(poList.size());
        Map paymethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        for (FscFinancePayItemPO po : poList) {
            FscPushFinancePayItemBO itemBO = new FscPushFinancePayItemBO();
            itemBO.setGuid(po.getFinancePayItemId() + "");
            itemBO.setReceiverAccountCode(po.getRecvBankAccountCode());
            itemBO.setReceiverBankAccountNum(po.getRecvBankAccount());
            itemBO.setReceiverAccountName(po.getRecvBankAccountName());
            itemBO.setReceiverLinkbankCode(po.getRecvBankLinkCode());
            itemBO.setReceiverBankName(po.getRecvBankName());
            itemBO.setReceiverBankCode(po.getRecvBankCode());
            itemBO.setReceiverName(chargePO.getRecvDeptName());
            itemBO.setPayMethodCode(po.getFinancePayMethod());
            itemBO.setPayMethodName((String)paymethodMap.get(po.getFinancePayMethod()));
            itemBO.setPayerAccountCode(po.getPayerAccountCode());
            itemBO.setPayerAccountName(po.getPayerAccountName());
            itemBO.setPayerBankCode(po.getPayerBankCode());
            itemBO.setPayerBankName(po.getPayerBankName());
            itemBO.setPayerLinkbankCode(po.getPayerLinkBankCode());
            itemBO.setPayerBankAccountNum(po.getPayerBankAccountNum());
            itemBO.setPayOriginAmt(po.getPayAmount());
            itemBO.setPayLocalAmt(po.getPayAmountLocal());
            itemBO.setAcceptBillTypeCode(po.getAcceptBillTypeCode());
            itemBO.setAcceptBillTypeName(po.getAcceptBillTypeName());
            itemBO.setAcceptBillOpenCode(po.getAcceptBillOpenCode());
            itemBO.setAcceptBillOpenName(po.getAcceptBillOpenName());
            itemBO.setAcceptBillPledgeCode(null);
            itemBO.setAcceptBillCode(null);
            itemBO.setAcceptBillResidueAmt(null);
            itemBO.setSupplyChainFinancePlatformCode(po.getFinancePlatformCode());
            itemBO.setSupplyChainFinancePlatformName(po.getFinancePlatformName());
            itemBO.setBankNote(po.getBankRemark());
            itemBO.setIsBuyExchange(po.getIsBuyExchange());
            itemBO.setBillFlowGuid(null);
            itemList.add(itemBO);
        }
        return itemList;
    }

    private List<FscPushFinancePayDraftBO> buildDraftInfo(FscFinancePushChargeAbilityReqBO reqBO) {
        FscFinanceDraftInfoPO queryVo = new FscFinanceDraftInfoPO();
        queryVo.setFscOrderId(reqBO.getChargeId());
        List poList = this.fscFinanceDraftInfoMapper.getListWithPay(queryVo);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return null;
        }
        ArrayList<FscPushFinancePayDraftBO> draftList = new ArrayList<FscPushFinancePayDraftBO>();
        for (FscFinanceDraftInfoPO po : poList) {
            FscPushFinancePayDraftBO draftBO = new FscPushFinancePayDraftBO();
            draftBO.setGuid(po.getDraftId() + "");
            draftBO.setCmRpGuid(po.getFinancePayItemId() + "");
            draftBO.setCmRpCode(po.getPayItemNo());
            draftBO.setAcceptBillTypeCode(po.getBillType());
            draftBO.setAcceptBillTypeName(po.getBillTypeName());
            draftBO.setTicketCode(po.getBillNo());
            draftBO.setAcceptBillResidueAmt(po.getRemainingAmount());
            draftBO.setCurrentPayAmt(po.getOccAmt());
            draftBO.setCurrentPayLocalAmt(po.getOccAmtLocal());
            draftBO.setHolderName(po.getHolderName());
            draftBO.setHolderNameCode(po.getHolderNameCode());
            draftBO.setHolderBranchBankName(po.getHolderBranchBankName());
            draftBO.setHolderAccountNo(po.getHolderAccountNo());
            draftBO.setHldrCnapsNo(po.getHolderCnapsNo());
            draftBO.setPlatformCode(po.getFinancePlatformCode());
            draftBO.setPlatformName(po.getFinancePlatformName());
            draftBO.setBizBlAmt(po.getBillAmount());
            draftBO.setBillFlowGuid(po.getGuid());
            draftList.add(draftBO);
        }
        return draftList;
    }

    private List<FscPushFinancePayCapitalBO> buildCaptialInfo(FscFinancePushChargeAbilityReqBO reqBO) {
        FscFinanceCapitalPlanPO queryVo = new FscFinanceCapitalPlanPO();
        queryVo.setFscOrderId(reqBO.getChargeId());
        List poList = this.fscFinanceCapitalPlanMapper.getListWithPay(queryVo);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return null;
        }
        ArrayList<FscPushFinancePayCapitalBO> capitalList = new ArrayList<FscPushFinancePayCapitalBO>(poList.size());
        for (FscFinanceCapitalPlanPO po : poList) {
            FscPushFinancePayCapitalBO capitalBO = new FscPushFinancePayCapitalBO();
            capitalBO.setGuid(po.getCaptialId() + "");
            capitalBO.setDetailGuid(po.getFinancePayItemId() + "");
            capitalBO.setDetailCode(po.getPayItemNo());
            capitalBO.setFundPlanPeriod(po.getPeriod().replace("-", ""));
            capitalBO.setFundBudgetItemCode(po.getFundBudgetItemCode());
            capitalBO.setFundBudgetItemName(po.getFundBudgetItemName());
            capitalBO.setFundPlanItemCode(po.getPlanItemCode());
            capitalBO.setFundPlanItemName(po.getPlanItemName());
            capitalBO.setCapitalPayItemCode(po.getCapitalPayItemCode());
            capitalBO.setCapitalPayItemName(po.getCapitalPayItemName());
            capitalBO.setFundPlanAmt(po.getBalAmount());
            capitalBO.setFundUseAmt(po.getOccAmount());
            capitalBO.setPayMethodCode(po.getPayMethodCode());
            capitalBO.setPayMethodName(po.getPayMethodName());
            capitalList.add(capitalBO);
        }
        return capitalList;
    }

    private FscFinancePushChargeAbilityRspBO dealBuildFail(FscAccountChargePO chargePO, Exception e) {
        log.debug("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u5145\u503c\u5355\u636e\u53c2\u6570\u5f02\u5e38\uff1a{}", (Throwable)e);
        FscFinancePushPayBillBusiReqBO busiReqBO = new FscFinancePushPayBillBusiReqBO();
        busiReqBO.setFscOrderId(chargePO.getChargeId());
        busiReqBO.setOrderNo(chargePO.getAdvanceDepositNo());
        busiReqBO.setFailRemark(e.getMessage());
        this.fscFinancePushPayBillBusiService.updateFailLog(busiReqBO);
        FscFinancePushChargeAbilityRspBO rspBO = new FscFinancePushChargeAbilityRspBO();
        rspBO.setRespCode("198888");
        rspBO.setRespDesc("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u5145\u503c\u5355\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        return rspBO;
    }

    private List<FscPushFinanceAttachmentBO> buildAttachmentInfo(FscFinancePushChargeAbilityReqBO reqBO, FscOrderFinancePO financePO) {
        FscAttachmentPO queryVo = new FscAttachmentPO();
        queryVo.setObjId(reqBO.getChargeId());
        List attachmentPOList = this.fscAttachmentMapper.getList(queryVo);
        if (CollectionUtils.isEmpty((Collection)attachmentPOList)) {
            return new ArrayList<FscPushFinanceAttachmentBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOList), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscPushFinanceAttachmentBO> fileList = new ArrayList<FscPushFinanceAttachmentBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscPushFinanceAttachmentBO pushBo = new FscPushFinanceAttachmentBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(financePO.getFinanceUserName());
            pushBo.setCreateUser(financePO.getFinanceUserId());
            fileList.add(pushBo);
        }
        return fileList;
    }

    @PostMapping(value={"dealPushFinancePayBatch"})
    public FscFinancePushChargeAbilityRspBO dealPushFinancePayBatch(@RequestBody FscFinancePushChargeAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getChargeIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuffer sb = new StringBuffer();
        for (Long chargeId : reqBO.getChargeIds()) {
            FscFinancePushChargeAbilityReqBO abilityReqBO = new FscFinancePushChargeAbilityReqBO();
            abilityReqBO.setChargeId(chargeId);
            FscFinancePushChargeAbilityRspBO abilityRspBO = this.dealPushCharge(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append("\u5355\u636e[").append(chargeId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushChargeAbilityRspBO rspBO = new FscFinancePushChargeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }
}

