/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.common.busi.api.FscFinanceBillStatusUpdateExtBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtReqBo;
import com.tydic.fsc.common.busi.bo.FscFinanceBillStatusUpdateServiceExtRspBo;
import com.tydic.fsc.common.util.DateUtils;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceBillStatusUpdateExtBusiServiceImpl
implements FscFinanceBillStatusUpdateExtBusiService {
    private static final String BUSI_NAME = "\u5171\u4eab\u5355\u636e\u8fc7\u8d26";
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscFinanceBillStatusUpdateServiceExtRspBo dealStatusUpdate(FscFinanceBillStatusUpdateServiceExtReqBo reqBo) {
        List ids = reqBo.getBillIds().stream().map(Long::valueOf).collect(Collectors.toList());
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderIds(ids);
        List list = this.fscOrderFinanceMapper.getList(financePO);
        FscFinanceBillStatusUpdateServiceExtRspBo rspBaseBO = new FscFinanceBillStatusUpdateServiceExtRspBo();
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u6210\u529f");
        if (list.size() != ids.size()) {
            rspBaseBO.setRespCode("190000");
            rspBaseBO.setRespDesc("billIds\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (reqBo.getBillType().equals(2)) {
            FscOrderPO orderPO = new FscOrderPO();
            orderPO.setPostingStatus("1");
            orderPO.setFscOrderIds(ids);
            if (!StringUtils.isEmpty((String)reqBo.getOperTime())) {
                orderPO.setPostingDate(DateUtils.strToDate(reqBo.getOperTime()));
            }
            this.fscOrderMapper.updatePostingStatus(orderPO);
            this.fscOrderFinanceMapper.updatePostingStatus(reqBo.getBillIds(), reqBo.getOperTime());
        } else {
            FscOrderPO set = new FscOrderPO();
            set.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderIds(ids);
            this.fscOrderMapper.updateBy(set, where);
            this.fscOrderFinanceMapper.updatePostingStatus(reqBo.getBillIds(), reqBo.getOperTime());
        }
        return rspBaseBO;
    }
}

