/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscFinanceReleasePayInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceReleasePayInfoBusiServiceImpl
implements FscFinanceReleasePayInfoBusiService {
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscFinanceReleasePayInfoAtomService fscFinanceReleasePayInfoAtomService;

    @Override
    public FscFinanceReleasePayInfoRspBO dealReleasePayInfo(FscFinanceReleasePayInfoReqBO reqBO) {
        FscFinanceCapitalPlanPO planPO = new FscFinanceCapitalPlanPO();
        planPO.setFscOrderId(reqBO.getFscOrderId());
        List planList = this.fscFinanceCapitalPlanMapper.getList(planPO);
        FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
        draftInfoPO.setFscOrderId(reqBO.getFscOrderId());
        List draftList = this.fscFinanceDraftInfoMapper.getList(draftInfoPO);
        HashSet<String> supplyIds = new HashSet<String>();
        HashSet<String> recvDraftIds = new HashSet<String>();
        for (FscFinanceDraftInfoPO draftPO : draftList) {
            if (StringUtils.isEmpty((String)draftPO.getExtId())) continue;
            if (FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftPO.getDraftType())) {
                recvDraftIds.add(draftPO.getExtId());
                continue;
            }
            supplyIds.add(draftPO.getExtId());
        }
        FscFinanceBankStatementPO statementPO = new FscFinanceBankStatementPO();
        statementPO.setFscOrderId(reqBO.getFscOrderId());
        List bankList = this.fscFinanceBankStatementMapper.getList(statementPO);
        List bankExtIds = bankList.stream().map(FscFinanceBankStatementPO::getExtId).distinct().collect(Collectors.toList());
        FscFinanceReleasePayInfoAtomReqBO atomReqBO = new FscFinanceReleasePayInfoAtomReqBO();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            FscAccountChargePO chargePO = new FscAccountChargePO();
            chargePO.setChargeId(reqBO.getFscOrderId());
            chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
            atomReqBO.setObjId(chargePO.getChargeId());
            atomReqBO.setObjNo(chargePO.getAdvanceDepositNo());
        } else {
            atomReqBO.setObjId(orderPO.getFscOrderId());
            atomReqBO.setObjNo(orderPO.getOrderNo());
        }
        atomReqBO.setBankExtIds(new ArrayList());
        atomReqBO.setReleasePlanList(planList);
        atomReqBO.setSupplyExtIds(supplyIds);
        atomReqBO.setDraftExtIds(recvDraftIds);
        atomReqBO.setBankExtIds(bankExtIds);
        FscFinanceReleasePayInfoAtomRspBO atomRspBO = this.fscFinanceReleasePayInfoAtomService.dealReleasePayInfo(atomReqBO);
        FscFinanceReleasePayInfoRspBO rspBO = new FscFinanceReleasePayInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

