/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.FscSyncYcRecvBO;
import com.tydic.fsc.common.ability.bo.FscSyncYcRecvClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscSyncYcRecvClaimDetailBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncYcRecvClaimDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncYcRecvClaimDetailBusiRspBO;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushClaimDetailPo;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSyncYcRecvClaimDetailBusiServiceImpl
implements FscSyncYcRecvClaimDetailBusiService {
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscPushClaimDetailMapper fscPushClaimDetailMapper;

    @Override
    public FscSyncYcRecvClaimDetailBusiRspBO dealYcRecvClaimDetail(FscSyncYcRecvClaimDetailBusiReqBO reqBO) {
        List<Long> fscOrderIds;
        int count;
        this.valid(reqBO);
        FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u8ba4\u9886\u4fe1\u606f\uff01");
        }
        ArrayList<FscClaimDetailPO> addDetailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscClaimDetailPO> updateDetailList = new ArrayList<FscClaimDetailPO>();
        BigDecimal claimAmt = BigDecimal.ZERO;
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_YC_CLAIM_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        String settleNo = "";
        if (!StringUtils.isEmpty((Object)fscRecvClaimPO.getSettleNo())) {
            settleNo = fscRecvClaimPO.getSettleNo();
        }
        StringBuilder sb = new StringBuilder(settleNo);
        ArrayList<String> settleNos = new ArrayList<String>();
        ArrayList<FscSyncYcRecvBO> idList = new ArrayList<FscSyncYcRecvBO>();
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscRecvClaimPO.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        ArrayList<Long> ycDetailIdList = new ArrayList<Long>();
        for (FscSyncYcRecvClaimDetailBO ycDetailBO : reqBO.getClaimList()) {
            String detailNo;
            this.validItem(ycDetailBO);
            FscSyncYcRecvBO detailBO = new FscSyncYcRecvBO();
            FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
            claimDetailPO.setYcClaimDetailId(ycDetailBO.getClaimDetailId());
            claimDetailPO.setClaimAmt(ycDetailBO.getClaimAmt());
            claimDetailPO.setClaimDate(ycDetailBO.getClaimDate());
            claimDetailPO.setNoClaimAmt(ycDetailBO.getNoClaimAmt());
            claimDetailPO.setCancelClaimDate(ycDetailBO.getCancelClaimDate());
            claimDetailPO.setFscOrderId(ycDetailBO.getBillId());
            claimDetailPO.setFscOrderNo(ycDetailBO.getBillNo());
            if (!StringUtils.isEmpty((Object)ycDetailBO.getBillNo())) {
                settleNos.add(ycDetailBO.getBillNo());
            }
            claimDetailPO.setOrderCode(ycDetailBO.getContractNo());
            claimDetailPO.setHandleUserId(ycDetailBO.getHandlerUserId());
            claimDetailPO.setHandleUserName(ycDetailBO.getHandlerUserName());
            claimDetailPO.setHandleDeptId(Long.valueOf(ycDetailBO.getHandlerDeptId()));
            claimDetailPO.setHandleDeptName(ycDetailBO.getHandlerDeptName());
            claimDetailPO.setClaimId(reqBO.getClaimId());
            claimDetailPO.setPushStatus(Integer.valueOf(1));
            claimDetailPO.setSysSource(Integer.valueOf(2));
            claimDetailPO.setClaimType(dicMap.get(ycDetailBO.getClaimType()));
            if (ycDetailBO.getStatus() == 0) {
                claimDetailPO.setStatus("1");
                claimAmt = claimAmt.add(ycDetailBO.getClaimAmt());
                claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                Object[] objectArray = new Object[1];
                serialNumber = serialNumber + 1;
                objectArray[0] = serialNumber;
                detailNo = fscRecvClaimPO.getClaimNo() + "-" + String.format("%02d", objectArray);
                claimDetailPO.setDetailNo(detailNo);
                addDetailList.add(claimDetailPO);
                ycDetailIdList.add(ycDetailBO.getClaimDetailId());
            } else {
                claimDetailPO.setStatus("0");
                if (ycDetailBO.getDetailId() != null) {
                    BigDecimal cancelAmt = this.fscClaimDetailMapper.getClaimAmtByDetailId(ycDetailBO.getDetailId());
                    claimDetailPO.setCancelClaimAmt(cancelAmt);
                    if (cancelAmt == null) {
                        throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230[" + ycDetailBO.getDetailId() + "]\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f\uff01");
                    }
                    claimAmt = claimAmt.subtract(cancelAmt);
                    claimDetailPO.setClaimDetailId(ycDetailBO.getDetailId());
                    claimDetailPO.setClaimAmt(BigDecimal.ZERO);
                    updateDetailList.add(claimDetailPO);
                } else {
                    Object[] objectArray = new Object[1];
                    serialNumber = serialNumber + 1;
                    objectArray[0] = serialNumber;
                    detailNo = fscRecvClaimPO.getClaimNo() + "-" + String.format("%02d", objectArray);
                    claimDetailPO.setDetailNo(detailNo);
                    claimDetailPO.setClaimAmt(BigDecimal.ZERO);
                    claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    addDetailList.add(claimDetailPO);
                }
            }
            detailBO.setBillId(ycDetailBO.getClaimDetailId());
            detailBO.setDetailId(claimDetailPO.getClaimDetailId());
            idList.add(detailBO);
        }
        if (!CollectionUtils.isEmpty(ycDetailIdList) && (count = this.fscClaimDetailMapper.checkYcDetail(ycDetailIdList)) > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u660e\u7ec6\u5df2\u63a8\u9001,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(claimAmt) < 0) {
            throw new FscBusinessException("198888", "\u8ba4\u9886\u5931\u8d25,\u8ba4\u9886\u91d1\u989d[" + claimAmt + "]\u4e0d\u80fd\u5927\u4e8e\u672a\u8ba4\u9886\u91d1\u989d[" + fscRecvClaimPO.getNoClaimAmt() + "]");
        }
        fscRecvClaimPO.setNoClaimAmt(fscRecvClaimPO.getNoClaimAmt().subtract(claimAmt));
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(fscRecvClaimPO.getRecvAmt()) < 0) {
            fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        }
        if (fscRecvClaimPO.getNoClaimAmt().compareTo(fscRecvClaimPO.getRecvAmt()) == 0) {
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
        }
        ArrayList<FscPushClaimDetailPo> pushList = new ArrayList<FscPushClaimDetailPo>();
        if (!CollectionUtils.isEmpty(addDetailList)) {
            this.fscClaimDetailMapper.insertBatch(addDetailList);
            fscOrderIds = addDetailList.stream().filter(e -> "1".equals(e.getStatus())).map(FscClaimDetailPO::getFscOrderId).collect(Collectors.toList());
            pushList.addAll(this.buildPushClaimDetail(addDetailList, fscOrderIds));
        }
        if (!CollectionUtils.isEmpty(updateDetailList)) {
            this.fscClaimDetailMapper.updateBatch(updateDetailList);
            fscOrderIds = updateDetailList.stream().map(FscClaimDetailPO::getFscOrderId).collect(Collectors.toList());
            pushList.addAll(this.buildPushClaimDetail(updateDetailList, fscOrderIds));
        }
        if (!CollectionUtils.isEmpty(pushList)) {
            this.fscPushClaimDetailMapper.updateBatchByFscOrderIds(pushList);
        }
        if (StringUtils.isEmpty((Object)sb.toString()) && !CollectionUtils.isEmpty(settleNos)) {
            fscRecvClaimPO.setSettleNo(String.join((CharSequence)",", settleNos));
        }
        if (!StringUtils.isEmpty((Object)sb.toString()) && !CollectionUtils.isEmpty(settleNos)) {
            sb.append(",").append(String.join((CharSequence)",", settleNos));
            fscRecvClaimPO.setSettleNo(sb.toString());
        }
        this.fscRecvClaimMapper.update(fscRecvClaimPO);
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscRecvClaimPO.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
        FscSyncYcRecvClaimDetailBusiRspBO rspBO = new FscSyncYcRecvClaimDetailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setIdList(idList);
        return rspBO;
    }

    private List<FscPushClaimDetailPo> buildPushClaimDetail(List<FscClaimDetailPO> addDetailList, List<Long> fscOrderIds) {
        if (!CollectionUtils.isEmpty(fscOrderIds)) {
            FscPushClaimDetailPo fscPushClaimDetailPo = new FscPushClaimDetailPo();
            fscPushClaimDetailPo.setFscOrderIds(fscOrderIds);
            fscPushClaimDetailPo.setExtAgainstFlag("1");
            List pushClaimDetailPos = this.fscPushClaimDetailMapper.getList(fscPushClaimDetailPo);
            Map pushClaimDetailPoMap = pushClaimDetailPos.stream().collect(Collectors.toMap(FscPushClaimDetailPo::getFscOrderId, Function.identity(), (e1, e2) -> e1));
            for (FscClaimDetailPO detailPO : addDetailList) {
                if (null == pushClaimDetailPoMap.get(detailPO.getFscOrderId())) continue;
                FscPushClaimDetailPo pushClaimDetailPo = (FscPushClaimDetailPo)pushClaimDetailPoMap.get(detailPO.getFscOrderId());
                if ("1".equals(detailPO.getStatus())) {
                    pushClaimDetailPo.setClaimAmt(pushClaimDetailPo.getClaimAmt().add(null == detailPO.getClaimAmt() ? BigDecimal.ZERO : detailPO.getClaimAmt()));
                    continue;
                }
                pushClaimDetailPo.setClaimAmt(pushClaimDetailPo.getClaimAmt().subtract(null == detailPO.getCancelClaimAmt() ? BigDecimal.ZERO : detailPO.getCancelClaimAmt()));
            }
            return new ArrayList<FscPushClaimDetailPo>(pushClaimDetailPoMap.values());
        }
        return new ArrayList<FscPushClaimDetailPo>();
    }

    private void validItem(FscSyncYcRecvClaimDetailBO detailBO) {
        if (StringUtils.isEmpty((Object)detailBO.getClaimDetailId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimDetailId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getNoClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getStatus())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[status]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getClaimType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerUserId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerUserName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerDeptId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)detailBO.getHandlerDeptName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[handlerDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void valid(FscSyncYcRecvClaimDetailBusiReqBO reqBO) {
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRecvAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[recvAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getNoClaimAmt())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getClaimList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getExernalCode, FscDicDictionaryExernalPO::getCode));
    }
}

