/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscClaimDetailRefundListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimDetailRefundListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimDetailRefundListQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscClaimDetailInfoPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscPayClaimDetailInfoPO;
import com.tydic.umc.general.ability.api.UmcBuyerPermissionRecvAcceptQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryReqBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryRspBO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimDetailRefundListQryAbilityService"})
public class FscClaimDetailRefundListQryAbilityServiceImpl
implements FscClaimDetailRefundListQryAbilityService {
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    private static final String SETTLE_REFUND = "1001";
    private static final String ORDER_REFUND = "1002";
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private UmcBuyerPermissionRecvAcceptQryAbilityService umcBuyerPermissionRecvAcceptQryAbilityService;

    @PostMapping(value={"qryClaimDetailRefundList"})
    public FscClaimDetailRefundListQryAbilityRspBO qryClaimDetailRefundList(@RequestBody FscClaimDetailRefundListQryAbilityReqBO reqBO) {
        BigDecimal totalSum;
        List fscClaimDetailPOList;
        FscClaimDetailRefundListQryAbilityRspBO rspBO = new FscClaimDetailRefundListQryAbilityRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscClaimDetailInfoPO queryVo = (FscClaimDetailInfoPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscClaimDetailInfoPO.class);
        queryVo.setBuyName(reqBO.getCustomerName());
        FscPayClaimDetailInfoPO queryPayVo = (FscPayClaimDetailInfoPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscPayClaimDetailInfoPO.class);
        queryPayVo.setBuyName(reqBO.getCustomerName());
        HashMap<String, BigDecimal> sumFieldInfo = new HashMap<String, BigDecimal>();
        if (!StringUtils.isEmpty((Object)reqBO.getIsprofess()) && reqBO.getIsprofess().equals("0")) {
            queryVo.setPayerId(this.operationOrgId);
            queryPayVo.setPayerId(this.operationOrgId);
        } else if (reqBO.getIsprofess().equals("1")) {
            UmcBuyerPermissionRecvAcceptQryReqBO acceptQryReqBO = new UmcBuyerPermissionRecvAcceptQryReqBO();
            acceptQryReqBO.setErpCode(reqBO.getUserName());
            acceptQryReqBO.setPageSize(Integer.valueOf(100));
            UmcBuyerPermissionRecvAcceptQryRspBO qryRspBO = this.umcBuyerPermissionRecvAcceptQryAbilityService.qry(acceptQryReqBO);
            if (qryRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
                ArrayList<String> buyerNoList = new ArrayList<String>(qryRspBO.getRows().size());
                for (UmcBuyerPermissionRecvAcceptBO umcBuyerPermissionRecvAcceptBO : qryRspBO.getRows()) {
                    buyerNoList.add(String.valueOf(umcBuyerPermissionRecvAcceptBO.getBuyerOrgId()));
                }
                queryVo.setBuyerNoList(buyerNoList);
                queryPayVo.setBuyerNoList(buyerNoList);
            } else {
                rspBO.setPageNo(Integer.valueOf(1));
                rspBO.setTotal(Integer.valueOf(0));
                rspBO.setRecordsTotal(Integer.valueOf(0));
                rspBO.setRows(new ArrayList());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4f4d\u6ca1\u6709\u4e70\u53d7\u4eba\u6743\u9650");
                return rspBO;
            }
        }
        if (SETTLE_REFUND.equals(reqBO.getTabId())) {
            List fscClaimDetailBOS;
            if ("0".equals(reqBO.getIsprofess())) {
                fscClaimDetailPOList = this.fscClaimDetailMapper.getClaimDetailSettleRefundListPage(queryVo, page);
                fscClaimDetailBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)fscClaimDetailPOList), FscClaimDetailBO.class);
                this.parseSettleClaimType(reqBO.getClaimType(), queryVo, null);
                totalSum = this.fscClaimDetailMapper.getSumSettleRefundClaimList(queryVo);
                sumFieldInfo.put("REFUND_LEAVE_AMOUNT", totalSum);
            } else {
                fscClaimDetailPOList = this.fscPayClaimDetailMapper.getClaimDetailSettleRefundListPage(queryPayVo, page);
                fscClaimDetailBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)fscClaimDetailPOList), FscClaimDetailBO.class);
                this.parseSettleClaimType(reqBO.getClaimType(), null, queryPayVo);
                totalSum = this.fscPayClaimDetailMapper.getSumSettleRefundClaimList(queryPayVo);
                sumFieldInfo.put("REFUND_LEAVE_AMOUNT", totalSum);
            }
            Map<Long, FscInvoicePO> invoicePOMap = null;
            if (!CollectionUtils.isEmpty((Collection)fscClaimDetailBOS)) {
                List fscOrderIds = fscClaimDetailBOS.stream().map(FscClaimDetailBO::getFscOrderId).collect(Collectors.toList());
                FscInvoicePO fscInvoicePO = new FscInvoicePO();
                fscInvoicePO.setFscOrderIds(fscOrderIds);
                List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePO);
                if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
                    invoicePOMap = fscInvoicePOS.stream().collect(Collectors.toMap(FscInvoicePO::getFscOrderId, e -> e, (k1, k2) -> k1));
                }
                for (FscClaimDetailBO fscClaimDetail : fscClaimDetailBOS) {
                    this.transformSettleClaimType(fscClaimDetail.getTradeMode(), fscClaimDetail.getOrderSource(), fscClaimDetail.getOrderType(), fscClaimDetail);
                    fscClaimDetail.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)fscClaimDetail.getSysSource()));
                    if (!CollectionUtils.isEmpty(invoicePOMap) && null != invoicePOMap.get(fscClaimDetail.getFscOrderId())) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = null;
                        try {
                            date = simpleDateFormat.parse(invoicePOMap.get(fscClaimDetail.getFscOrderId()).getBillDate());
                        }
                        catch (ParseException e2) {
                            e2.printStackTrace();
                        }
                        fscClaimDetail.setBillTime(date);
                    }
                    fscClaimDetail.setHandleDeptName(reqBO.getOrgName());
                }
            }
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(fscClaimDetailBOS);
            rspBO.setSumFieldInfo(sumFieldInfo);
        } else {
            List fscClaimDetailBOS;
            if ("0".equals(reqBO.getIsprofess())) {
                fscClaimDetailPOList = this.fscClaimDetailMapper.getClaimDetailOrderRefundListPage(queryVo, page);
                fscClaimDetailBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)fscClaimDetailPOList), FscClaimDetailBO.class);
                this.parseAdvanceClaimType(reqBO.getClaimType(), queryVo, null);
                totalSum = this.fscClaimDetailMapper.getSumOrderRefundClaimList(queryVo);
                sumFieldInfo.put("REFUND_LEAVE_AMOUNT", totalSum);
            } else {
                fscClaimDetailPOList = this.fscPayClaimDetailMapper.getClaimDetailOrderRefundListPage(queryPayVo, page);
                fscClaimDetailBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)fscClaimDetailPOList), FscClaimDetailBO.class);
                this.parseAdvanceClaimType(reqBO.getClaimType(), null, queryPayVo);
                totalSum = this.fscPayClaimDetailMapper.getSumOrderRefundClaimList(queryPayVo);
                sumFieldInfo.put("REFUND_LEAVE_AMOUNT", totalSum);
            }
            for (FscClaimDetailBO fscClaimDetailBO : fscClaimDetailBOS) {
                this.transformAdviceClaimType(fscClaimDetailBO.getTradeMode(), fscClaimDetailBO.getOrderType(), fscClaimDetailBO, fscClaimDetailBO.getShouldPayType());
                fscClaimDetailBO.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)fscClaimDetailBO.getSysSource()));
                fscClaimDetailBO.setHandleDeptName(reqBO.getOrgName());
            }
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(fscClaimDetailBOS);
            rspBO.setSumFieldInfo(sumFieldInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void transformSettleClaimType(Integer tradeMode, Integer orderSource, Integer orderType, FscClaimDetailBO fscClaimDetailBo) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getSysSource()) && fscClaimDetailBo.getSysSource() == 2) {
            if (!StringUtils.isEmpty((Object)orderType)) {
                fscClaimDetailBo.setClaimType(orderType.toString());
                fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
            }
        } else if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode());
        } else if (orderType != null && orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode());
        } else if (FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(tradeMode)) {
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode());
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCodeDesc());
        } else if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_AREA.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode());
        } else if (orderSource.equals(FscOrderSourceEnum.ELECTRIC_MARKET.getCode())) {
            fscClaimDetailBo.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCodeDesc());
            fscClaimDetailBo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode());
        }
    }

    private void transformAdviceClaimType(Integer tradeMode, Integer orderType, FscClaimDetailBO fscClaimDetailBO, Integer shouldPayType) {
        if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getSysSource()) && fscClaimDetailBO.getSysSource() == 2 && !StringUtils.isEmpty((Object)orderType)) {
            fscClaimDetailBO.setClaimType(orderType.toString());
            fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)orderType.toString()));
        }
        if (shouldPayType != null && shouldPayType == 14) {
            fscClaimDetailBO.setClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
            fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.MEM_FEE_CLAIM.getCodeDesc());
        }
        if (orderType != null) {
            if (orderType.equals(FscOrderTypeEnum.ELECTRONIC.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.AGREEMENT.getCode()) || orderType.equals(FscOrderTypeEnum.GOODS.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCodeDesc());
                if (FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(tradeMode)) {
                    fscClaimDetailBO.setClaimType(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode());
                    fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCodeDesc());
                }
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUALLY.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCodeDesc());
            } else if (orderType.equals(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode())) {
                fscClaimDetailBO.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
                fscClaimDetailBO.setClaimTypeStr(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCodeDesc());
            }
        }
    }

    private void parseSettleClaimType(String claimType, FscClaimDetailInfoPO queryVo, FscPayClaimDetailInfoPO queryPayVo) {
        Map typeMap;
        if (queryVo != null) {
            typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_SETTLE_TYPE_STATE");
            queryVo.setClaimTypeList(typeMap.keySet());
            if (StringUtils.isEmpty((Object)claimType)) {
                queryVo.setOrderSource(null);
                queryVo.setOrderType(null);
            } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode())) {
                queryVo.setOrderType(FscOrderTypeEnum.INDIVIDUALLY.getCode());
                queryVo.setOrderSource(null);
                queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode()) || claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
                queryVo.setOrderType(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode());
                queryVo.setOrderSource(null);
                queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode())) {
                queryVo.setOrderType(null);
                queryVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
                queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode())) {
                queryVo.setOrderType(null);
                queryVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_AREA.getCode());
                queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode())) {
                queryVo.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
            } else {
                queryVo.setOrderType(Integer.valueOf(-1));
                queryVo.setOrderSource(Integer.valueOf(-1));
            }
        }
        if (queryPayVo != null) {
            typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_SETTLE_TYPE_STATE");
            queryPayVo.setClaimTypeList(typeMap.keySet());
            if (StringUtils.isEmpty((Object)claimType)) {
                queryPayVo.setOrderSource(null);
                queryPayVo.setOrderType(null);
            } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_SETTLE_CLAIM.getCode())) {
                queryPayVo.setOrderType(FscOrderTypeEnum.INDIVIDUALLY.getCode());
                queryPayVo.setOrderSource(null);
                queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode()) || claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
                queryPayVo.setOrderType(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode());
                queryPayVo.setOrderSource(null);
                queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode())) {
                queryPayVo.setOrderType(null);
                queryPayVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
                queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode())) {
                queryPayVo.setOrderType(null);
                queryPayVo.setOrderSource(FscOrderSourceEnum.ELECTRIC_AREA.getCode());
                queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
            } else if (claimType.equals(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode())) {
                queryPayVo.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
            } else {
                queryPayVo.setOrderType(Integer.valueOf(-1));
                queryPayVo.setOrderSource(Integer.valueOf(-1));
            }
        }
    }

    private void parseAdvanceClaimType(String claimType, FscClaimDetailInfoPO queryVo, FscPayClaimDetailInfoPO queryPayVo) {
        Map typeMap;
        if (queryPayVo != null) {
            if (StringUtils.isEmpty((Object)claimType)) {
                typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_PAY_TYPE_STATE");
                queryPayVo.setClaimTypeList(typeMap.keySet());
            } else {
                queryPayVo.setClaimTypeList(Collections.singleton(claimType));
                if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
                    queryPayVo.setOrderType(Integer.valueOf(5));
                    queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode())) {
                    queryPayVo.setOrderType(Integer.valueOf(0));
                    queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode())) {
                    queryPayVo.setOrderType(Integer.valueOf(2));
                    queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode())) {
                    queryPayVo.setOrderType(Integer.valueOf(4));
                    queryPayVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode())) {
                    queryPayVo.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
                }
            }
        }
        if (queryVo != null) {
            if (StringUtils.isEmpty((Object)claimType)) {
                typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_PAY_TYPE_STATE");
                queryVo.setClaimTypeList(typeMap.keySet());
            } else {
                queryVo.setClaimTypeList(Collections.singleton(claimType));
                if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode())) {
                    queryVo.setOrderType(Integer.valueOf(5));
                    queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode())) {
                    queryVo.setOrderType(Integer.valueOf(0));
                    queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode())) {
                    queryVo.setOrderType(Integer.valueOf(2));
                    queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.EMPLOYEE_MINING_PRE_CLAIM.getCode())) {
                    queryVo.setOrderType(Integer.valueOf(4));
                    queryVo.setTradeMode(FscConstants.FscTradeMode.TRADE_MODEL);
                } else if (claimType.equals(FscClaimTypeEnum.FUNCTION_SETTLE_CLAIM.getCode())) {
                    queryVo.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
                }
            }
        }
    }
}

