/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscMerchantConfBatchQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantConfBatchQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantConfBatchQueryAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantConfBatchQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.util.FscRspUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantConfBatchQueryAbilityService"})
public class FscMerchantConfBatchQueryAbilityServiceImpl
implements FscMerchantConfBatchQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantConfBatchQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantConfBatchQueryBusiService fscMerchantConfBatchQueryBusiService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Value(value="${FSC_ACCOUNT_CHECK_ORDER:true}")
    private boolean flag;

    @PostMapping(value={"queryConfBatch"})
    public FscMerchantConfBatchQueryAbilityRspBO queryConfBatch(@RequestBody FscMerchantConfBatchQueryAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u914d\u7f6e\u6279\u91cf\u67e5\u8be2\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscMerchantConfBatchQueryAbilityRspBO retBo = (FscMerchantConfBatchQueryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscMerchantConfBatchQueryAbilityRspBO.class);
        this.validateReqArgs(reqBO);
        FscMerchantConfBatchQueryBusiReqBO busiReqBO = new FscMerchantConfBatchQueryBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscMerchantConfBatchQueryBusiRspBO busiRspBO = this.fscMerchantConfBatchQueryBusiService.queryConfBatch(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)retBo);
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u914d\u7f6e\u6279\u91cf\u67e5\u8be2\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    @PostMapping(value={"queryAccountInfo"})
    public FscMerchantConfBatchQueryAbilityRspBO queryAccountInfo(@RequestBody FscMerchantConfBatchQueryAbilityReqBO reqBO) {
        FscMerchantConfBatchQueryAbilityRspBO rspBO = new FscMerchantConfBatchQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscAccountPO accountPo = new FscAccountPO();
        accountPo.setOrgCode(reqBO.getOrgCode());
        accountPo.setStatus(Integer.valueOf(1));
        accountPo.setAccountCategory(Integer.valueOf(1));
        FscAccountPO modelBy = this.fscAccountMapper.getModelBy(accountPo);
        if (Objects.isNull(modelBy)) {
            return rspBO;
        }
        rspBO.setIsFlag(Boolean.valueOf(true));
        FscMerchantPO fscMerchantPO = new FscMerchantPO();
        fscMerchantPO.setPayObjId(modelBy.getOrgId());
        fscMerchantPO.setDelFlag(Integer.valueOf(0));
        fscMerchantPO.setOrgId(this.operationOrgId);
        fscMerchantPO.setPayBusiSceneRangeLike(reqBO.getPayBusiSceneRange());
        List mergeList = this.fscMerchantMapper.getList(fscMerchantPO);
        if (!CollectionUtils.isEmpty((Collection)mergeList) && mergeList.size() > 0) {
            rspBO.setIsFlagMe(Boolean.valueOf(true));
        }
        if (this.flag) {
            rspBO.setAmount(BigDecimal.ZERO);
            if (modelBy.getRemainAmount().compareTo(BigDecimal.ZERO) < 0) {
                FscPayLogPO payLogPO = new FscPayLogPO();
                payLogPO.setOrgId(modelBy.getOrgId());
                payLogPO.setPayeeId(this.operationOrgId);
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -6);
                payLogPO.setBusiTime(calendar.getTime());
                payLogPO.setAccountId(modelBy.getId());
                BigDecimal overdraftAmount = this.fscPayLogMapper.sumOverdraftAmt(payLogPO);
                BigDecimal subtract = modelBy.getRemainAmount().negate().subtract(overdraftAmount);
                if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                    rspBO.setAmount(subtract);
                } else {
                    rspBO.setAmount(BigDecimal.valueOf(1L));
                }
            } else {
                rspBO.setAmount(BigDecimal.valueOf(1L));
            }
        } else {
            rspBO.setAmount(BigDecimal.valueOf(1L));
        }
        BigDecimal totalAvailableCredit = modelBy.getAdvanceAmount().subtract(modelBy.getFreezeAmount()).subtract(modelBy.getUseAmount()).subtract(modelBy.getDistributeAdvanceAmount());
        if (totalAvailableCredit.compareTo(reqBO.getTotalAmount()) > 0) {
            rspBO.setIsOrder(Boolean.valueOf(true));
        } else if (totalAvailableCredit.add(((FscMerchantPO)mergeList.get(0)).getOverdraft()).compareTo(reqBO.getTotalAmount()) >= 0) {
            rspBO.setIsOrder(Boolean.valueOf(true));
        }
        return rspBO;
    }

    private void validateReqArgs(FscMerchantConfBatchQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getQueryParams())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

