/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscPurchaseAdvanceCheckAbilityService;
import com.tydic.fsc.common.ability.bo.FscPurchaseAdvanceCheckAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPurchaseAdvanceCheckAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.math.BigDecimal;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPurchaseAdvanceCheckAbilityService"})
public class FscPurchaseAdvanceCheckAbilityServiceImpl
implements FscPurchaseAdvanceCheckAbilityService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;

    @PostMapping(value={"checkPurchaseAdvance"})
    public FscPurchaseAdvanceCheckAbilityRspBO checkPurchaseAdvance(@RequestBody FscPurchaseAdvanceCheckAbilityReqBO reqBO) {
        FscPurchaseAdvanceCheckAbilityRspBO rspBO = new FscPurchaseAdvanceCheckAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getPayBusiness())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e1a\u52a1\u573a\u666f[payBusiness]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPurCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801[purCode]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTotalAmt())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0b\u5355\u603b\u91d1\u989d[totalAmt]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscAccountPO fscAccountPo = new FscAccountPO();
        if (reqBO.getPurCode() != null) {
            fscAccountPo.setOrgCode(reqBO.getPurCode().toString());
        }
        FscMerchantPO fscMerchantPO = new FscMerchantPO();
        fscMerchantPO.setOrgId(reqBO.getSupplierId());
        fscMerchantPO.setStatus(FscConstants.MerchantStatus.VALID);
        fscMerchantPO.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPO.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        FscMerchantPO fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPO);
        if (fscMerchantPo == null) {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u5546\u6237\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjCode(reqBO.getPurCode());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        fscAccountPo.setOrgId(reqBO.getPurId());
        fscAccountPo.setBusiType(reqBO.getPayBusiness());
        FscAccountPO fscAccount = this.fscAccountMapper.getModelBy(fscAccountPo);
        if (fscAccount == null) {
            throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f!");
        }
        BigDecimal availableAmount = fscAccount.getAdvanceAmount().subtract(fscAccount.getUseAmount()).subtract(fscAccount.getFreezeAmount()).add(fscMerchantPo.getOverdraft());
        if (availableAmount.compareTo(reqBO.getTotalAmt()) < 0) {
            throw new FscBusinessException("191000", "\u8d26\u6237\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3!");
        }
        rspBO.setAdvanceFlag(true);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

