/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscYcAttachmentBO;
import com.tydic.fsc.common.busi.api.FscPushYcAttachmentBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcAttachmentBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcAttachmentBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscPushNewYcPayRefundQueryPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushYcAttachmentAbilityService"})
public class FscPushYcAttachmentAbilityServiceImpl
implements FscPushYcAttachmentAbilityService {
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Value(value="${fsc.yc.file.bill.source:EBAY2}")
    private String billSource;
    @Autowired
    private FscPushYcAttachmentBusiService fscPushYcAttachmentBusiService;

    @PostMapping(value={"dealPushYcAttachment"})
    public FscPushYcAttachmentAbilityRspBO dealPushYcAttachment(@RequestBody FscPushYcAttachmentAbilityReqBO reqBO) {
        this.valid(reqBO);
        Map typeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_YC_FILE_TYPE");
        String type = (String)typeMap.get(reqBO.getObjType() + "");
        if (StringUtils.isEmpty((Object)type)) {
            throw new FscBusinessException("198888", "\u901a\u8fc7\u5b57\u5178[FSC_YC_FILE_TYPE]\u83b7\u53d6\u65b0\u4e1a\u8d22\u9644\u4ef6\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u5b57\u5178\uff01");
        }
        List<Object> fileList = new ArrayList();
        fileList = reqBO.getObjType().equals(FscConstants.FSC_YC_FILE_TYPE.PUCHASE_CONTRACT_TZ) || reqBO.getObjType().equals(FscConstants.FSC_YC_FILE_TYPE.PUCHASE_CONTRACT_TZ_CHANGE) ? this.dealLedgerFile(reqBO, type) : this.dealFile(reqBO, type);
        if (CollectionUtils.isEmpty(fileList)) {
            FscPushYcAttachmentAbilityRspBO rspBO = new FscPushYcAttachmentAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u9700\u63a8\u9001\u65b0\u4e1a\u8d22\u3002");
            return rspBO;
        }
        FscPushYcAttachmentBusiReqBO busiReqBO = new FscPushYcAttachmentBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        busiReqBO.setFileList(fileList);
        FscPushYcAttachmentBusiRspBO busiRspBO = this.fscPushYcAttachmentBusiService.dealPushYcAttachment(busiReqBO);
        return (FscPushYcAttachmentAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscPushYcAttachmentAbilityRspBO.class);
    }

    private List<FscYcAttachmentBO> dealFile(FscPushYcAttachmentAbilityReqBO reqBO, String type) {
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(reqBO.getObjId());
        ArrayList<FscAttachmentPO> list = this.fscAttachmentMapper.getList(attachmentPO);
        if (FscConstants.FSC_YC_FILE_TYPE.PUR_SETTLE_CHARGE_AGAINST.equals(reqBO.getObjType())) {
            List refundList = this.fscOrderRefundMapper.getPushBOByRefundId(reqBO.getObjId());
            ArrayList<Long> objectIds = new ArrayList<Long>();
            for (FscPushNewYcPayRefundQueryPO fscPushNewYcPayRefundQueryPO : refundList) {
                objectIds.add(Long.valueOf(fscPushNewYcPayRefundQueryPO.getEgBillId()));
            }
            if (!CollectionUtils.isEmpty(objectIds)) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setObjIds(objectIds);
                List attachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
                list.addAll(attachmentPOList);
            }
        }
        if (FscConstants.FSC_YC_FILE_TYPE.SALE_SETTLE_CHARGE_AGAINST.equals(reqBO.getObjType())) {
            list = new ArrayList<FscAttachmentPO>();
            FscAttachmentPO searchAttachmentPO = new FscAttachmentPO();
            searchAttachmentPO.setObjId(reqBO.getObjId());
            searchAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            searchAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
            List attachmentPOS = this.fscAttachmentMapper.getList(searchAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                list.addAll(attachmentPOS);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return this.dealFileUpload(list, reqBO, type);
        }
        return null;
    }

    private List<FscYcAttachmentBO> dealLedgerFile(FscPushYcAttachmentAbilityReqBO reqBO, String type) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileList())) {
            String fileStr = JSONObject.toJSONString((Object)reqBO.getFileList());
            List fscAttachmentPOS = JSONObject.parseArray((String)fileStr, FscAttachmentPO.class);
            return this.dealFileUpload(fscAttachmentPOS, reqBO, type);
        }
        return null;
    }

    private List<FscYcAttachmentBO> dealFileUpload(List<FscAttachmentPO> list, FscPushYcAttachmentAbilityReqBO reqBO, String type) {
        ArrayList<FscYcAttachmentBO> fileList = new ArrayList<FscYcAttachmentBO>();
        for (FscAttachmentPO attachmentPO : list) {
            PebExtUnifyFileUploadAbilityReqBO abilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            abilityReqBO.setFileName(attachmentPO.getAttachmentName());
            abilityReqBO.setFileUrl(attachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(abilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", "\u5904\u7406\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + uploadAbilityRspBO.getRespDesc());
            }
            FscYcAttachmentBO fscYcAttachmentBO = new FscYcAttachmentBO();
            fscYcAttachmentBO.setBILL_SOURCE(this.billSource);
            fscYcAttachmentBO.setDOC_FORMAT(attachmentPO.getAttachmentName().substring(attachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            fscYcAttachmentBO.setDOC_NAME(attachmentPO.getAttachmentName());
            fscYcAttachmentBO.setDOC_TYPE(type);
            fscYcAttachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            fscYcAttachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            fscYcAttachmentBO.setUUID(reqBO.getObjId() + "");
            fscYcAttachmentBO.setUSER_NAME(reqBO.getAgentName());
            fscYcAttachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date()));
            fscYcAttachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date()));
            fileList.add(fscYcAttachmentBO);
        }
        return fileList;
    }

    private void valid(FscPushYcAttachmentAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getAgentName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getObjNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[objNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[objId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[objType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

