/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.busi.api.FscOrderReconciliationBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderReconciliationBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderReconciliationBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDataReconciliationInfoMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscYcClaimDetailReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcClaimReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcFscReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcOrderReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcPayReconciliationInfoMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDataReconciliationInfoPO;
import com.tydic.fsc.po.FscOrderShouldAmountPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscYcClaimDetailReconciliationInfoPO;
import com.tydic.fsc.po.FscYcClaimReconciliationInfoPO;
import com.tydic.fsc.po.FscYcFscReconciliationInfoPO;
import com.tydic.fsc.po.FscYcOrderReconciliationInfoPO;
import com.tydic.fsc.po.FscYcPayReconciliationInfoPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscThreadPoolExecutorConfig;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscOrderReconciliationBusiServiceImpl
implements FscOrderReconciliationBusiService {
    private static final Logger log = LogManager.getLogger(FscOrderReconciliationBusiServiceImpl.class);
    private static final int PAGE_SIZE = 200;
    @Value(value="${saleOrderTabId:130005}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;
    @Autowired
    private FscYcOrderReconciliationInfoMapper fscYcOrderReconciliationInfoMapper;
    @Autowired
    private FscYcFscReconciliationInfoMapper fscYcFscReconciliationInfoMapper;
    @Autowired
    private FscYcPayReconciliationInfoMapper fscYcPayReconciliationInfoMapper;
    @Autowired
    private FscYcClaimReconciliationInfoMapper fscYcClaimReconciliationInfoMapper;
    @Autowired
    private FscYcClaimDetailReconciliationInfoMapper fscYcClaimDetailReconciliationInfoMapper;
    @Autowired
    private FscDataReconciliationInfoMapper fscDataReconciliationInfoMapper;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    private static final ThreadPoolExecutor poolExecutor = FscThreadPoolExecutorConfig.poolExecutor;

    @Override
    public FscOrderReconciliationBusiRspBO reconciliation(FscOrderReconciliationBusiReqBO reqBO) {
        if (reqBO == null || reqBO.getType() == null) {
            throw new FscBusinessException("190000", "\u5bf9\u8d26\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.reconciliationType.ORDER_CON.equals(reqBO.getType())) {
            this.orderReconciliation();
        } else if (FscConstants.reconciliationType.PUR_SETTLE.equals(reqBO.getType()) || FscConstants.reconciliationType.SALE_SETTLE.equals(reqBO.getType())) {
            this.settleReconciliation(reqBO);
        } else if (FscConstants.reconciliationType.PAY_ORDER.equals(reqBO.getType())) {
            this.payReconciliation();
        } else if (FscConstants.reconciliationType.RECV_CLAIM.equals(reqBO.getType())) {
            this.claimReconciliation();
        } else if (FscConstants.reconciliationType.CLAIM_DETAIL.equals(reqBO.getType())) {
            this.detailReconciliation();
        }
        return new FscOrderReconciliationBusiRspBO();
    }

    private void orderReconciliation() {
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(10000);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setInspExecution("2");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsRspBO));
        if (saleDetailsRspBO == null || CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            return;
        }
        ArrayList<FscDataReconciliationInfoPO> infoPOList = new ArrayList<FscDataReconciliationInfoPO>();
        ArrayList<String> orderNos = new ArrayList<String>();
        for (UocPebUpperOrderAbilityBO row : saleDetailsRspBO.getRows()) {
            FscDataReconciliationInfoPO fscDataReconciliationInfoPO = new FscDataReconciliationInfoPO();
            fscDataReconciliationInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscDataReconciliationInfoPO.setObjectId(Long.valueOf(row.getOrderId()));
            fscDataReconciliationInfoPO.setObjectNo(row.getSaleVoucherNo());
            fscDataReconciliationInfoPO.setCreateTime(new Date());
            fscDataReconciliationInfoPO.setType(FscConstants.reconciliationType.ORDER_CON);
            orderNos.add(row.getSaleVoucherNo());
            fscDataReconciliationInfoPO.setSupName(row.getSupName());
            fscDataReconciliationInfoPO.setAccount(row.getFuncAccountName());
            fscDataReconciliationInfoPO.setDept(row.getUnifyDeptId());
            if (CollectionUtils.isNotEmpty((Collection)row.getChildOrderList())) {
                UocPebChildOrderAbilityBO childOrder = (UocPebChildOrderAbilityBO)row.getChildOrderList().get(0);
                fscDataReconciliationInfoPO.setContactNo(childOrder.getContractNo());
                fscDataReconciliationInfoPO.setContactName(childOrder.getContractName());
                fscDataReconciliationInfoPO.setBuynerNo(childOrder.getBuynerName());
                if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().toString().equals(childOrder.getOrderSource())) {
                    fscDataReconciliationInfoPO.setBusiType(Integer.valueOf(1));
                } else if (FscOrderSourceEnum.CONTRACT.getCode().toString().equals(childOrder.getOrderSource())) {
                    fscDataReconciliationInfoPO.setBusiType(Integer.valueOf(2));
                }
            }
            infoPOList.add(fscDataReconciliationInfoPO);
        }
        Map collect = null;
        List infoPOS = this.fscYcOrderReconciliationInfoMapper.selectYCOrderReconciliationInfoByOrderNoList(orderNos);
        if (CollectionUtils.isEmpty((Collection)infoPOS)) {
            collect = infoPOS.stream().collect(Collectors.toMap(FscYcOrderReconciliationInfoPO::getOrderNo, Function.identity()));
        }
        for (FscDataReconciliationInfoPO fscDataReconciliationInfoPO : infoPOList) {
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setPushStatus(Integer.valueOf(0));
            if (collect == null || collect.get(fscDataReconciliationInfoPO.getObjectNo()) == null) continue;
            FscYcOrderReconciliationInfoPO fscYcOrderReconciliationInfoPO = (FscYcOrderReconciliationInfoPO)collect.get(fscDataReconciliationInfoPO.getObjectNo());
            fscDataReconciliationInfoPO.setYcAccount(fscYcOrderReconciliationInfoPO.getAccount());
            fscDataReconciliationInfoPO.setYcDept(fscYcOrderReconciliationInfoPO.getDept());
            if (Objects.nonNull(fscDataReconciliationInfoPO.getAccount()) && Objects.nonNull(fscYcOrderReconciliationInfoPO.getAccount()) && fscDataReconciliationInfoPO.getAccount().equals(fscYcOrderReconciliationInfoPO.getAccount())) {
                fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(1));
            }
            fscDataReconciliationInfoPO.setPushStatus(Integer.valueOf(1));
        }
        this.fscDataReconciliationInfoMapper.deleteByType(FscConstants.reconciliationType.ORDER_CON);
        this.fscDataReconciliationInfoMapper.insertBatch(infoPOList);
    }

    private void settleReconciliation(FscOrderReconciliationBusiReqBO fscOrderReconciliationBusiReqBO) {
        FscComOrderListPageQueryBusiReqBO reqBO = new FscComOrderListPageQueryBusiReqBO();
        reqBO.setPageNo(Integer.valueOf(1));
        reqBO.setPageSize(Integer.valueOf(1));
        reqBO.setOrderFlows(Collections.singletonList(0));
        if (FscConstants.reconciliationType.PUR_SETTLE.equals(fscOrderReconciliationBusiReqBO.getType())) {
            reqBO.setOrderSourceList(Arrays.asList(1, 2, 3));
            reqBO.setOrderState(Integer.valueOf(1003));
            reqBO.setReceiveTypeList(Arrays.asList(2, 3));
            reqBO.setMakeTypeList(Arrays.asList(1, 2));
        } else {
            reqBO.setOrderStates(Arrays.asList(1003, 1002));
            reqBO.setMakeType(Integer.valueOf(3));
        }
        FscComOrderListPageQueryBusiRspBO fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(reqBO);
        log.debug("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868ES\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)fscComOrderListPageQueryBusiRspBO));
        if (fscComOrderListPageQueryBusiRspBO == null || CollectionUtils.isEmpty((Collection)fscComOrderListPageQueryBusiRspBO.getRows())) {
            return;
        }
        this.fscDataReconciliationInfoMapper.deleteByType(fscOrderReconciliationBusiReqBO.getType());
        Integer total = fscComOrderListPageQueryBusiRspBO.getTotal();
        long totalPage = total % 200 == 0 ? (long)(total / 200) : (long)(total / 200 + 1);
        reqBO.setPageSize(Integer.valueOf(200));
        int page = 1;
        while ((long)page <= totalPage) {
            reqBO.setPageNo(Integer.valueOf(page));
            FscComOrderListPageQueryBusiRspBO finalFscComOrderListPageQueryBusiRspBO = fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(reqBO);
            CompletableFuture.runAsync(() -> this.settleReconciliationOne(fscOrderReconciliationBusiReqBO.getType(), finalFscComOrderListPageQueryBusiRspBO), poolExecutor);
            ++page;
        }
    }

    private void settleReconciliationOne(int type, FscComOrderListPageQueryBusiRspBO rspBO) {
        Map collect;
        List writeAmountByFscOrderIdList;
        ArrayList<FscDataReconciliationInfoPO> infoPOList = new ArrayList<FscDataReconciliationInfoPO>();
        ArrayList<Long> fscOrderIdList = new ArrayList<Long>();
        Map<Long, BigDecimal> fscOrderIdAndWriteAmount = null;
        if (type == 2 && !CollectionUtils.isEmpty((Collection)(writeAmountByFscOrderIdList = this.fscOrderShouldAmountMapper.getWriteAmountByFscOrderIdList((List)((Object)(collect = rspBO.getRows().stream().map(FscComOrderListBO::getFscOrderId).collect(Collectors.toList()))))))) {
            fscOrderIdAndWriteAmount = writeAmountByFscOrderIdList.stream().collect(Collectors.toMap(FscOrderShouldAmountPO::getFscOrderId, FscOrderShouldAmountPO::getWriteOffAmount));
        }
        for (FscComOrderListBO row : rspBO.getRows()) {
            FscDataReconciliationInfoPO fscDataReconciliationInfoPO = new FscDataReconciliationInfoPO();
            fscDataReconciliationInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscDataReconciliationInfoPO.setObjectId(row.getFscOrderId());
            fscDataReconciliationInfoPO.setObjectNo(row.getFscOrderNo());
            fscDataReconciliationInfoPO.setCreateTime(new Date());
            fscDataReconciliationInfoPO.setType(Integer.valueOf(type));
            fscDataReconciliationInfoPO.setOrderNo(row.getOrderCodeStr());
            fscDataReconciliationInfoPO.setInvoiceAmt(row.getTotalChargeBill() == null ? "0" : row.getTotalChargeBill().toString());
            fscDataReconciliationInfoPO.setTotalCharge(row.getTotalCharge() == null ? "0" : row.getTotalCharge().toString());
            if (type == 3) {
                fscDataReconciliationInfoPO.setWriteOffAmount(row.getWriteOffAmount().toString());
            } else {
                fscDataReconciliationInfoPO.setWriteOffAmount("0");
                if (fscOrderIdAndWriteAmount != null && fscOrderIdAndWriteAmount.get(fscDataReconciliationInfoPO.getObjectId()) != null) {
                    fscDataReconciliationInfoPO.setWriteOffAmount(fscOrderIdAndWriteAmount.get(fscDataReconciliationInfoPO.getObjectId()).toString());
                }
            }
            fscDataReconciliationInfoPO.setOrderState(row.getOrderState());
            fscDataReconciliationInfoPO.setPostingStatus(Integer.valueOf(row.getPostingStatus()));
            fscDataReconciliationInfoPO.setPostingDate(row.getPostingDate());
            fscOrderIdList.add(row.getFscOrderId());
            infoPOList.add(fscDataReconciliationInfoPO);
        }
        collect = null;
        List infoPOS = this.fscYcFscReconciliationInfoMapper.selectByFscOrderId(fscOrderIdList);
        if (CollectionUtils.isEmpty((Collection)infoPOS)) {
            collect = infoPOS.stream().collect(Collectors.toMap(FscYcFscReconciliationInfoPO::getFscOrderId, Function.identity()));
        }
        for (FscDataReconciliationInfoPO fscDataReconciliationInfoPO : infoPOList) {
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult1(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult2(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult3(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult4(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult5(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult6(Integer.valueOf(0));
            if (collect == null || collect.get(fscDataReconciliationInfoPO.getObjectId()) == null) continue;
            FscYcFscReconciliationInfoPO fscYcOrderReconciliationInfoPO = (FscYcFscReconciliationInfoPO)collect.get(fscDataReconciliationInfoPO.getObjectId());
            fscDataReconciliationInfoPO.setYcPostingStatus(fscYcOrderReconciliationInfoPO.getPostingStatus());
            fscDataReconciliationInfoPO.setYcPostingDate(fscYcOrderReconciliationInfoPO.getPostingDate());
            fscDataReconciliationInfoPO.setYcVoucher(fscYcOrderReconciliationInfoPO.getVoucher());
            fscDataReconciliationInfoPO.setYcTotalCharge(fscYcOrderReconciliationInfoPO.getTotalCharge() == null ? "0" : fscYcOrderReconciliationInfoPO.getTotalCharge());
            fscDataReconciliationInfoPO.setYcWriteOffAmount(fscYcOrderReconciliationInfoPO.getWriteOffAmount() == null ? "0" : fscYcOrderReconciliationInfoPO.getWriteOffAmount());
            fscDataReconciliationInfoPO.setErpTotalCharge(fscYcOrderReconciliationInfoPO.getErpTotalCharge() == null ? "0" : fscYcOrderReconciliationInfoPO.getErpTotalCharge());
            fscDataReconciliationInfoPO.setErpWriteOffAmount(fscYcOrderReconciliationInfoPO.getErpWriteOffAmount() == null ? "0" : fscYcOrderReconciliationInfoPO.getErpWriteOffAmount());
            if (fscDataReconciliationInfoPO.getPostingStatus() != null && Objects.nonNull(fscDataReconciliationInfoPO.getYcPostingStatus()) && (fscDataReconciliationInfoPO.getPostingStatus() + "").equals(fscDataReconciliationInfoPO.getYcPostingStatus())) {
                fscDataReconciliationInfoPO.setResult1(Integer.valueOf(1));
            }
            if (Objects.nonNull(fscDataReconciliationInfoPO.getPostingDate()) && Objects.nonNull(fscDataReconciliationInfoPO.getYcPostingDate()) && DateUtil.dateToStr((Date)fscDataReconciliationInfoPO.getPostingDate()).substring(10).equals(fscDataReconciliationInfoPO.getYcPostingDate().substring(10))) {
                fscDataReconciliationInfoPO.setResult2(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().compareTo(fscDataReconciliationInfoPO.getYcTotalCharge()) == 0) {
                fscDataReconciliationInfoPO.setResult3(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getWriteOffAmount().compareTo(fscDataReconciliationInfoPO.getYcWriteOffAmount()) == 0) {
                fscDataReconciliationInfoPO.setResult4(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().equals(fscDataReconciliationInfoPO.getErpTotalCharge())) {
                fscDataReconciliationInfoPO.setResult5(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getWriteOffAmount().equals(fscDataReconciliationInfoPO.getErpWriteOffAmount())) {
                fscDataReconciliationInfoPO.setResult6(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getResult1() == 1 && fscDataReconciliationInfoPO.getResult2() == 1 && fscDataReconciliationInfoPO.getResult3() == 1 && fscDataReconciliationInfoPO.getResult4() == 1) {
                fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getResult5() != 1 || fscDataReconciliationInfoPO.getResult6() != 1) continue;
            fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(1));
        }
        this.fscDataReconciliationInfoMapper.insertBatch(infoPOList);
    }

    private void payReconciliation() {
        FscComOrderListPageQueryBusiReqBO reqBO = new FscComOrderListPageQueryBusiReqBO();
        reqBO.setPageNo(Integer.valueOf(1));
        reqBO.setPageSize(Integer.valueOf(1));
        reqBO.setOrderFlows(Collections.singletonList(1));
        reqBO.setOrderStates(Arrays.asList(1008, 1011));
        reqBO.setPayerIds(Collections.singletonList(this.operationOrgId));
        FscComOrderListPageQueryBusiRspBO fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(reqBO);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u5355\u5bf9\u8d26\u5217\u8868ES\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)fscComOrderListPageQueryBusiRspBO));
        if (fscComOrderListPageQueryBusiRspBO == null || CollectionUtils.isEmpty((Collection)fscComOrderListPageQueryBusiRspBO.getRows())) {
            return;
        }
        this.fscDataReconciliationInfoMapper.deleteByType(FscConstants.reconciliationType.PAY_ORDER);
        Integer total = fscComOrderListPageQueryBusiRspBO.getTotal();
        long totalPage = total % 200 == 0 ? (long)(total / 200) : (long)(total / 200 + 1);
        reqBO.setPageSize(Integer.valueOf(200));
        int page = 1;
        while ((long)page <= totalPage) {
            reqBO.setPageNo(Integer.valueOf(page));
            FscComOrderListPageQueryBusiRspBO finalFscComOrderListPageQueryBusiRspBO = fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(reqBO);
            CompletableFuture.runAsync(() -> this.payReconciliationOne(finalFscComOrderListPageQueryBusiRspBO), poolExecutor);
            ++page;
        }
    }

    private void payReconciliationOne(FscComOrderListPageQueryBusiRspBO rspBO) {
        ArrayList<FscDataReconciliationInfoPO> infoPOList = new ArrayList<FscDataReconciliationInfoPO>();
        ArrayList<Long> fscOrderIdList = new ArrayList<Long>();
        for (FscComOrderListBO row : rspBO.getRows()) {
            FscDataReconciliationInfoPO fscDataReconciliationInfoPO = new FscDataReconciliationInfoPO();
            fscDataReconciliationInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscDataReconciliationInfoPO.setObjectId(row.getFscOrderId());
            fscDataReconciliationInfoPO.setObjectNo(row.getFscOrderNo());
            fscDataReconciliationInfoPO.setCreateTime(new Date());
            fscDataReconciliationInfoPO.setType(FscConstants.reconciliationType.PAY_ORDER);
            fscDataReconciliationInfoPO.setOrderNo(row.getOrderCodeStr());
            fscDataReconciliationInfoPO.setTotalCharge(row.getTotalCharge() == null ? "0" : row.getTotalCharge().toString());
            fscDataReconciliationInfoPO.setOrderState(row.getOrderState());
            fscDataReconciliationInfoPO.setObjectCreateTime(row.getPayTime());
            fscDataReconciliationInfoPO.setPostingStatus(Integer.valueOf(row.getPostingStatus()));
            fscDataReconciliationInfoPO.setPostingDate(row.getPostingDate());
            fscOrderIdList.add(row.getFscOrderId());
            infoPOList.add(fscDataReconciliationInfoPO);
        }
        Map collect = null;
        List infoPOS = this.fscYcPayReconciliationInfoMapper.selectByFscOrderId(fscOrderIdList);
        if (CollectionUtils.isEmpty((Collection)infoPOS)) {
            collect = infoPOS.stream().collect(Collectors.toMap(FscYcPayReconciliationInfoPO::getFscOrderId, Function.identity()));
        }
        for (FscDataReconciliationInfoPO fscDataReconciliationInfoPO : infoPOList) {
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult1(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult2(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult3(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult5(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult7(Integer.valueOf(0));
            if (collect == null || collect.get(fscDataReconciliationInfoPO.getObjectId()) == null) continue;
            FscYcPayReconciliationInfoPO fscYcPayReconciliationInfoPO = (FscYcPayReconciliationInfoPO)collect.get(fscDataReconciliationInfoPO.getObjectId());
            fscDataReconciliationInfoPO.setYcPostingStatus(fscYcPayReconciliationInfoPO.getPostingStatus());
            fscDataReconciliationInfoPO.setYcPostingDate(fscYcPayReconciliationInfoPO.getPostingDate());
            if (Objects.nonNull(fscYcPayReconciliationInfoPO.getPayDate())) {
                fscDataReconciliationInfoPO.setYcPayCreateTime(DateUtil.strToDate((String)fscYcPayReconciliationInfoPO.getPayDate()));
            }
            fscDataReconciliationInfoPO.setYcVoucher(fscYcPayReconciliationInfoPO.getVoucher());
            fscDataReconciliationInfoPO.setYcTotalCharge(fscYcPayReconciliationInfoPO.getTotalCharge() == null ? "0" : fscYcPayReconciliationInfoPO.getTotalCharge());
            fscDataReconciliationInfoPO.setErpTotalCharge(fscYcPayReconciliationInfoPO.getErpAmount() == null ? "0" : fscYcPayReconciliationInfoPO.getErpAmount());
            if (fscDataReconciliationInfoPO.getPostingStatus() != null && Objects.nonNull(fscDataReconciliationInfoPO.getYcPostingStatus()) && (fscDataReconciliationInfoPO.getPostingStatus() + "").equals(fscDataReconciliationInfoPO.getYcPostingStatus())) {
                fscDataReconciliationInfoPO.setResult1(Integer.valueOf(1));
            }
            if (Objects.nonNull(fscDataReconciliationInfoPO.getPostingDate()) && Objects.nonNull(fscDataReconciliationInfoPO.getYcPostingDate()) && DateUtil.dateToStr((Date)fscDataReconciliationInfoPO.getPostingDate()).substring(10).equals(fscDataReconciliationInfoPO.getYcPostingDate().substring(10))) {
                fscDataReconciliationInfoPO.setResult2(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().compareTo(fscDataReconciliationInfoPO.getYcTotalCharge()) == 0) {
                fscDataReconciliationInfoPO.setResult3(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().equals(fscDataReconciliationInfoPO.getErpTotalCharge())) {
                fscDataReconciliationInfoPO.setResult5(Integer.valueOf(1));
                fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getObjectCreateTime() != null && fscDataReconciliationInfoPO.getYcPayCreateTime() != null && fscDataReconciliationInfoPO.getObjectCreateTime().getTime() == fscDataReconciliationInfoPO.getYcPayCreateTime().getTime()) {
                fscDataReconciliationInfoPO.setResult7(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getResult1() != 1 || fscDataReconciliationInfoPO.getResult2() != 1 || fscDataReconciliationInfoPO.getResult3() != 1 || fscDataReconciliationInfoPO.getResult7() != 1) continue;
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(1));
        }
        this.fscDataReconciliationInfoMapper.insertBatch(infoPOList);
    }

    private void claimReconciliation() {
        Page pagePO = new Page(1, 1);
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO.setType("1");
        List claimListNotMem = this.fscRecvClaimMapper.getClaimListNotMem(fscRecvClaimPO, pagePO);
        if (claimListNotMem == null || CollectionUtils.isEmpty((Collection)claimListNotMem)) {
            return;
        }
        this.fscDataReconciliationInfoMapper.deleteByType(FscConstants.reconciliationType.RECV_CLAIM);
        Integer total = ((FscRecvClaimPO)claimListNotMem.get(0)).getTotalNum();
        long totalPage = total % 200 == 0 ? (long)(total / 200) : (long)(total / 200 + 1);
        pagePO.setPageSize(200);
        fscRecvClaimPO.setType("2");
        int page = 1;
        while ((long)page <= totalPage) {
            pagePO.setPageNo(page);
            List finalClaimListNotMem = claimListNotMem = this.fscRecvClaimMapper.getClaimListNotMem(fscRecvClaimPO, pagePO);
            CompletableFuture.runAsync(() -> this.claimReconciliationOne(finalClaimListNotMem), poolExecutor);
            ++page;
        }
    }

    private void claimReconciliationOne(List<FscRecvClaimPO> claimListNotMem) {
        ArrayList<FscDataReconciliationInfoPO> infoPOList = new ArrayList<FscDataReconciliationInfoPO>();
        ArrayList<Long> claimIdList = new ArrayList<Long>();
        for (FscRecvClaimPO row : claimListNotMem) {
            FscDataReconciliationInfoPO fscDataReconciliationInfoPO = new FscDataReconciliationInfoPO();
            fscDataReconciliationInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscDataReconciliationInfoPO.setObjectId(row.getClaimId());
            fscDataReconciliationInfoPO.setObjectNo(row.getClaimNo());
            fscDataReconciliationInfoPO.setCreateTime(new Date());
            fscDataReconciliationInfoPO.setType(FscConstants.reconciliationType.RECV_CLAIM);
            fscDataReconciliationInfoPO.setObjectCreateTime(row.getRecvDate());
            fscDataReconciliationInfoPO.setBank(row.getSerialNumber());
            fscDataReconciliationInfoPO.setTotalCharge(row.getRecvAmt() == null ? "0" : row.getRecvAmt().toString());
            fscDataReconciliationInfoPO.setOrderState(Integer.valueOf(row.getRecvStatus()));
            fscDataReconciliationInfoPO.setPostingStatus(Integer.valueOf(row.getPostingStatus()));
            claimIdList.add(row.getClaimId());
            infoPOList.add(fscDataReconciliationInfoPO);
        }
        Map collect = null;
        List infoPOS = this.fscYcClaimReconciliationInfoMapper.selectByClaimId(claimIdList);
        if (!CollectionUtils.isEmpty((Collection)infoPOS)) {
            collect = infoPOS.stream().collect(Collectors.toMap(FscYcClaimReconciliationInfoPO::getClaimId, Function.identity()));
        }
        for (FscDataReconciliationInfoPO fscDataReconciliationInfoPO : infoPOList) {
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult2(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult3(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult5(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult8(Integer.valueOf(0));
            if (collect == null || collect.get(fscDataReconciliationInfoPO.getObjectId()) == null) continue;
            FscYcClaimReconciliationInfoPO fscYcClaimReconciliationInfoPO = (FscYcClaimReconciliationInfoPO)collect.get(fscDataReconciliationInfoPO.getObjectId());
            fscDataReconciliationInfoPO.setYcPostingStatus(fscYcClaimReconciliationInfoPO.getPostingStatus());
            if (Objects.nonNull(fscYcClaimReconciliationInfoPO.getRecDate())) {
                fscDataReconciliationInfoPO.setYcPayCreateTime(DateUtil.strToDate((String)fscYcClaimReconciliationInfoPO.getRecDate()));
            }
            fscDataReconciliationInfoPO.setYcVoucher(fscYcClaimReconciliationInfoPO.getVoucher());
            fscDataReconciliationInfoPO.setYcTotalCharge(fscYcClaimReconciliationInfoPO.getTotalCharge() == null ? "0" : fscYcClaimReconciliationInfoPO.getTotalCharge());
            fscDataReconciliationInfoPO.setErpTotalCharge(fscYcClaimReconciliationInfoPO.getErpAmount() == null ? "0" : fscYcClaimReconciliationInfoPO.getErpAmount());
            fscDataReconciliationInfoPO.setYcBank(fscYcClaimReconciliationInfoPO.getFlowingWater());
            if (fscDataReconciliationInfoPO.getObjectCreateTime() != null && fscDataReconciliationInfoPO.getYcPayCreateTime() != null && fscDataReconciliationInfoPO.getObjectCreateTime().getTime() == fscDataReconciliationInfoPO.getYcPayCreateTime().getTime()) {
                fscDataReconciliationInfoPO.setResult2(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().compareTo(fscDataReconciliationInfoPO.getYcTotalCharge()) == 0) {
                fscDataReconciliationInfoPO.setResult3(Integer.valueOf(1));
            }
            if (Objects.nonNull(fscDataReconciliationInfoPO.getBank()) && Objects.nonNull(fscDataReconciliationInfoPO.getYcBank()) && fscDataReconciliationInfoPO.getBank().equals(fscDataReconciliationInfoPO.getYcBank())) {
                fscDataReconciliationInfoPO.setResult8(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getTotalCharge().equals(fscDataReconciliationInfoPO.getErpTotalCharge())) {
                fscDataReconciliationInfoPO.setResult5(Integer.valueOf(1));
                fscDataReconciliationInfoPO.setErpCheckStatus(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getResult2() != 1 || fscDataReconciliationInfoPO.getResult3() != 1 || fscDataReconciliationInfoPO.getResult8() != 1) continue;
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(1));
        }
        this.fscDataReconciliationInfoMapper.insertBatch(infoPOList);
    }

    private void detailReconciliation() {
        Page pagePO = new Page(1, 1);
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setType("1");
        List fscClaimDetailPOS = this.fscClaimDetailMapper.getClaimDetailList(fscClaimDetailPO, pagePO);
        if (fscClaimDetailPOS == null || CollectionUtils.isEmpty((Collection)fscClaimDetailPOS)) {
            return;
        }
        this.fscDataReconciliationInfoMapper.deleteByType(FscConstants.reconciliationType.CLAIM_DETAIL);
        Integer total = ((FscClaimDetailPO)fscClaimDetailPOS.get(0)).getTotalNum();
        long totalPage = total % 200 == 0 ? (long)(total / 200) : (long)(total / 200 + 1);
        pagePO.setPageSize(200);
        fscClaimDetailPO.setType("2");
        int page = 1;
        while ((long)page <= totalPage) {
            pagePO.setPageNo(page);
            List finalFscClaimDetailPOS = fscClaimDetailPOS = this.fscClaimDetailMapper.getClaimDetailList(fscClaimDetailPO, pagePO);
            CompletableFuture.runAsync(() -> this.detailReconciliationOne(finalFscClaimDetailPOS), poolExecutor);
            ++page;
        }
    }

    private void detailReconciliationOne(List<FscClaimDetailPO> claimDetailPOS) {
        ArrayList<FscDataReconciliationInfoPO> infoPOList = new ArrayList<FscDataReconciliationInfoPO>();
        ArrayList<Long> claimDetailIdList = new ArrayList<Long>();
        for (FscClaimDetailPO row : claimDetailPOS) {
            FscDataReconciliationInfoPO fscDataReconciliationInfoPO = new FscDataReconciliationInfoPO();
            fscDataReconciliationInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscDataReconciliationInfoPO.setObjectId(row.getClaimDetailId());
            fscDataReconciliationInfoPO.setObjectNo(row.getDetailNo());
            fscDataReconciliationInfoPO.setCreateTime(new Date());
            fscDataReconciliationInfoPO.setType(FscConstants.reconciliationType.CLAIM_DETAIL);
            fscDataReconciliationInfoPO.setClaimType(Integer.valueOf(row.getClaimType()));
            fscDataReconciliationInfoPO.setOrderNo(row.getOrderNo());
            fscDataReconciliationInfoPO.setFscOrderNo(row.getFscOrderNo());
            fscDataReconciliationInfoPO.setAcceptNo(row.getAcceptCode());
            fscDataReconciliationInfoPO.setTotalCharge(row.getRecvAmt() == null ? "0" : row.getRecvAmt().toString());
            fscDataReconciliationInfoPO.setWriteOffAmount(row.getWriteOffAmount() == null ? "0" : row.getWriteOffAmount().toString());
            BigDecimal recvAmt = row.getRecvAmt() == null ? BigDecimal.ZERO : row.getRecvAmt();
            BigDecimal writeOffAmount = row.getWriteOffAmount() == null ? BigDecimal.ZERO : row.getWriteOffAmount();
            fscDataReconciliationInfoPO.setNotWriteOffAmount(recvAmt.subtract(writeOffAmount).toString());
            claimDetailIdList.add(row.getClaimDetailId());
            infoPOList.add(fscDataReconciliationInfoPO);
        }
        Map collect = null;
        List infoPOS = this.fscYcClaimDetailReconciliationInfoMapper.selectByClaimIdDetail(claimDetailIdList);
        if (!CollectionUtils.isEmpty((Collection)infoPOS)) {
            collect = infoPOS.stream().collect(Collectors.toMap(FscYcClaimDetailReconciliationInfoPO::getClaimDetailId, Function.identity()));
        }
        for (FscDataReconciliationInfoPO fscDataReconciliationInfoPO : infoPOList) {
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult3(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult4(Integer.valueOf(0));
            fscDataReconciliationInfoPO.setResult6(Integer.valueOf(0));
            if (collect == null || collect.get(fscDataReconciliationInfoPO.getObjectId()) == null) continue;
            FscYcClaimDetailReconciliationInfoPO fscYcClaimDetailReconciliationInfoPO = (FscYcClaimDetailReconciliationInfoPO)collect.get(fscDataReconciliationInfoPO.getObjectId());
            fscDataReconciliationInfoPO.setYcTotalCharge(fscYcClaimDetailReconciliationInfoPO.getTotalCharge() == null ? "0" : fscYcClaimDetailReconciliationInfoPO.getTotalCharge());
            fscDataReconciliationInfoPO.setYcWriteOffAmount(fscYcClaimDetailReconciliationInfoPO.getVerifiedOff() == null ? "0" : fscYcClaimDetailReconciliationInfoPO.getVerifiedOff());
            fscDataReconciliationInfoPO.setYcNotWriteOffAmount(fscYcClaimDetailReconciliationInfoPO.getNotVerifiedOff() == null ? "0" : fscYcClaimDetailReconciliationInfoPO.getNotVerifiedOff());
            if (fscDataReconciliationInfoPO.getTotalCharge().equals(fscDataReconciliationInfoPO.getYcTotalCharge())) {
                fscDataReconciliationInfoPO.setResult3(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getWriteOffAmount().equals(fscDataReconciliationInfoPO.getYcWriteOffAmount())) {
                fscDataReconciliationInfoPO.setResult4(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getNotWriteOffAmount().equals(fscDataReconciliationInfoPO.getYcNotWriteOffAmount())) {
                fscDataReconciliationInfoPO.setResult6(Integer.valueOf(1));
            }
            if (fscDataReconciliationInfoPO.getResult3() != 1 || fscDataReconciliationInfoPO.getResult4() != 1 || fscDataReconciliationInfoPO.getResult6() != 1) continue;
            fscDataReconciliationInfoPO.setCheckStatus(Integer.valueOf(1));
        }
        this.fscDataReconciliationInfoMapper.insertBatch(infoPOList);
    }
}

