/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeLineNewBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimChangeService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimChangeNewBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimChangeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimChangeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimChangeOrginalDetailMapper;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimChangeOrginalDetailPO;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcRecvClaimChangeNewBusiServiceImpl
implements FscPushYcRecvClaimChangeNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcRecvClaimChangeNewBusiServiceImpl.class);
    @Autowired
    private FscPushYcRecvClaimChangeService fscPushYcRecvClaimChangeService;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscClaimChangeOrginalDetailMapper fscClaimChangeOrginalDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${settle.stage.value:2}")
    private String settleStage;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscPushYcRecvClaimChangeBusiRspBO pushYcRecvClaimNew(FscPushYcRecvClaimChangeBusiReqBO reqBO) {
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getChangeId());
        if (fscRecvClaimChangePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u53d8\u66f4\u5355\u4fe1\u606f\uff01" + reqBO.getChangeId());
        }
        if (FscConstants.FscClaimChangePushStatus.SUCCESS.equals(fscRecvClaimChangePO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u53d8\u66f4\u5355" + fscRecvClaimChangePO.getChangeNo() + "\u5df2\u63a8\u9001\uff01");
        }
        FscPushYcRecvClaimChangeBusiRspBO rspBO = new FscPushYcRecvClaimChangeBusiRspBO();
        FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
        fscClaimDetailChangePO.setChangeId(reqBO.getChangeId());
        List changeDetailList = this.fscClaimDetailChangeMapper.queryAll(fscClaimDetailChangePO);
        if (CollectionUtils.isEmpty((Collection)changeDetailList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u53d8\u66f4\u5355\u660e\u7ec6\u4fe1\u606f\uff01" + reqBO.getChangeId());
        }
        FscPushYcRecvClaimChangeReqBO pushReqBo = new FscPushYcRecvClaimChangeReqBO();
        FscPushLogPO fscPushLogPo = new FscPushLogPO();
        try {
            FscPushYcRecvClaimChangeBO receivable = new FscPushYcRecvClaimChangeBO();
            receivable.setINIT_FLAG(reqBO.getInitFlag());
            receivable.setORG_ID(this.operationOrgId);
            receivable.setORG_NAME(this.operationOrgName);
            receivable.setCHARGEMAN_ID(fscRecvClaimChangePO.getChangeUserId().toString());
            receivable.setCHARGEMAN_NAME(fscRecvClaimChangePO.getChangeUserName());
            receivable.setDEPT_ID(fscRecvClaimChangePO.getChangeDeptId().toString());
            receivable.setDEPT_NAME(fscRecvClaimChangePO.getChangeDeptName());
            receivable.setRECEIVABLE_CLAIM_NUMBER(fscRecvClaimChangePO.getClaimNo());
            receivable.setRECEIVABLE_CHG_NUMBER(fscRecvClaimChangePO.getChangeNo());
            receivable.setRECEIVABLE_CLAIM_ID(fscRecvClaimChangePO.getClaimId().toString());
            receivable.setCHG_DATE(DateFormatUtils.format((Date)fscRecvClaimChangePO.getChangeDate(), (String)"yyyy-MM-dd"));
            receivable.setCOMMENTS(fscRecvClaimChangePO.getRemark());
            receivable.setTESCO_ID(fscRecvClaimChangePO.getChangeId());
            receivable.setCHG_AMT_OLD(fscRecvClaimChangePO.getChangeAmt().toPlainString());
            receivable.setAPP_STATUS("Y");
            receivable.setSTATUS("A");
            FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
            eternal.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, String> dicMapE = this.getDicMap(eternal);
            BigDecimal CHG_AMT = BigDecimal.ZERO;
            int index = 1;
            FscClaimChangeOrginalDetailPO orginalDetailPO = new FscClaimChangeOrginalDetailPO();
            orginalDetailPO.setChangeId(fscRecvClaimChangePO.getChangeId());
            List orginalDetailPOS = this.fscClaimChangeOrginalDetailMapper.selectList(orginalDetailPO);
            FscRecvClaimPO recvClaimPO = this.fscRecvClaimMapper.queryById(((FscClaimChangeOrginalDetailPO)orginalDetailPOS.get(0)).getClaimId());
            List fscClaimDetailBOS = this.fscClaimDetailMapper.selectClaimInfoListByCliaimId(((FscClaimChangeOrginalDetailPO)orginalDetailPOS.get(0)).getClaimId());
            Map<Long, FscClaimDetailBO> detailBOMap = fscClaimDetailBOS.stream().collect(Collectors.toMap(FscClaimDetailBO::getClaimDetailId, i -> i));
            ArrayList<FscPushYcRecvClaimChangeLineNewBO> receivableClaimOld = new ArrayList<FscPushYcRecvClaimChangeLineNewBO>();
            String RECEIVABLE_CLAIM_TYPE = null;
            if (!StringUtils.isEmpty((Object)recvClaimPO.getRecvType())) {
                FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
                eternalPo.setPCode("RECEIVABLES_CLAIM_TYPE");
                Map<String, String> dicMap = this.getDicMap(eternalPo);
                RECEIVABLE_CLAIM_TYPE = dicMap.get(recvClaimPO.getRecvType());
            }
            for (Object detailPO : orginalDetailPOS) {
                FscPushYcRecvClaimChangeLineNewBO orginalBO = new FscPushYcRecvClaimChangeLineNewBO();
                orginalBO.setTESCO_ID(detailPO.getClaimDetailId() + "");
                orginalBO.setCHANGE_OR_NOT("N");
                orginalBO.setCHANGEABLE_AMT(detailPO.getVariableAmount().toPlainString());
                orginalBO.setCLAIM_AMT_CHG(detailPO.getChangeAmount().toPlainString());
                orginalBO.setCHARGEMAN_ID(detailBOMap.get(detailPO.getClaimDetailId()).getHandleUserId() + "");
                orginalBO.setCHARGEMAN_NAME(detailBOMap.get(detailPO.getClaimDetailId()).getHandleUserName());
                orginalBO.setDEPT_ID(detailBOMap.get(detailPO.getClaimDetailId()).getHandleDeptId() + "");
                orginalBO.setDEPT_NAME(detailBOMap.get(detailPO.getClaimDetailId()).getHandleDeptName());
                orginalBO.setCLAIM_INFO_ID(detailPO.getClaimDetailId() + "");
                orginalBO.setLINE_NUMBER(index + "");
                orginalBO.setRECEIVABLE_CLAIM_TYPE(RECEIVABLE_CLAIM_TYPE);
                FscClaimDetailBO fscClaimDetailBO = detailBOMap.get(detailPO.getClaimDetailId());
                orginalBO.setCLAIM_TYPE_CHG(dicMapE.get(fscClaimDetailBO.getClaimType()));
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderId())) {
                    orginalBO.setBILL_ID_CHG(fscClaimDetailBO.getFscOrderId().toString());
                    orginalBO.setBILL_NUMBER_CHG(fscClaimDetailBO.getFscOrderNo());
                }
                ++index;
                receivableClaimOld.add(orginalBO);
            }
            ArrayList<FscPushYcRecvClaimChangeLineNewBO> receivableClaimChg = new ArrayList<FscPushYcRecvClaimChangeLineNewBO>();
            index = 1;
            for (FscClaimDetailChangePO po : changeDetailList) {
                FscPushYcRecvClaimChangeLineNewBO changeBO = new FscPushYcRecvClaimChangeLineNewBO();
                changeBO.setCHARGEMAN_ID(fscRecvClaimChangePO.getChangeUserId().toString());
                changeBO.setCHARGEMAN_NAME(fscRecvClaimChangePO.getChangeUserName());
                changeBO.setDEPT_ID(fscRecvClaimChangePO.getChangeDeptId().toString());
                changeBO.setDEPT_NAME(fscRecvClaimChangePO.getChangeDeptName());
                changeBO.setCHANGE_CLAIM_DATE(receivable.getCHG_DATE());
                changeBO.setCLAIM_AMT_CHG(po.getChangeAmt().toPlainString());
                changeBO.setLINE_NUMBER(index + "");
                changeBO.setCHANGE_OR_NOT("Y");
                changeBO.setCLAIM_TYPE_CHG(dicMapE.get(po.getChangeClaimType().toString()));
                changeBO.setTESCO_ID(po.getChangeDetailId().toString());
                changeBO.setCLAIM_AMOUNT(po.getChangeAmt().toPlainString());
                if (po.getChangeFscOrderId() != null) {
                    changeBO.setBILL_ID_CHG(po.getChangeFscOrderId().toString());
                    changeBO.setBILL_NUMBER_CHG(po.getChangeFscOrderNo());
                } else {
                    changeBO.setBILL_ID_CHG("");
                    changeBO.setBILL_NUMBER_CHG("");
                    if (po.getChangeClaimType() == 2 || po.getChangeClaimType() == 5 || po.getChangeClaimType() == 7 || po.getChangeClaimType() == 10 || po.getChangeClaimType() == 14) {
                        changeBO.setRECEIPT_NUMBER(po.getChangeDetailNo());
                    }
                }
                CHG_AMT = CHG_AMT.add(po.getChangeAmt());
                ++index;
                receivableClaimChg.add(changeBO);
            }
            receivable.setCHG_AMT(CHG_AMT.toPlainString());
            pushReqBo.setReceivable(receivable);
            pushReqBo.setReceivableClaimChg(receivableClaimChg);
            pushReqBo.setReceivableClaimOld(receivableClaimOld);
            FscPushYcRecvClaimChangeRspBO pushRspBo = this.dealParamToYc(reqBO.getAgentAccount(), pushReqBo, fscPushLogPo, fscRecvClaimChangePO);
            if (!pushRspBo.getRespCode().equals("0000")) {
                this.saveLog(fscRecvClaimChangePO, FscConstants.FscPushStatus.FAIL, fscPushLogPo);
                rspBO.setRespCode(pushRspBo.getRespCode());
                rspBO.setRespDesc(pushRspBo.getRespDesc());
                fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.FAIL);
                fscRecvClaimChangePO.setPushDate(new Date());
                fscRecvClaimChangePO.setFailReason(pushRspBo.getRespDesc());
                this.savePushStatus(fscRecvClaimChangePO);
                return rspBO;
            }
            fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.SUCCESS);
            fscRecvClaimChangePO.setPushDate(new Date());
            fscRecvClaimChangePO.setFailReason(null);
            this.savePushStatus(fscRecvClaimChangePO);
            this.pushFile(reqBO, fscRecvClaimChangePO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u8ba4\u9886\u53d8\u66f4\u5355\u5931\u8d25\uff01" + FscCommonUtils.dealStackTrace((Exception)e));
            fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.FAIL);
            fscRecvClaimChangePO.setFailReason(e.getMessage());
            fscRecvClaimChangePO.setPushDate(new Date());
            this.savePushStatus(fscRecvClaimChangePO);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        this.saveLog(fscRecvClaimChangePO, FscConstants.FscPushStatus.SUCCESS, fscPushLogPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(FscRecvClaimChangePO fscRecvClaimChangePO, Integer status, FscPushLogPO fscPushLogPo) {
        try {
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimChangePO.getChangeId());
            fscPushLogPo.setObjectNo(fscRecvClaimChangePO.getChangeNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM_CHANGE);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            int count = this.fscPushLogMapper.insert(fscPushLogPo);
            if (count == 0) {
                throw new ZTBusinessException("\u5b58\u50a8\u5931\u8d25\uff0c\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u7684\u6761\u6570\u4e3a0");
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(FscRecvClaimChangePO fscRecvClaimChangePO) {
        int result = this.fscRecvClaimChangeMapper.updatePushStatus(fscRecvClaimChangePO);
        if (result != FscConstants.SINGLE_UPDATE_RESULT) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u53d8\u66f4\u5355\u63a8\u9001\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }

    private List<FscClaimDetailChangePO> dealSplitBos(List<FscClaimChangeOrginalDetailPO> oriList, List<FscClaimDetailChangePO> changeList) {
        ArrayList<FscClaimDetailChangePO> changePOS = new ArrayList<FscClaimDetailChangePO>();
        int changeIndex = 0;
        int oriIndex = 0;
        while (changeIndex <= changeList.size() - 1) {
            BigDecimal oriAmt;
            FscClaimDetailChangePO changePO = changeList.get(changeIndex);
            FscClaimChangeOrginalDetailPO detailPO = oriList.get(oriIndex);
            FscClaimDetailChangePO po = (FscClaimDetailChangePO)JSON.parseObject((String)JSON.toJSONString((Object)changePO), FscClaimDetailChangePO.class);
            BigDecimal changeAmt = changePO.getChangeAmt();
            if (changeAmt.compareTo(oriAmt = detailPO.getChangeAmount()) > 0) {
                BigDecimal changeAmtRes = changeAmt.subtract(oriAmt);
                changePO.setChangeAmt(changeAmtRes);
                po.setChangeAmt(oriAmt);
                po.setClaimDetailId(detailPO.getClaimDetailId());
                changePOS.add(po);
                ++oriIndex;
                continue;
            }
            if (changeAmt.compareTo(oriAmt) < 0) {
                BigDecimal oriAmtRes = oriAmt.subtract(changeAmt);
                detailPO.setChangeAmount(oriAmtRes);
                po.setChangeAmt(changeAmt);
                po.setClaimDetailId(detailPO.getClaimDetailId());
                changePOS.add(po);
                ++changeIndex;
                continue;
            }
            po.setChangeAmt(changeAmt);
            po.setClaimDetailId(detailPO.getClaimDetailId());
            changePOS.add(po);
            ++oriIndex;
            ++changeIndex;
        }
        return changePOS;
    }

    private FscPushYcRecvClaimChangeRspBO dealParamToYc(String agentAccount, FscPushYcRecvClaimChangeReqBO pushReqBo, FscPushLogPO fscPushLogPo, FscRecvClaimChangePO fscRecvClaimChangePO) {
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("WRITEOFF_PREPAY", (Object)pushReqBo.getReceivable());
        jsonObject.put("WRITEOFF_CLA_LINE", (Object)pushReqBo.getReceivableClaimChg());
        jsonObject.put("WRITEOFF_PREPAY_LINE", (Object)pushReqBo.getReceivableClaimOld());
        jsonObject.put("STAGE", (Object)this.settleStage);
        jsonArray.add((Object)jsonObject);
        fscPushLogPo.setObjData(jsonArray.toJSONString());
        fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.SUCCESS);
        fscRecvClaimChangePO.setPushDate(new Date());
        fscRecvClaimChangePO.setFailReason(null);
        this.savePushStatus(fscRecvClaimChangePO);
        this.saveLog(fscRecvClaimChangePO, FscConstants.FscPushStatus.SUCCESS, fscPushLogPo);
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPo.setPushParseData(encryPtionRspBO.getData());
        FscPushYcRecvClaimChangeReqBO pushYcRecvClaimChangeReqBO = new FscPushYcRecvClaimChangeReqBO();
        pushYcRecvClaimChangeReqBO.setData(encryPtionRspBO.getData());
        pushYcRecvClaimChangeReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscPushYcRecvClaimChangeRspBO fscPushYcRecvClaimBillRspBO = this.fscPushYcRecvClaimChangeService.pushRecvClaimChange(pushYcRecvClaimChangeReqBO);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(fscPushYcRecvClaimBillRspBO.getRespCode()) ? fscPushYcRecvClaimBillRspBO.getData() : fscPushYcRecvClaimBillRspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPo.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPo.setRespParseData(fscPushYcRecvClaimBillRspBO.getRspData());
        fscPushYcRecvClaimBillRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        return fscPushYcRecvClaimBillRspBO;
    }

    private void pushFile(FscPushYcRecvClaimChangeBusiReqBO reqBO, FscRecvClaimChangePO fscRecvClaimPo) {
        try {
            FscAttachmentPO searchAttachmentPO = new FscAttachmentPO();
            searchAttachmentPO.setObjId(reqBO.getChangeId());
            searchAttachmentPO.setAttachmentType(FscConstants.AttachmentType.CLAIM_CHANGE);
            List attachmentPOS = this.fscAttachmentMapper.getList(searchAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                List fileList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOS), AttachmentBO.class);
                FscPushYcAttachmentAbilityReqBO fscPushYcAttachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                fscPushYcAttachmentAbilityReqBO.setObjId(reqBO.getChangeId());
                fscPushYcAttachmentAbilityReqBO.setObjNo(fscRecvClaimPo.getChangeNo());
                fscPushYcAttachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.CLAIM_CHANGE);
                fscPushYcAttachmentAbilityReqBO.setAgentName(fscRecvClaimPo.getHandleUserName());
                fscPushYcAttachmentAbilityReqBO.setAgentAccount(reqBO.getAgentAccount());
                if (fscRecvClaimPo.getHandleUserId() != null) {
                    fscPushYcAttachmentAbilityReqBO.setUserId(fscRecvClaimPo.getHandleUserId().toString());
                } else {
                    fscPushYcAttachmentAbilityReqBO.setUserId(reqBO.getAgentAccount());
                }
                fscPushYcAttachmentAbilityReqBO.setFileList(fileList);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(fscPushYcAttachmentAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u9644\u4ef6\u62a5\u9519" + e.getMessage());
        }
    }
}

