/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscSyncSendSaleFscOrderToYcBusiService;
import com.tydic.fsc.common.busi.bo.FscSyncSendSaleFscOrderToYCBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSyncSendSaleFscOrderToYCBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscSyncSendSaleFscOrderToYcBusiServiceImpl
implements FscSyncSendSaleFscOrderToYcBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncSendSaleFscOrderToYcBusiServiceImpl.class);
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u4e1a\u8d22\u63a8\u9001\u5931\u8d25";

    @Override
    public FscSyncSendSaleFscOrderToYCBusiRspBO syncSendSaleToYc(FscSyncSendSaleFscOrderToYCBusiReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(queryVo);
        FscBillSendSaleFscOrderToYCAbilityReqBO abilityReqBO = new FscBillSendSaleFscOrderToYCAbilityReqBO();
        abilityReqBO.setFscOrderIds(Collections.singletonList(reqBO.getFscOrderId()));
        FscBillSendSaleFscOrderToYCAbilityRspBO abilityRspBO = this.fscBillSendSaleFscOrderToYCAbilityService.sendSaleFscOrder(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPO.getFscOrderId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPO.getOrderState());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            try {
                FscOrderPO updateReason = new FscOrderPO();
                updateReason.setFscOrderId(fscOrderPO.getFscOrderId());
                updateReason.setFailReason(abilityRspBO.getRespDesc());
                this.fscOrderMapper.updateById(updateReason);
            }
            catch (Exception e) {
                log.error("\u5b58\u50a8\u65e5\u5fd7\u5931\u8d25\uff01" + e);
            }
            paramMap.put("skipFlag", FscConstants.BillOrderSkigFlag.SKIG_FLAG_ERROR);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        }
        FscSyncSendSaleFscOrderToYCBusiRspBO rspBO = new FscSyncSendSaleFscOrderToYCBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

