/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageReqBo;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService"})
public class FscFinanceWriteOffPageAbilityServiceImpl
implements FscFinanceWriteOffPageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffPageAbilityServiceImpl.class);
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @PostMapping(value={"financeWriteOffQryPage"})
    public FscRspPageBaseBO<FscFinanceWriteOffPageRspBo> financeWriteOffQryPage(@RequestBody FscFinanceWriteOffPageReqBo reqBO) {
        ArrayList<Integer> orderTypeList;
        FscComOrderListPageQueryBusiReqBO qryReqBO = (FscComOrderListPageQueryBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscComOrderListPageQueryBusiReqBO.class);
        qryReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("1")) {
            orderTypeList = new ArrayList<Integer>();
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR_GOODS);
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR);
            qryReqBO.setOrderTypeList(orderTypeList);
            qryReqBO.setNoSettlePlatform(Integer.valueOf(2));
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("2")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.TH);
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("11")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
            qryReqBO.setTradeMode(Integer.valueOf(2));
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("5")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
        } else if (reqBO.getOrderBusiType() != null) {
            orderTypeList = new ArrayList();
            orderTypeList.add(reqBO.getOrderBusiType());
            qryReqBO.setOrderTypeList(orderTypeList);
        }
        if (Objects.equals(0, reqBO.getBillStatus())) {
            qryReqBO.setWriteStatusList(Arrays.asList(0, 1));
        }
        FscComOrderListPageQueryBusiRspBO orderList = this.fscEsQryComOrderListBusiService.esQryComOrderList(qryReqBO);
        FscRspPageBaseBO rspBO = new FscRspPageBaseBO();
        List collect = orderList.getRows().stream().map(e -> {
            log.info("FscComOrderListBO:{}", e);
            FscFinanceWriteOffPageRspBo bo = (FscFinanceWriteOffPageRspBo)BeanUtil.copyProperties((Object)e, FscFinanceWriteOffPageRspBo.class);
            bo.setCreateOperTime(e.getCreateTime());
            FscOrderPayItemPO orderPayItemPO = this.fscOrderPayItemMapper.getPrePayAmountByFscOrderId(e.getFscOrderId());
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal paidAmountLocal = BigDecimal.ZERO;
            if (null != orderPayItemPO) {
                paidAmount = orderPayItemPO.getPaidAmount();
                paidAmountLocal = orderPayItemPO.getPaidAmountLocal();
            }
            bo.setPrePayAmt(paidAmount);
            bo.setWriteOffAmtLocal(paidAmountLocal);
            bo.setBillAmount(e.getTotalChargeBill());
            bo.setContractName(e.getContractName());
            bo.setRemainAmount(paidAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : paidAmount.subtract(paidAmountLocal));
            return bo;
        }).collect(Collectors.toList());
        rspBO.setRows(collect);
        rspBO.setTotal(orderList.getTotal());
        rspBO.setPageNo(orderList.getPageNo());
        rspBO.setRecordsTotal(orderList.getRecordsTotal());
        return rspBO;
    }
}

