/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscPushNewYcPayRefundQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundBALQueryBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundQueryBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPushNewYcPayRefundQueryPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcQryErpCodeAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryErpCodeReqBO;
import com.tydic.umc.general.ability.bo.UmcQryErpCodeRspBO;
import com.tydic.uoc.common.ability.api.UocContractInfoQryAbilityService;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryReqBO;
import com.tydic.uoc.common.ability.bo.UocContractInfoQryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdProContractHeadBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushNewYcPayRefundQueryAbilityService"})
public class FscPushNewYcPayRefundQueryAbilityServiceImpl
implements FscPushNewYcPayRefundQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPayRefundQueryAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocContractInfoQryAbilityService uocContractInfoQryAbilityService;
    @Autowired
    private UmcQryErpCodeAbilityService umcQryErpCodeAbilityService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;

    @PostMapping(value={"dealPushNewYcPayRefundQuery"})
    public FscPushNewYcPayRefundQueryAbilityRspBO dealPushNewYcPayRefundQuery(@RequestBody FscPushNewYcPayRefundQueryAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u51b2\u9500\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPushNewYcPayRefundQueryAbilityRspBO rspBO = new FscPushNewYcPayRefundQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        BigDecimal notRefundAmount = this.fscPayShouldRefundMapper.querySumNotRefundAmountByRefundId(reqBO.getRefundId());
        if (notRefundAmount == null) {
            rspBO.setPAY_LIST(new ArrayList());
            return rspBO;
        }
        if (notRefundAmount.compareTo(BigDecimal.ZERO) != 0) {
            throw new FscBusinessException("198888", "\u51b2\u9500\u5355\u672a\u5b8c\u6210\u9000\u6b3e\uff01");
        }
        FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        List refundList = this.fscOrderRefundMapper.getPushBOByRefundId(reqBO.getRefundId());
        Long orderId = ((FscOrderRelationPO)this.fscOrderRelationMapper.getListByFscOrderIds(Collections.singletonList(fscOrderRefundPO.getFscOrderId())).get(0)).getOrderId();
        Map<Long, UocOrdProContractHeadBO> contractHeadBOMap = this.qryOrderContractInfo(Collections.singletonList(orderId));
        ArrayList<FscPushNewYcPayRefundQueryBO> PAY_LIST = new ArrayList<FscPushNewYcPayRefundQueryBO>();
        BigDecimal amount = BigDecimal.ZERO;
        for (FscPushNewYcPayRefundQueryPO po : refundList) {
            log.error("\u67e5\u8be2\u9000\u6b3e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)po));
            FscPushNewYcPayRefundQueryBO refundBO = new FscPushNewYcPayRefundQueryBO();
            refundBO.setEG_BILL_NUM(po.getEgBillNum());
            refundBO.setEG_BILL_ID(po.getEgBillId());
            refundBO.setPERSON_ID(po.getPersonId());
            refundBO.setPERSON_NAME(po.getPersonName());
            refundBO.setDEPT_ID(po.getDeptId());
            refundBO.setDEPT_NAME(po.getDeptName());
            refundBO.setORG_ID(this.operationOrgId);
            refundBO.setORG_NAME(this.operOrgName);
            refundBO.setBILL_DATE(DateUtil.dateToStr((Date)po.getBillDate(), (String)"yyyy-MM-dd"));
            refundBO.setBAL_BILL_ID(po.getBalBillId());
            refundBO.setBAL_BILL_NUM(po.getBalBillNum());
            refundBO.setAMOUNT(po.getAmount().setScale(2, RoundingMode.HALF_UP).negate());
            refundBO.setCASH_POOL_ID(po.getCashPoolId());
            refundBO.setCASH_POOL_NUM(po.getCashPoolNum());
            refundBO.setCASH_POOL_BANK_ID(po.getCashPoolBankId());
            refundBO.setCASH_POOL_BANK_NAME(po.getCashPoolBankName());
            refundBO.setCASH_POOL_BANK_NUM(po.getCashPoolBankNum());
            refundBO.setCASH_POOL_AMOUNT(po.getCashPoolAmount().setScale(2, RoundingMode.HALF_UP).negate());
            UocOrdProContractHeadBO contractHeadBO = contractHeadBOMap.get(orderId);
            if (contractHeadBO == null) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5408\u540c\u4fe1\u606f\uff01");
            }
            refundBO.setCONTRACT_ID(String.valueOf(contractHeadBO.getEgContractId()));
            refundBO.setCONTRACT_NUM(contractHeadBO.getEgContractNum());
            refundBO.setCONTRACT_NAME(contractHeadBO.getContractName());
            UmcQryErpCodeReqBO umcReqBo = (UmcQryErpCodeReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), UmcQryErpCodeReqBO.class);
            umcReqBo.setOrgIdWeb(po.getSupplierId());
            UmcQryErpCodeRspBO umcRspBo = this.umcQryErpCodeAbilityService.qryErpCode(umcReqBo);
            if (!"0000".equals(umcRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u4f9b\u8d27\u65b9erp\u4fe1\u606f\u5931\u8d25\uff1a" + umcRspBo.getRespDesc());
            }
            refundBO.setVENDOR_ID(umcRspBo.getErpCode());
            refundBO.setVENDOR_NAME(umcRspBo.getErpName());
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setObjId(Long.valueOf(refundBO.getEG_BILL_ID()));
            List attachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            refundBO.setDOC_COUNT(String.valueOf(attachmentPOList.size()));
            FscPushNewYcPayRefundBALQueryBO PAY_BAL = new FscPushNewYcPayRefundBALQueryBO();
            PAY_BAL.setEG_TESCO_ID(fscOrderRefundPO.getRefundId());
            PAY_BAL.setBALANCE_ID(fscOrderRefundPO.getRefundId());
            PAY_BAL.setBALANCE_NUM(fscOrderRefundPO.getRefundNo());
            PAY_BAL.setBALANCE_AMT(fscOrderRefundPO.getRefundAmount().negate());
            PAY_BAL.setNO_PAID_AMOUNT(refundBO.getAMOUNT());
            PAY_BAL.setORG_ID(this.operationOrgId);
            PAY_BAL.setORG_NAME(this.operOrgName);
            PAY_BAL.setAMOUNT(refundBO.getAMOUNT());
            refundBO.setPAY_BAL(PAY_BAL);
            PAY_LIST.add(refundBO);
        }
        rspBO.setPAY_LIST(PAY_LIST);
        return rspBO;
    }

    private Map<Long, UocOrdProContractHeadBO> qryOrderContractInfo(List<Long> orderIdList) {
        UocContractInfoQryReqBO uocContractInfoQryReqBO = new UocContractInfoQryReqBO();
        uocContractInfoQryReqBO.setOrderIds(orderIdList);
        UocContractInfoQryRspBO uocContractInfoQryRspBO = this.uocContractInfoQryAbilityService.qryContractInfoByOrderId(uocContractInfoQryReqBO);
        if (!uocContractInfoQryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(uocContractInfoQryRspBO.getRespCode(), uocContractInfoQryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocContractInfoQryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return uocContractInfoQryRspBO.getRows().stream().collect(Collectors.toMap(UocOrdProContractHeadBO::getOrderId, Function.identity()));
    }
}

