/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceChargeBudgetQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceChargeBudgetQryListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceChargeBudgetQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceChargeBudgetQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceChargeBudgetQryRspBOData;
import com.tydic.fsc.common.ability.vo.FscFinanceChargeBudgetInfoListVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceChargeBudgetQryAbilityService"})
public class FscFinanceChargeBudgetQryAbilityServiceImpl
implements FscFinanceChargeBudgetQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceChargeBudgetQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fsFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryChargeBudget"})
    public FscFinanceChargeBudgetQryRspBO qryChargeBudget(@RequestBody FscFinanceChargeBudgetQryReqBO reqBo) {
        FscFinanceChargeBudgetQryRspBO rspBO = new FscFinanceChargeBudgetQryRspBO();
        if (reqBo == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscFinanceChargeBudgetQryListReqBO listReqBO : reqBo.getBudgetQryList()) {
            this.valid(listReqBO);
        }
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fsFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)domainUrl), (String)"\u672a\u914d\u7f6e\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u5efa\u8bbe\u9879\u76ee\u63a5\u53e3");
            HashMap header = Maps.newHashMap();
            String token = financeShareTokenRspBO.getToken();
            header.put("Authorization", token);
            String body = JSON.toJSONString((Object)reqBo.getBudgetQryList());
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u67e5\u8be2\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587 url:{} params:{} token:{}", new Object[]{this.fscShareFinanceServiceConfiguration.getBu101(), body, token});
            String json = SSLClient.doPostWithHeadMap((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getBu101()), (String)body, (Map)header);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u67e5\u8be2\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)json);
            FscFinanceChargeBudgetInfoListVO vo = (FscFinanceChargeBudgetInfoListVO)JSON.parseObject((String)json, FscFinanceChargeBudgetInfoListVO.class);
            Assert.isTrue((vo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3a\u7a7a");
            Assert.isTrue((vo.getCode() == 0 ? 1 : 0) != 0, (String)vo.getMsg());
            if (!CollectionUtils.isEmpty((Collection)vo.getData()) && vo.getData().size() == 1 && StringUtils.isEmpty((CharSequence)((FscFinanceChargeBudgetQryRspBOData)vo.getData().get(0)).getBudgetItemCode())) {
                rspBO.setData(new ArrayList());
            } else {
                BeanUtil.copyProperties((Object)vo, (Object)rspBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u9884\u7b97\u67e5\u8be2\u63a5\u53e3\uff1a%s", e.getMessage()));
        }
        return rspBO;
    }

    private void valid(FscFinanceChargeBudgetQryListReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getOrgId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5f53\u524d\u7528\u6237\u673a\u6784id[orgId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBizDate())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e1a\u52a1\u65e5\u671f[bizDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCostCenterCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u7f16\u53f7[costCenterCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSubTypeCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u4e8b\u9879\u7f16\u53f7[subTypeCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

