/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.busi.api.FscBillMailDetailQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscBillMailDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillMailDetailQueryBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscBillMailItemRspBO;
import com.tydic.fsc.common.busi.bo.FscBillMailRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillMailDetailQueryBusiServiceImpl
implements FscBillMailDetailQueryBusiService {
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @Override
    public FscBillMailDetailQueryBusiRspBO qryBillMailDetail(FscBillMailDetailBusiReqBO reqBO) {
        FscBillMailDetailQueryBusiRspBO rspBO = new FscBillMailDetailQueryBusiRspBO();
        this.queryByNo(reqBO, rspBO);
        this.queryByName(reqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void queryByName(FscBillMailDetailBusiReqBO reqBO, FscBillMailDetailQueryBusiRspBO rspBO) {
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (null == fscOrderInvoicePO) {
            throw new FscBusinessException("193103", "\u8be5\u7ed3\u7b97\u5355id" + reqBO.getFscOrderId() + "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u53d1\u7968\u4fe1\u606f");
        }
        FscOrderInvoicePO fscOrderInvoiceQuery = new FscOrderInvoicePO();
        fscOrderInvoiceQuery.setBuyName(fscOrderInvoicePO.getBuyName());
        fscOrderInvoiceQuery.setReceiveName(fscOrderInvoicePO.getReceiveName());
        fscOrderInvoiceQuery.setReceiveAddr(fscOrderInvoicePO.getReceiveAddr());
        fscOrderInvoiceQuery.setProvince(fscOrderInvoicePO.getProvince());
        fscOrderInvoiceQuery.setCity(fscOrderInvoicePO.getCity());
        fscOrderInvoiceQuery.setArea(fscOrderInvoicePO.getArea());
        fscOrderInvoiceQuery.setTown(fscOrderInvoicePO.getTown());
        List orderInvoiceList = this.fscOrderInvoiceMapper.getList(fscOrderInvoiceQuery);
        if (CollectionUtils.isEmpty((Collection)orderInvoiceList)) {
            throw new FscBusinessException("193103", "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u53d1\u7968\u4fe1\u606f");
        }
        List fscOrderIdList = orderInvoiceList.stream().map(FscOrderInvoicePO::getFscOrderId).collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIdList);
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderList)) {
            throw new FscBusinessException("193103", "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        Map<Long, FscOrderPO> fscOrderMap = fscOrderList.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, fscOrder -> fscOrder));
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderIds(fscOrderIdList);
        fscInvoicePO.setSendStatus("1");
        List mailedInvoiceList = this.fscInvoiceMapper.getListByIdsAndSendStatus(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)mailedInvoiceList)) {
            Map<Long, List<FscInvoicePO>> mailedInvoiceMap = mailedInvoiceList.stream().collect(Collectors.groupingBy(FscInvoicePO::getFscOrderId));
            FscBillMailRspBO mailedBillMailRspBO = this.buildRspBO(fscOrderMap, mailedInvoiceMap, orderInvoiceList, "1");
            rspBO.setMailedBillMailByNameRspBO(mailedBillMailRspBO);
        }
        fscInvoicePO.setSendStatus("2");
        List cancelledInvoiceList = this.fscInvoiceMapper.getListByIdsAndSendStatus(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)cancelledInvoiceList)) {
            Map<Long, List<FscInvoicePO>> cancelledInvoiceMap = cancelledInvoiceList.stream().collect(Collectors.groupingBy(FscInvoicePO::getFscOrderId));
            FscBillMailRspBO cancelledBillMailRspBO = this.buildRspBO(fscOrderMap, cancelledInvoiceMap, orderInvoiceList, "2");
            rspBO.setCancelledBillMailByNameRspBO(cancelledBillMailRspBO);
        }
    }

    private void queryByNo(FscBillMailDetailBusiReqBO reqBO, FscBillMailDetailQueryBusiRspBO rspBO) {
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        List<FscOrderInvoicePO> orderInvoiceList = Collections.singletonList(fscOrderInvoicePO);
        if (null == fscOrderInvoicePO) {
            throw new FscBusinessException("193103", "\u8be5\u7ed3\u7b97\u5355id" + reqBO.getFscOrderId() + "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u53d1\u7968\u4fe1\u606f");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("193103", "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        HashMap<Long, FscOrderPO> fscOrderMap = new HashMap<Long, FscOrderPO>();
        fscOrderMap.put(fscOrderPO.getFscOrderId(), fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePO.setSendStatus("1");
        List mailedInvoiceList = this.fscInvoiceMapper.getListByIdsAndSendStatus(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)mailedInvoiceList)) {
            Map<Long, List<FscInvoicePO>> mailedInvoiceMap = mailedInvoiceList.stream().collect(Collectors.groupingBy(FscInvoicePO::getFscOrderId));
            FscBillMailRspBO mailedBillMailRspBO = this.buildRspBO(fscOrderMap, mailedInvoiceMap, orderInvoiceList, "1");
            rspBO.setMailedBillMailByNoRspBO(mailedBillMailRspBO);
        }
        fscInvoicePO.setSendStatus("2");
        List cancelledInvoiceList = this.fscInvoiceMapper.getListByIdsAndSendStatus(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)cancelledInvoiceList)) {
            Map<Long, List<FscInvoicePO>> cancelledInvoiceMap = cancelledInvoiceList.stream().collect(Collectors.groupingBy(FscInvoicePO::getFscOrderId));
            FscBillMailRspBO cancelledBillMailRspBO = this.buildRspBO(fscOrderMap, cancelledInvoiceMap, orderInvoiceList, "2");
            rspBO.setCancelledBillMailByNoRspBO(cancelledBillMailRspBO);
        }
    }

    private FscBillMailRspBO buildRspBO(Map<Long, FscOrderPO> fscOrderMap, Map<Long, List<FscInvoicePO>> invoiceMap, List<FscOrderInvoicePO> orderInvoiceList, String mailStatus) {
        FscBillMailRspBO fscBillMailRspBO = new FscBillMailRspBO();
        ArrayList<FscBillMailItemRspBO> fscBillMailItemRspBOS = new ArrayList<FscBillMailItemRspBO>();
        ArrayList<String> invoiceNoList = new ArrayList<String>();
        for (FscOrderInvoicePO fscOrderInvoicePO : orderInvoiceList) {
            Long fscOrderId = fscOrderInvoicePO.getFscOrderId();
            FscOrderPO fscOrderPO = fscOrderMap.get(fscOrderId);
            if (null != fscOrderPO && null != invoiceMap.get(fscOrderId)) {
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                    fscBillMailRspBO.setReceiveId(fscOrderPO.getPurchaserId());
                    fscBillMailRspBO.setReceiveOrgName(fscOrderPO.getPurchaserName());
                } else if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
                    fscBillMailRspBO.setReceiveId(fscOrderPO.getProOrgId());
                    fscBillMailRspBO.setReceiveOrgName(fscOrderPO.getProOrgName());
                } else if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscOrderPO.getReceiveType())) {
                    fscBillMailRspBO.setReceiveId(fscOrderPO.getSupplierId());
                    fscBillMailRspBO.setReceiveOrgName(fscOrderPO.getSupplierName());
                }
                invoiceNoList.add(fscOrderPO.getOrderNo());
            }
            fscBillMailRspBO.setReceiveName(fscOrderInvoicePO.getReceiveName());
            fscBillMailRspBO.setBuyName(fscOrderInvoicePO.getBuyName());
            fscBillMailRspBO.setReceivePhone(fscOrderInvoicePO.getReceivePhone());
            fscBillMailRspBO.setProvince(fscOrderInvoicePO.getProvince());
            fscBillMailRspBO.setCity(fscOrderInvoicePO.getCity());
            fscBillMailRspBO.setArea(fscOrderInvoicePO.getArea());
            fscBillMailRspBO.setTown(fscOrderInvoicePO.getTown());
            fscBillMailRspBO.setAddress(fscOrderInvoicePO.getAddress());
            fscBillMailRspBO.setMailStatus(mailStatus);
            this.buildIemRspBO(invoiceMap, fscOrderId, fscOrderInvoicePO, fscOrderPO, fscBillMailItemRspBOS, fscBillMailRspBO);
        }
        fscBillMailRspBO.setBillMailItemBOS(fscBillMailItemRspBOS);
        fscBillMailRspBO.setInvoiceCount(fscBillMailItemRspBOS.size());
        fscBillMailRspBO.setOrderNo(invoiceNoList);
        return fscBillMailRspBO;
    }

    private void buildIemRspBO(Map<Long, List<FscInvoicePO>> invoiceMap, Long fscOrderId, FscOrderInvoicePO fscOrderInvoicePO, FscOrderPO fscOrderPO, List<FscBillMailItemRspBO> fscBillMailItemRspBOS, FscBillMailRspBO fscBillMailRspBO) {
        List<FscInvoicePO> fscInvoicePOS = invoiceMap.get(fscOrderId);
        if (!CollectionUtils.isEmpty(fscInvoicePOS)) {
            ArrayList<FscBillMailItemRspBO> fscBillMailItemList = new ArrayList<FscBillMailItemRspBO>(fscInvoicePOS.size());
            for (FscInvoicePO fscInvoicePO : fscInvoicePOS) {
                FscBillMailItemRspBO fscBillMailItemRspBO = new FscBillMailItemRspBO();
                fscBillMailRspBO.setSendOrder(fscInvoicePO.getSendOrder());
                fscBillMailItemRspBO.setAmt(fscInvoicePO.getAmt());
                fscBillMailItemRspBO.setTaxAmt(fscInvoicePO.getTaxAmt());
                fscBillMailItemRspBO.setUntaxAmt(fscInvoicePO.getUntaxAmt());
                fscBillMailItemRspBO.setInvoiceNo(fscInvoicePO.getInvoiceNo());
                fscBillMailItemRspBO.setInvoiceCode(fscInvoicePO.getInvoiceCode());
                fscBillMailItemRspBO.setBuyName(fscInvoicePO.getBuyName());
                fscBillMailItemRspBO.setTaxNo(fscInvoicePO.getTaxNo());
                fscBillMailItemRspBO.setBank(fscInvoicePO.getBank());
                fscBillMailItemRspBO.setAccount(fscInvoicePO.getAccount());
                fscBillMailItemRspBO.setAddress(fscInvoicePO.getAddress());
                fscBillMailItemRspBO.setPhone(fscInvoicePO.getPhone());
                fscBillMailItemRspBO.setCreateOperId(fscOrderInvoicePO.getBillOperId());
                fscBillMailItemRspBO.setCreateOperName(fscOrderInvoicePO.getBillOperName());
                fscBillMailItemRspBO.setReceiveName(fscOrderInvoicePO.getReceiveName());
                fscBillMailItemRspBO.setBillDate(fscInvoicePO.getBillDate());
                fscBillMailItemRspBO.setMailId(fscInvoicePO.getMailId());
                fscBillMailItemRspBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
                fscBillMailItemRspBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
                Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
                Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
                if (!StringUtils.isEmpty((Object)fscOrderInvoicePO.getInvoiceCategory())) {
                    fscBillMailItemRspBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscOrderInvoicePO.getInvoiceCategory())));
                }
                if (!StringUtils.isEmpty((Object)fscOrderInvoicePO.getInvoiceType())) {
                    fscBillMailItemRspBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscOrderInvoicePO.getInvoiceType()));
                }
                fscBillMailItemRspBO.setSignTime(fscOrderInvoicePO.getSignTime());
                fscBillMailItemRspBO.setSignOperName(fscOrderInvoicePO.getSignOperName());
                fscBillMailItemRspBO.setSignOperId(fscOrderInvoicePO.getSignOperId());
                if (null != fscOrderPO) {
                    fscBillMailItemRspBO.setFscOrderNo(fscOrderPO.getOrderNo());
                    fscBillMailItemRspBO.setFscOrderId(fscOrderPO.getFscOrderId());
                }
                fscBillMailItemList.add(fscBillMailItemRspBO);
            }
            fscBillMailItemRspBOS.addAll(fscBillMailItemList);
        }
    }
}

