/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscClaimReceiveYcStatusBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimReceiveYcStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimReceiveYcStatusBusiRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPushClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPushClaimDetailPo;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscClaimReceiveYcStatusBusiServiceImpl
implements FscClaimReceiveYcStatusBusiService {
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPushClaimDetailMapper fscPushClaimDetailMapper;

    @Override
    public FscClaimReceiveYcStatusBusiRspBO receiveYcStatus(FscClaimReceiveYcStatusBusiReqBO reqBO) {
        FscRecvClaimPO updatePo = new FscRecvClaimPO();
        updatePo.setClaimId(reqBO.getClaimId());
        updatePo.setPostingStatus(reqBO.getStatus());
        this.fscRecvClaimMapper.update(updatePo);
        FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
        claimDetailPO.setClaimId(reqBO.getClaimId());
        claimDetailPO.setPostingStatus(reqBO.getStatus());
        this.fscClaimDetailMapper.updateByClaimId(claimDetailPO);
        List claimDetailList = this.fscClaimDetailMapper.selectClaimInfoListByCliaimId(reqBO.getClaimId());
        List ycIdBos = claimDetailList.stream().filter(x -> Objects.nonNull(x.getSysSource()) && x.getSysSource() == 2 && Objects.nonNull(x.getOrderId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ycIdBos)) {
            HashMap<Long, FscPushClaimDetailPo> ycOrderMap = new HashMap<Long, FscPushClaimDetailPo>();
            for (FscClaimDetailBO bo : ycIdBos) {
                FscPushClaimDetailPo fscPushClaimDetailPo = (FscPushClaimDetailPo)ycOrderMap.get(bo.getOrderId());
                if (fscPushClaimDetailPo == null) {
                    fscPushClaimDetailPo = new FscPushClaimDetailPo();
                    fscPushClaimDetailPo.setFscOrderId(bo.getOrderId());
                    fscPushClaimDetailPo.setClaimAmt(bo.getClaimAmt());
                } else {
                    fscPushClaimDetailPo.setClaimAmt(fscPushClaimDetailPo.getClaimAmt().add(bo.getClaimAmt()));
                }
                ycOrderMap.put(bo.getOrderId(), fscPushClaimDetailPo);
            }
            int count = this.fscPushClaimDetailMapper.updateClaimAmtAddBatch(new ArrayList(ycOrderMap.values()));
            if (count != ycOrderMap.values().size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u4e1a\u8d22\u7ed3\u7b97\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
            }
            FscPushClaimDetailPo ycPo = new FscPushClaimDetailPo();
            ycPo.setFscOrderIds(ycIdBos.stream().map(y -> y.getOrderId()).collect(Collectors.toList()));
            ycPo.setChangeOccupyState(Integer.valueOf(0));
            this.fscPushClaimDetailMapper.updateByChanges(ycPo);
        }
        FscClaimReceiveYcStatusBusiRspBO rspBO = new FscClaimReceiveYcStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String isSettleOrYuShou(FscClaimDetailPO fscClaimDetailPO) {
        if (fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.TRAFFIC_SERVICE_FEE_SETTLE_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.RECRUITING_AGENT_SETTLE_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.TRANSACTION_SERVICE_FEE_SETTLE_CLAIM.getCode())) {
            return "1";
        }
        if (fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode()) || fscClaimDetailPO.getClaimType().equals(FscClaimTypeEnum.RECRUITING_AGENT_MARGIN_CLAIM.getCode())) {
            return "2";
        }
        return "3";
    }
}

