/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceBillFallbackExtBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceBillFallbackServiceExtRspBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceBillFallbackServiceExtReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceBillFallbackExtBusiServiceImpl
implements FscFinanceBillFallbackExtBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBillFallbackExtBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;

    @Override
    public FscFinanceBillFallbackServiceExtRspBO dealBillFallback(FscFinanceBillFallbackServiceExtReqBo reqBo) {
        FscFinanceBillFallbackServiceExtRspBO rspBaseBO = new FscFinanceBillFallbackServiceExtRspBO();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(Long.valueOf(reqBo.getBillId()));
        FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (po == null) {
            return this.dealChargeBack(reqBo);
        }
        if (!po.getOrderState().equals(FscConstants.FscPayOrderState.PAYING)) {
            throw new FscBusinessException("\u5931\u8d25", "\u5f53\u524d\u4ed8\u6b3e\u5355\u72b6\u6001\u4e0d\u4e3a\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5\uff01");
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(po.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(po.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", 4);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        log.debug("\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        log.debug("\u72b6\u6001\u6d41\u8f6c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
        if (!Objects.equals(fscOrderStatusFlowAtomRspBO.getRespCode(), "0000")) {
            rspBaseBO.setRespCode("190000");
            rspBaseBO.setRespDesc(fscOrderStatusFlowAtomRspBO.getRespDesc());
            return rspBaseBO;
        }
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(po.getFscOrderId());
        fscOrderFinancePO.setExt2(reqBo.getBackRemark());
        fscOrderFinancePO.setPushFinanceStatus(Integer.valueOf(3));
        int result = this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
        if (result < 1) {
            rspBaseBO.setRespCode("190000");
            rspBaseBO.setRespDesc("\u5931\u8d25");
            return rspBaseBO;
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u6210\u529f");
        return rspBaseBO;
    }

    private FscFinanceBillFallbackServiceExtRspBO dealChargeBack(FscFinanceBillFallbackServiceExtReqBo reqBo) {
        FscAccountChargePO chargePO = new FscAccountChargePO();
        chargePO.setChargeId(Long.valueOf(reqBo.getBillId()));
        chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
        if (chargePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f\uff01");
        }
        if (!FscConstants.AuditStatus.PAY_IN.equals(chargePO.getAuditStatus())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01");
        }
        FscAccountChargePO updateChargePO = new FscAccountChargePO();
        updateChargePO.setChargeId(chargePO.getChargeId());
        updateChargePO.setAuditStatus(FscConstants.AuditStatus.FINANCE_REJECT);
        this.fscAccountChargeMapper.update(updateChargePO);
        FscOrderFinancePO updateFscOrderFinance = new FscOrderFinancePO();
        updateFscOrderFinance.setFscOrderId(chargePO.getChargeId());
        updateFscOrderFinance.setExt2(reqBo.getBackRemark());
        updateFscOrderFinance.setPushFinanceStatus(FscConstants.PushFinanceStatus.RETURN);
        this.fscOrderFinanceMapper.updateById(updateFscOrderFinance);
        FscFinanceBillFallbackServiceExtRspBO rspBO = new FscFinanceBillFallbackServiceExtRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

