/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscMerchantOrPayChannelEnableBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantOrPayChannelEnableBusiReqBo;
import com.tydic.fsc.common.busi.bo.FscMerchantOrPayChannelEnableBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeeChannelPO;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscMerchantOrPayChannelEnableBusiServiceImpl
implements FscMerchantOrPayChannelEnableBusiService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscMerchantOrPayChannelEnableBusiRspBo merchantOrPayChannelEnable(FscMerchantOrPayChannelEnableBusiReqBo reqBo) {
        if (reqBo.getBusiType() == 0) {
            FscMerchantPO fscMerchantPO = new FscMerchantPO();
            fscMerchantPO.setMerchantId(reqBo.getId());
            fscMerchantPO.setEnable(reqBo.getOperType());
            fscMerchantPO.setUpdateOperId(reqBo.getUserName());
            fscMerchantPO.setUpdateOperName(reqBo.getName());
            fscMerchantPO.setUpdateTime(new Date());
            int i = this.fscMerchantMapper.updateEnableMerchant(fscMerchantPO);
            if (i < 0) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5546\u6237\u8868\u5931\u8d25");
            }
            FscMerchantPO merchantQueryPO = new FscMerchantPO();
            merchantQueryPO.setMerchantId(reqBo.getId());
            merchantQueryPO.setPayBusiSceneRangeLike("4");
            merchantQueryPO.setExceptionFlag(Integer.valueOf(1));
            FscMerchantPO modelBy = this.fscMerchantMapper.getModelBy(merchantQueryPO);
            if (modelBy != null && modelBy.getPayObjId() != null) {
                if (reqBo.getOperType() == 0 && modelBy.getParentId() != null) {
                    FscMerchantPO mainMerchantQueryPO = new FscMerchantPO();
                    mainMerchantQueryPO.setMerchantId(modelBy.getParentId());
                    FscMerchantPO parent = this.fscMerchantMapper.getModelBy(mainMerchantQueryPO);
                    FscAccountPO accountPO = new FscAccountPO();
                    if (parent != null && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(parent.getPayType())) {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(parent.getCompanyCreditAmount());
                        accountPO.setUnionCreditAmount(parent.getUnionCreditAmount());
                        accountPO.setCompanyOverdraft(BigDecimal.ZERO);
                        accountPO.setUnionOverdraft(BigDecimal.ZERO);
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    } else if (parent != null && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(parent.getPayType())) {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(BigDecimal.ZERO);
                        accountPO.setUnionCreditAmount(BigDecimal.ZERO);
                        accountPO.setCompanyOverdraft(parent.getCompanyOverdraft());
                        accountPO.setUnionOverdraft(parent.getUnionOverdraft());
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    } else {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(BigDecimal.ZERO);
                        accountPO.setUnionCreditAmount(BigDecimal.ZERO);
                        accountPO.setCompanyOverdraft(BigDecimal.ZERO);
                        accountPO.setUnionOverdraft(BigDecimal.ZERO);
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    }
                } else if (reqBo.getOperType() == 1) {
                    FscAccountPO accountPO = new FscAccountPO();
                    if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(modelBy.getPayType())) {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(modelBy.getCompanyCreditAmount());
                        accountPO.setUnionCreditAmount(modelBy.getUnionCreditAmount());
                        accountPO.setCompanyOverdraft(BigDecimal.ZERO);
                        accountPO.setUnionOverdraft(BigDecimal.ZERO);
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    } else if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(modelBy.getPayType())) {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(BigDecimal.ZERO);
                        accountPO.setUnionCreditAmount(BigDecimal.ZERO);
                        accountPO.setCompanyOverdraft(modelBy.getCompanyOverdraft());
                        accountPO.setUnionOverdraft(modelBy.getUnionOverdraft());
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    } else {
                        accountPO.setOrgId(modelBy.getPayObjId());
                        accountPO.setBusiType("4");
                        accountPO.setCompanyCreditAmount(BigDecimal.ZERO);
                        accountPO.setUnionCreditAmount(BigDecimal.ZERO);
                        accountPO.setCompanyOverdraft(BigDecimal.ZERO);
                        accountPO.setUnionOverdraft(BigDecimal.ZERO);
                        this.fscAccountMapper.updateCreditAndOverDraftByBusiType(accountPO);
                    }
                }
            }
        } else if (reqBo.getBusiType() == 1) {
            FscMerchantPayeeChannelPO fscMerchantPayeeChannelPO = new FscMerchantPayeeChannelPO();
            fscMerchantPayeeChannelPO.setId(reqBo.getId());
            fscMerchantPayeeChannelPO.setEnable(reqBo.getOperType());
            fscMerchantPayeeChannelPO.setOperId(reqBo.getUserId());
            fscMerchantPayeeChannelPO.setOperName(reqBo.getName());
            fscMerchantPayeeChannelPO.setOperTime(new Date());
            int i = this.fscMerchantPayeeChannelMapper.updateEnableMerchantPayeeChannel(fscMerchantPayeeChannelPO);
            if (i < 0) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5546\u6237\u652f\u4ed8\u6e20\u9053\u8868\u5931\u8d25");
            }
        }
        FscMerchantOrPayChannelEnableBusiRspBo rspBo = new FscMerchantOrPayChannelEnableBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

