/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscNewYcUpdateCashService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.FscNewYcPushReleaseCashAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNewYcPushReleaseCashAbilityRspBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscNewYcPushReleaseCashBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscNewYcPushReleaseCashBusiServiceImpl
implements FscNewYcPushReleaseCashBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscNewYcPushReleaseCashBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    private final Integer statusOk = 1;
    @Autowired
    private FscNewYcUpdateCashService fscNewYcUpdateCashService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;

    @Override
    public FscNewYcPushReleaseCashAbilityRspBO releaseCash(FscNewYcPushReleaseCashAbilityReqBO reqBO) {
        ArrayList<FscRecvClaimPO> fscRecvClaimPos = new ArrayList();
        fscRecvClaimPos = this.fscRecvClaimMapper.queryByIds(reqBO.getClaimIds());
        this.val(fscRecvClaimPos, reqBO);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(new Date());
        QryUnifySettleTokenAbilityReqBO tokenReqBO = new QryUnifySettleTokenAbilityReqBO();
        tokenReqBO.setUserId(reqBO.getAgentAccount());
        QryUnifySettleTokenAbilityRspBO tokenRspBO = this.fscUnifySettleTokenAbilityService.qryToken(tokenReqBO);
        if (!"0000".equals(tokenRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u83b7\u53d6token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenRspBO.getMsg());
        }
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            FscNewYcUpdateCashReqBO fscNewYcUpdateCashReqBO = new FscNewYcUpdateCashReqBO();
            try {
                if (po.getSerialNumberId() == null) {
                    throw new ZTBusinessException("\u94f6\u884c\u6d41\u6c34id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ArrayList<FscNewYcUpdateCashBO> bos = new ArrayList<FscNewYcUpdateCashBO>();
                FscNewYcUpdateCashBO fscNewYcUpdateCashBO = new FscNewYcUpdateCashBO();
                fscNewYcUpdateCashBO.setHEADER_ID(po.getSerialNumberId().toString());
                fscNewYcUpdateCashBO.setLAST_UPDATE_DATE(dateStr);
                bos.add(fscNewYcUpdateCashBO);
                fscNewYcUpdateCashReqBO.setBos(bos);
                fscNewYcUpdateCashReqBO.setToken(tokenRspBO.getData());
                FscNewYcUpdateCashRspBO fscNewYcUpdateCashRspBO = this.fscNewYcUpdateCashService.updateCash(fscNewYcUpdateCashReqBO);
                if (!fscNewYcUpdateCashRspBO.getRespCode().equals("0000")) {
                    this.saveLog(po, FscConstants.FscPushStatus.FAIL, JSONObject.toJSONString((Object)fscNewYcUpdateCashReqBO));
                    this.savePushStatus(po, FscConstants.pushState.NO_PUSH);
                    continue;
                }
                this.savePushStatus(po, FscConstants.pushState.SUCCESS);
                this.saveLog(po, FscConstants.FscPushStatus.SUCCESS, JSONObject.toJSONString((Object)fscNewYcUpdateCashReqBO));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveLog(po, FscConstants.FscPushStatus.FAIL, e.getMessage());
                this.savePushStatus(po, FscConstants.pushState.NO_PUSH);
            }
        }
        FscNewYcPushReleaseCashAbilityRspBO rspBO = new FscNewYcPushReleaseCashAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(List<FscRecvClaimPO> fscRecvClaimPos, FscNewYcPushReleaseCashAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscRecvClaimPos) || reqBO.getClaimIds().size() != fscRecvClaimPos.size()) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u5355\u76f8\u5173\u4fe1\u606f");
        }
        for (FscRecvClaimPO po : fscRecvClaimPos) {
            if (!FscClaimRecvStatusEnum.DELETE.getCode().equals(po.getRecvStatus())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u6536\u6b3e\u72b6\u6001\u5f02\u5e38\u4e0d\u4e3a\u5220\u9664\u72b6\u6001");
            }
            if (this.statusOk.equals(po.getStatus())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u7684\u63a8\u9001\u72b6\u6001\u662f\u6210\u529f\uff0c\u4e0d\u80fd\u518d\u91cd\u590d\u63a8\u9001");
            }
            if (po.getSerialNumberId() != null) continue;
            throw new ZTBusinessException("\u94f6\u884c\u6d41\u6c34id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveLog(FscRecvClaimPO fscRecvClaimPo, Integer status, String jsonStr) {
        try {
            FscPushLogPO fscPushLogPo = new FscPushLogPO();
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimPo.getClaimId());
            fscPushLogPo.setObjectNo(fscRecvClaimPo.getClaimNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            fscPushLogPo.setObjData(jsonStr);
            int count = this.fscPushLogMapper.insert(fscPushLogPo);
            if (count == 0) {
                throw new ZTBusinessException("\u5b58\u50a8\u5931\u8d25\uff0c\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u7684\u6761\u6570\u4e3a0");
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(FscRecvClaimPO po, int i) {
        FscRecvClaimPO updateVo = new FscRecvClaimPO();
        updateVo.setClaimId(po.getClaimId());
        updateVo.setStatus(Integer.valueOf(i));
        this.fscRecvClaimMapper.update(updateVo);
    }
}

