/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.busi.api.FscRefundPayClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundPayClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundPayClaimConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayClaimDetailPO;
import com.tydic.fsc.po.FscPayClaimPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRefundPayClaimConfirmBusiServiceImpl
implements FscRefundPayClaimConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundPayClaimConfirmBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private FscPayClaimMapper fscPayClaimMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscBillPayRefundConfirmBusiService fscBillPayRefundConfirmBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscRefundPayClaimConfirmBusiRspBO dealRefundPayClaimConfirm(FscRefundPayClaimConfirmBusiReqBO reqBO) {
        int count;
        boolean isClaim;
        reqBO.setClaimDetailList(this.resolvReq(reqBO));
        log.debug("\u9000\u6b3e\u8ba4\u9886\u786e\u8ba4\u89e3\u6790\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        if (CollectionUtils.isEmpty(reqBO.getClaimDetailList())) {
            FscRefundPayClaimConfirmBusiRspBO busiRspBO = new FscRefundPayClaimConfirmBusiRspBO();
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
            return busiRspBO;
        }
        FscPayClaimPO fscPayClaimPo = this.fscPayClaimMapper.queryById(reqBO.getClaimId());
        if (fscPayClaimPo == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        BigDecimal refundClaimAmt = BigDecimal.ZERO;
        ArrayList<FscPayClaimDetailPO> updateClaimDetailList = new ArrayList<FscPayClaimDetailPO>();
        ArrayList<FscPayClaimDetailPO> addClaimDetailList = new ArrayList<FscPayClaimDetailPO>();
        ArrayList<FscPayClaimRefundPO> subPayClaimRefundList = new ArrayList<FscPayClaimRefundPO>();
        ArrayList<FscPayClaimRefundPO> addPayClaimRefundList = new ArrayList<FscPayClaimRefundPO>();
        ArrayList<Object> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)fscPayClaimPo.getSettleNo()) && fscPayClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(fscPayClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)fscPayClaimPo.getSettleNo())) {
            settleNoList.add(fscPayClaimPo.getSettleNo());
        }
        for (FscClaimDetailBO detailBO : reqBO.getClaimDetailList()) {
            if (detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.UNCHANGE) || detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.CANCEL) && detailBO.getClaimDetailId() == null) continue;
            this.valid(detailBO);
            refundClaimAmt = detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.CLAIMED) ? refundClaimAmt.add(detailBO.getClaimAmt()) : refundClaimAmt.subtract(detailBO.getCancelAmt());
            FscPayClaimRefundPO payClaimRefundPO = new FscPayClaimRefundPO();
            FscPayClaimDetailPO claimDetailPO = new FscPayClaimDetailPO();
            BeanUtils.copyProperties((Object)detailBO, (Object)claimDetailPO);
            claimDetailPO.setClaimId(reqBO.getClaimId());
            claimDetailPO.setPushStatus(FscConstants.FscPushStatus.NO_PUSH);
            claimDetailPO.setSysSource(FscSystemSourceEnum.YG.getCode());
            claimDetailPO.setRefundType(reqBO.getRefundType());
            claimDetailPO.setHandleUserId(reqBO.getYcUserId());
            claimDetailPO.setHandleUserName(reqBO.getYcPersonName());
            if (reqBO.getYcDeptId() != null) {
                claimDetailPO.setHandleDeptId(String.valueOf(reqBO.getYcDeptId()));
            }
            claimDetailPO.setHandleDeptName(reqBO.getYcDeptName());
            claimDetailPO.setRefundClaimType(detailBO.getRefundSourceType());
            if (FscConstants.RefundSourceType.ONE.equals(detailBO.getRefundSourceType())) {
                claimDetailPO.setRefundId(detailBO.getRefundShouldPayId());
                claimDetailPO.setPayClaimRefundId(detailBO.getRefundSourceId());
            }
            claimDetailPO.setStatus(Integer.valueOf("1"));
            payClaimRefundPO.setId(detailBO.getRefundSourceId());
            if (detailBO.getClaimDetailId() == null) {
                claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                if (FscConstants.RefundSourceType.TWO.equals(detailBO.getRefundSourceType())) {
                    FscPayClaimRefundPO refundPO = this.fscPayClaimRefundMapper.queryById(detailBO.getRefundSourceId());
                    claimDetailPO.setRefundId(refundPO.getRefundId());
                    claimDetailPO.setPayClaimRefundId(detailBO.getRefundSourceId());
                }
                addClaimDetailList.add(claimDetailPO);
                payClaimRefundPO.setClaimAmt(claimDetailPO.getClaimAmt());
                addPayClaimRefundList.add(payClaimRefundPO);
                if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
                settleNoList.add(detailBO.getFscOrderNo());
                continue;
            }
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                claimDetailPO.setClaimAmt(null);
                claimDetailPO.setAddClaimAmt(detailBO.getCancelAmt().negate());
                claimDetailPO.setStatus(Integer.valueOf("0"));
            } else if (FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) {
                claimDetailPO.setClaimAmt(null);
                claimDetailPO.setAddClaimAmt(detailBO.getClaimAmt());
            }
            updateClaimDetailList.add(claimDetailPO);
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                payClaimRefundPO.setClaimAmt(detailBO.getCancelAmt());
                subPayClaimRefundList.add(payClaimRefundPO);
            } else if (FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) {
                payClaimRefundPO.setClaimAmt(detailBO.getClaimAmt());
                addPayClaimRefundList.add(payClaimRefundPO);
            }
            if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
            settleNoList.remove(detailBO.getFscOrderNo());
        }
        if (fscPayClaimPo.getNoClaimAmt().subtract(refundClaimAmt).compareTo(reqBO.getNoClaimAmt()) != 0) {
            throw new FscBusinessException("198888", "\u672a\u8ba4\u9886\u91d1\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
        }
        FscPayClaimPO fscPayClaim = new FscPayClaimPO();
        fscPayClaim.setClaimId(reqBO.getClaimId());
        fscPayClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        boolean bl = isClaim = reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0;
        if (isClaim) {
            fscPayClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscPayClaim.setPayStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0 && reqBO.getNoClaimAmt().compareTo(fscPayClaimPo.getPayAmt()) != 0) {
            fscPayClaim.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscPayClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(fscPayClaimPo.getPayAmt()) == 0) {
            fscPayClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscPayClaim.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscPayClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscPayClaimMapper.updateByClaimId(fscPayClaim);
        if (!CollectionUtils.isEmpty(subPayClaimRefundList) && (count = this.fscPayClaimRefundMapper.updateClaimAmtBatchSub(subPayClaimRefundList)) != subPayClaimRefundList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscPayClaimDetailMapper.updateBatch(updateClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(addPayClaimRefundList) && (count = this.fscPayClaimRefundMapper.updateClaimAmtBatchAdd(addPayClaimRefundList)) != addPayClaimRefundList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList) && (count = this.fscPayClaimDetailMapper.insertBatch(addClaimDetailList)) != addClaimDetailList.size()) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(reqBO.getClaimId());
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setFscOrderId(reqBO.getClaimId());
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(reqBO.getClaimId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.CLAIM);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.CLAIM);
                attachmentPO.setCreateTime(new Date());
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setFormatType(attachmentBO.getFormatType());
                attachmentPO.setFileSize(attachmentBO.getFileSize());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscRefundPayClaimConfirmBusiRspBO busiRspBO = new FscRefundPayClaimConfirmBusiRspBO();
        busiRspBO.setClaim(isClaim);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private List<FscClaimDetailBO> resolvReq(FscRefundPayClaimConfirmBusiReqBO reqBO) {
        List haveIdList = reqBO.getClaimDetailList().stream().filter(t -> t.getClaimDetailId() != null).collect(Collectors.toList());
        Map<Long, List<FscClaimDetailBO>> listMap = haveIdList.stream().collect(Collectors.groupingBy(FscClaimDetailBO::getClaimDetailId));
        FscPayClaimDetailPO fscPayClaimDetailPO = new FscPayClaimDetailPO();
        fscPayClaimDetailPO.setClaimDetailIdList(new ArrayList<Long>(listMap.keySet()));
        List fscPayClaimDetailPOS = this.fscPayClaimDetailMapper.getList(fscPayClaimDetailPO);
        Map claimDetailPOMap = fscPayClaimDetailPOS.stream().collect(Collectors.toMap(FscPayClaimDetailPO::getClaimDetailId, Function.identity()));
        ArrayList<FscClaimDetailBO> rspClaimDetailBOList = new ArrayList<FscClaimDetailBO>();
        for (Long key : listMap.keySet()) {
            if (listMap.get(key).size() > 1) {
                BigDecimal claimAmt = BigDecimal.ZERO;
                BigDecimal cancelAmt = BigDecimal.ZERO;
                Date claimDate = null;
                Date cancelClaimDate = null;
                for (FscClaimDetailBO detailBO : listMap.get(key)) {
                    if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                        cancelAmt = cancelAmt.add(detailBO.getCancelAmt());
                        claimDate = detailBO.getClaimDate();
                        continue;
                    }
                    if (!FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) continue;
                    claimAmt = claimAmt.add(detailBO.getClaimAmt());
                    cancelClaimDate = detailBO.getCancelClaimDate();
                }
                FscClaimDetailBO claimDetailBO = listMap.get(key).get(0);
                claimDetailBO.setClaimDate(claimDate);
                claimDetailBO.setCancelClaimDate(cancelClaimDate);
                if (claimAmt.compareTo(cancelAmt) > 0) {
                    claimDetailBO.setClaimAmt(claimAmt.subtract(cancelAmt));
                    claimDetailBO.setCancelAmt(BigDecimal.ZERO);
                    claimDetailBO.setOperationType(FscConstants.FscClaimOperationType.CLAIMED);
                    rspClaimDetailBOList.add(claimDetailBO);
                    continue;
                }
                if (claimAmt.compareTo(cancelAmt) >= 0) continue;
                claimDetailBO.setClaimAmt(BigDecimal.ZERO);
                claimDetailBO.setCancelAmt(cancelAmt.subtract(claimAmt));
                claimDetailBO.setOperationType(FscConstants.FscClaimOperationType.CANCEL);
                rspClaimDetailBOList.add(claimDetailBO);
                continue;
            }
            FscClaimDetailBO detailBO = listMap.get(key).get(0);
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                rspClaimDetailBOList.add(detailBO);
                continue;
            }
            if (!FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) continue;
            if (((FscPayClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().compareTo(detailBO.getClaimAmt()) > 0) {
                detailBO.setCancelAmt(((FscPayClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().subtract(detailBO.getClaimAmt()));
                detailBO.setClaimAmt(BigDecimal.ZERO);
                detailBO.setOperationType(FscConstants.FscClaimOperationType.CANCEL);
                rspClaimDetailBOList.add(detailBO);
                continue;
            }
            if (((FscPayClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().compareTo(detailBO.getClaimAmt()) >= 0) continue;
            detailBO.setClaimAmt(detailBO.getClaimAmt().subtract(((FscPayClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt()));
            rspClaimDetailBOList.add(detailBO);
        }
        for (FscClaimDetailBO detailBO : reqBO.getClaimDetailList()) {
            if (detailBO.getClaimDetailId() != null) continue;
            rspClaimDetailBOList.add(detailBO);
        }
        return rspClaimDetailBOList;
    }

    private void valid(FscClaimDetailBO detailBO) {
        if (detailBO.getRefundSourceId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[refundSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getOrderCode() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[orderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (detailBO.getClaimDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f[claimDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public FscRefundPayClaimConfirmBusiRspBO dealOperationRefundPayClaimConfirm(FscRefundPayClaimConfirmBusiReqBO reqBO) {
        int count;
        boolean isClaim;
        reqBO.setClaimDetailList(this.resolvOperationReq(reqBO));
        log.debug("\u9000\u6b3e\u8ba4\u9886\u786e\u8ba4\u89e3\u6790\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        if (CollectionUtils.isEmpty(reqBO.getClaimDetailList())) {
            FscRefundPayClaimConfirmBusiRspBO busiRspBO = new FscRefundPayClaimConfirmBusiRspBO();
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
            return busiRspBO;
        }
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (fscRecvClaimPo.getIsSup() != null && !FscConstants.IsSup.REFUND.equals(fscRecvClaimPo.getIsSup())) {
            throw new FscBusinessException("198888", "\u5df2\u505a\u6536\u6b3e\u8ba4\u9886\u7684\u6536\u6b3e\u5355\u4e0d\u80fd\u505a\u9000\u6b3e\u8ba4\u9886\uff01");
        }
        BigDecimal refundClaimAmt = BigDecimal.ZERO;
        ArrayList<FscClaimDetailPO> updateClaimDetailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscClaimDetailPO> addClaimDetailList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscPayClaimRefundPO> subPayClaimRefundList = new ArrayList<FscPayClaimRefundPO>();
        ArrayList<FscPayClaimRefundPO> addPayClaimRefundList = new ArrayList<FscPayClaimRefundPO>();
        ArrayList<Object> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo()) && fscRecvClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(fscRecvClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo())) {
            settleNoList.add(fscRecvClaimPo.getSettleNo());
        }
        for (FscClaimDetailBO detailBO : reqBO.getClaimDetailList()) {
            if (detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.UNCHANGE) || detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.CANCEL) && detailBO.getClaimDetailId() == null) continue;
            this.valid(detailBO);
            refundClaimAmt = detailBO.getOperationType().equals(FscConstants.FscClaimOperationType.CLAIMED) ? refundClaimAmt.add(detailBO.getClaimAmt()) : refundClaimAmt.subtract(detailBO.getCancelAmt());
            FscPayClaimRefundPO payClaimRefundPO = new FscPayClaimRefundPO();
            FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
            BeanUtils.copyProperties((Object)detailBO, (Object)claimDetailPO);
            claimDetailPO.setClaimId(reqBO.getClaimId());
            claimDetailPO.setPushStatus(FscConstants.FscClaimPushStatus.NOT_PUSH);
            claimDetailPO.setSysSource(FscSystemSourceEnum.YG.getCode());
            claimDetailPO.setRefundType(reqBO.getRefundType());
            claimDetailPO.setRefundClaimType(detailBO.getRefundSourceType());
            claimDetailPO.setStatus("1");
            if (FscConstants.RefundSourceType.ONE.equals(detailBO.getRefundSourceType())) {
                claimDetailPO.setRefundId(detailBO.getRefundShouldPayId());
                claimDetailPO.setPayClaimRefundId(detailBO.getRefundSourceId());
            }
            payClaimRefundPO.setId(detailBO.getRefundSourceId());
            if (detailBO.getClaimDetailId() == null) {
                claimDetailPO.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                if (FscConstants.RefundSourceType.TWO.equals(detailBO.getRefundSourceType())) {
                    FscPayClaimRefundPO refundPO = this.fscPayClaimRefundMapper.queryById(detailBO.getRefundSourceId());
                    claimDetailPO.setRefundId(refundPO.getRefundId());
                    claimDetailPO.setPayClaimRefundId(detailBO.getRefundSourceId());
                }
                addClaimDetailList.add(claimDetailPO);
                payClaimRefundPO.setClaimAmt(claimDetailPO.getClaimAmt());
                addPayClaimRefundList.add(payClaimRefundPO);
                if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
                settleNoList.add(detailBO.getFscOrderNo());
                continue;
            }
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                claimDetailPO.setClaimAmt(null);
                claimDetailPO.setAddClaimAmt(detailBO.getCancelAmt().negate());
                claimDetailPO.setStatus("0");
            } else if (FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) {
                claimDetailPO.setClaimAmt(null);
                claimDetailPO.setAddClaimAmt(detailBO.getClaimAmt());
            }
            updateClaimDetailList.add(claimDetailPO);
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                payClaimRefundPO.setClaimAmt(detailBO.getCancelAmt());
                subPayClaimRefundList.add(payClaimRefundPO);
            } else if (FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) {
                payClaimRefundPO.setClaimAmt(detailBO.getClaimAmt());
                addPayClaimRefundList.add(payClaimRefundPO);
            }
            if (StringUtils.isEmpty((Object)detailBO.getFscOrderNo())) continue;
            settleNoList.remove(detailBO.getFscOrderNo());
        }
        if (fscRecvClaimPo.getNoClaimAmt().subtract(refundClaimAmt).compareTo(reqBO.getNoClaimAmt()) != 0) {
            throw new FscBusinessException("198888", "\u672a\u8ba4\u9886\u91d1\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
        }
        FscRecvClaimPO fscRecvClaim = new FscRecvClaimPO();
        fscRecvClaim.setClaimId(reqBO.getClaimId());
        fscRecvClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        fscRecvClaim.setIsSup(FscConstants.IsSup.REFUND);
        boolean bl = isClaim = reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0;
        if (isClaim) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0 && reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) != 0) {
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscRecvClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscRecvClaimMapper.update(fscRecvClaim);
        if (!CollectionUtils.isEmpty(subPayClaimRefundList) && (count = this.fscPayClaimRefundMapper.updateClaimAmtBatchSub(subPayClaimRefundList)) != subPayClaimRefundList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscClaimDetailMapper.updateClaimAmountBatch(updateClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(addPayClaimRefundList) && (count = this.fscPayClaimRefundMapper.updateClaimAmtBatchAdd(addPayClaimRefundList)) != addPayClaimRefundList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList) && (count = this.fscClaimDetailMapper.insertBatch(addClaimDetailList)) != addClaimDetailList.size()) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u9000\u6b3e\u7533\u8bf7\u660e\u7ec6\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002");
        }
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setClaimId(reqBO.getClaimId());
        List claimDetailList = this.fscClaimDetailMapper.getList(fscClaimDetailPO);
        List<Long> refundIdList = claimDetailList.stream().map(FscClaimDetailPO::getRefundId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        FscBillPayRefundConfirmBusiReqBO confirmBusiReqBO = (FscBillPayRefundConfirmBusiReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscBillPayRefundConfirmBusiReqBO.class);
        for (Long refundId : refundIdList) {
            confirmBusiReqBO.setRefundId(refundId);
            FscBillPayRefundConfirmBusiRspBO confirmBusiRspBO = this.fscBillPayRefundConfirmBusiService.dealPayRefundConfirm(confirmBusiReqBO);
            if ("0000".equals(confirmBusiRspBO.getRespCode())) continue;
            throw new FscBusinessException("198888", "\u9000\u6b3e\u5355\u786e\u8ba4\u5931\u8d25!" + confirmBusiRspBO.getRespDesc());
        }
        FscRefundPayClaimConfirmBusiRspBO busiRspBO = new FscRefundPayClaimConfirmBusiRspBO();
        busiRspBO.setClaim(isClaim);
        busiRspBO.setRefundIdList(refundIdList);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private List<FscClaimDetailBO> resolvOperationReq(FscRefundPayClaimConfirmBusiReqBO reqBO) {
        List haveIdList = reqBO.getClaimDetailList().stream().filter(t -> t.getClaimDetailId() != null).collect(Collectors.toList());
        Map<Long, List<FscClaimDetailBO>> listMap = haveIdList.stream().collect(Collectors.groupingBy(FscClaimDetailBO::getClaimDetailId));
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setClaimDetailIdList(new ArrayList<Long>(listMap.keySet()));
        List fscClaimDetailPOS = this.fscClaimDetailMapper.getList(fscClaimDetailPO);
        Map claimDetailPOMap = fscClaimDetailPOS.stream().collect(Collectors.toMap(FscClaimDetailPO::getClaimDetailId, Function.identity()));
        ArrayList<FscClaimDetailBO> rspClaimDetailBOList = new ArrayList<FscClaimDetailBO>();
        for (Long key : listMap.keySet()) {
            if (listMap.get(key).size() > 1) {
                BigDecimal claimAmt = BigDecimal.ZERO;
                BigDecimal cancelAmt = BigDecimal.ZERO;
                Date claimDate = null;
                Date cancelClaimDate = null;
                for (FscClaimDetailBO detailBO : listMap.get(key)) {
                    if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                        cancelAmt = cancelAmt.add(detailBO.getCancelAmt());
                        claimDate = detailBO.getClaimDate();
                        continue;
                    }
                    if (!FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) continue;
                    claimAmt = claimAmt.add(detailBO.getClaimAmt());
                    cancelClaimDate = detailBO.getCancelClaimDate();
                }
                FscClaimDetailBO claimDetailBO = listMap.get(key).get(0);
                claimDetailBO.setClaimDate(claimDate);
                claimDetailBO.setCancelClaimDate(cancelClaimDate);
                if (claimAmt.compareTo(cancelAmt) > 0) {
                    claimDetailBO.setClaimAmt(claimAmt.subtract(cancelAmt));
                    claimDetailBO.setCancelAmt(BigDecimal.ZERO);
                    claimDetailBO.setOperationType(FscConstants.FscClaimOperationType.CLAIMED);
                    rspClaimDetailBOList.add(claimDetailBO);
                    continue;
                }
                if (claimAmt.compareTo(cancelAmt) >= 0) continue;
                claimDetailBO.setClaimAmt(BigDecimal.ZERO);
                claimDetailBO.setCancelAmt(cancelAmt.subtract(claimAmt));
                claimDetailBO.setOperationType(FscConstants.FscClaimOperationType.CANCEL);
                rspClaimDetailBOList.add(claimDetailBO);
                continue;
            }
            FscClaimDetailBO detailBO = listMap.get(key).get(0);
            if (FscConstants.FscClaimOperationType.CANCEL.equals(detailBO.getOperationType())) {
                rspClaimDetailBOList.add(detailBO);
                continue;
            }
            if (!FscConstants.FscClaimOperationType.CLAIMED.equals(detailBO.getOperationType())) continue;
            if (((FscClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().compareTo(detailBO.getClaimAmt()) > 0) {
                detailBO.setCancelAmt(((FscClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().subtract(detailBO.getClaimAmt()));
                detailBO.setClaimAmt(BigDecimal.ZERO);
                detailBO.setOperationType(FscConstants.FscClaimOperationType.CANCEL);
                rspClaimDetailBOList.add(detailBO);
                continue;
            }
            if (((FscClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt().compareTo(detailBO.getClaimAmt()) >= 0) continue;
            detailBO.setClaimAmt(detailBO.getClaimAmt().subtract(((FscClaimDetailPO)claimDetailPOMap.get(detailBO.getClaimDetailId())).getClaimAmt()));
            rspClaimDetailBOList.add(detailBO);
        }
        for (FscClaimDetailBO detailBO : reqBO.getClaimDetailList()) {
            if (detailBO.getClaimDetailId() != null) continue;
            rspClaimDetailBOList.add(detailBO);
        }
        return rspClaimDetailBOList;
    }
}

