/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscSignBackFillInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.FscSignBackFillInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSignBackFillInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSignBackFillInvoiceBusiServiceImpl
implements FscSignBackFillInvoiceBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    @Override
    public FscSignBackFillInvoiceBusiRspBO dealSignBackFillInvoice(FscSignBackFillInvoiceBusiReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(reqBO.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (orderPo == null) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355id[" + reqBO.getFscOrderId() + "]\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setInvoiceNo(orderPo.getInvoiceNo());
        fscShouldPayPO.setFscOrderId(orderPo.getFscOrderId());
        int result = this.fscShouldPayMapper.updateInvoiceNoByFscOrderId(fscShouldPayPO);
        if (result == 0) {
            FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
            fscInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
            List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getListWithInvoice(fscInvoiceItemPO);
            if (!CollectionUtils.isEmpty((Collection)fscInvoiceItemPOList)) {
                List orderIds = fscInvoiceItemPOList.stream().map(FscInvoiceItemPO::getOrderId).collect(Collectors.toList());
                HashMap<String, FscInvoiceItemPO> invoiceItemPOMap = new HashMap<String, FscInvoiceItemPO>();
                for (FscInvoiceItemPO itemPO : fscInvoiceItemPOList) {
                    invoiceItemPOMap.put(itemPO.getOrderId().toString(), itemPO);
                }
                for (Long orderId : orderIds) {
                    FscInvoiceItemPO invoiceItemPO = (FscInvoiceItemPO)invoiceItemPOMap.get(orderId.toString());
                    fscShouldPayPO.setOrderId(orderId);
                    fscShouldPayPO.setInvoiceNo(invoiceItemPO.getInvoiceNo());
                    fscShouldPayPO.setPayeeIdNot(this.operationOrgId);
                    this.fscShouldPayMapper.updateInvoiceNoByOrderId(fscShouldPayPO);
                }
            }
        }
        List<Long> billOrderIds = this.backFillBillInvoice(orderPo);
        FscSignBackFillInvoiceBusiRspBO rspBO = new FscSignBackFillInvoiceBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFscOrderIds(billOrderIds);
        return rspBO;
    }

    private List<Long> backFillBillInvoice(FscOrderPO fscOrderPO) {
        List<Long> billOrderIds = new ArrayList<Long>();
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setRelId(fscOrderPO.getFscOrderId());
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1000000);
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if (!CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)inspectionDetailsList.getRows().get(0);
            billOrderIds = FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(uocInspectionDetailsListBO.getPayType()) && FscConstants.MerchantPayNodeRule.SIGN.equals(uocInspectionDetailsListBO.getProPayNodeRule()) ? this.fscOrderMapper.getBillOrderIdsByShouldPay(fscOrderPO) : this.fscOrderMapper.getBillOrderIdsByAdvance(fscOrderPO);
        }
        if (!CollectionUtils.isEmpty(billOrderIds)) {
            for (Long billOrderId : billOrderIds) {
                FscOrderPO billOrder = new FscOrderPO();
                billOrder.setFscOrderId(billOrderId);
                billOrder.setInvoiceNo(fscOrderPO.getInvoiceNo());
                billOrder.setInvoiceCode(fscOrderPO.getInvoiceCode());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
        return billOrderIds;
    }
}

